
/*
 *	mini keyframing replayer - brioche/aspirine
 */

#include "ray.h"

/*
int keyf_load( const char *filename, SCENE *scn )
{
	FILE *fd;
	static char id[64];
	float t;

	if ( !(fd = fopen( filename, "rt" )) )
		return 0;

	scn->num_keys = 0;
	scn->keys = (KEY *)malloc( 100 );

	while ( !feof( fd ) ) {
		fscanf( fd, "%s\n\t%f", id, &t );
				
		scn->keys[scn->num_keys] = t;	

		if ( !strcmp( id, "rvp" ) ) {
			scn->objects[scn->nun_keys].id = KEY_SETRVP;
			if ( fscanf( fd, "\t%f\t%f\t%f\n", &scn->keys[scn->num_keys].x
               		     &scn->keys[scn->num_keys].y, &scn->keys[scn->num_keys].z ) != 3 )
				fprintf( stderr, "keyf: load error\n" );
			else
				scn->num_keys++;
		} else if ( !strcmp( id, "lap" ) ) {
			scn->objects[scn->nun_keys].id = KEY_SETLAP;
			if ( fscanf( fd, "\t%f\t%f\t%f\n", &scn->keys[scn->num_keys].x
               		     &scn->keys[scn->num_keys].y, &scn->keys[scn->num_keys].z ) != 3 )
				fprintf( stderr, "keyf: load error\n" );
			else
				scn->num_keys++;
		} else if ( !strcmp( id, "roll" ) ) {
			scn->objects[scn->nun_keys].id = KEY_SETROLL;
			if ( fscanf( fd, "\t%f\n", &scn->keys[scn->num_keys].x ) != 1 )
				fprintf( stderr, "keyf: load error\n" );
			else
				scn->num_keys++;
		} else
			fprintf( stderr, "keyf: unknown key_id encountered" );
	}

	fclose( fd );       

	return 1;
}
*/

int keyf_load( const char *filename, SCENE *scn )
{
	FILE *fd;
	static char id[64];
	float t;
	KEY *kptr;

	if ( !(fd = fopen( filename, "rt" )) )
		return 0;

	scn->num_keys = scn->curr_key = 0;
	/*
	kptr = scn->keys = (KEY *)malloc( 100 );
	*/
	kptr = scn->keys;

	while ( !feof( fd ) ) {
		if ( fscanf( fd, "%f\n\t%f\t%f\t%f\n\t%f\t%f\t%f\n\t%f\n",
				&kptr->time, 
				&kptr->cam.rvp.x, &kptr->cam.rvp.y, &kptr->cam.rvp.z,
				&kptr->cam.lap.x, &kptr->cam.lap.y, &kptr->cam.lap.z,
				&kptr->cam.roll ) != 8 ) {
			fprintf( stderr, "keyf: parse error\n" );
		} else {
			/*
			fprintf( stderr, "keyf: key %d read (%f)\n", scn->num_keys, kptr->time );
			*/
			kptr++;
			scn->num_keys++;
		}
	}

	fclose( fd );       

	return 1;	
}

/* we can only handle 1 scene at a time... hey, this is not POV3000! */
static VECTOR d_rvp, d_lap;
static float d_roll;
static float delta = 0;
static int prev_key;

int end_of_track;

void keyf_init( SCENE *scn )
{
	scn->curr_key = 0;
	scn->cam = scn->keys->cam;
	delta = 0;
	end_of_track = 0;
}

/* i don't give a shit about quaternions and splines... linear interpolation rules! */
void keyf_update( SCENE *scn )
{
	static float tmp;
	static CAMERA *c1, *c2;

	/* */
	if ( delta == 0 ) {

		scn->curr_key++;
		if ( scn->curr_key == scn->num_keys ) {
			end_of_track = 1;
			return;
		}

		delta = scn->keys[scn->curr_key].time-scn->keys[scn->curr_key-1].time;
		if ( delta )
			tmp = 1.0/delta;
		c1 = &scn->keys[scn->curr_key-1].cam;
		c2 = &scn->keys[scn->curr_key].cam;
		d_rvp.x = (c2->rvp.x-c1->rvp.x)*tmp;
		d_rvp.y = (c2->rvp.y-c1->rvp.y)*tmp;
		d_rvp.y = (c2->rvp.y-c1->rvp.y)*tmp;
		d_lap.x = (c2->lap.x-c1->lap.x)*tmp;
		d_lap.y = (c2->lap.y-c1->lap.y)*tmp;
		d_lap.y = (c2->lap.y-c1->lap.y)*tmp;
		d_roll = (c2->roll-c1->roll)*tmp;
		scn->cam = scn->keys[scn->curr_key-1].cam;
	}

	/*
	fprintf( stderr, "key=%d, delta=%f\n", scn->curr_key, delta );
	*/
	
	/* proceed with interpolation */
	if ( delta >= 0 ) {
		scn->cam.rvp.x += d_rvp.x;	
		scn->cam.rvp.y += d_rvp.y;	
		scn->cam.rvp.z += d_rvp.z;	
		scn->cam.lap.x += d_lap.x;	
		scn->cam.lap.y += d_lap.y;	
		scn->cam.lap.z += d_lap.z;	
		scn->cam.roll += d_roll;	
		delta--;
	};
}

