
/*
 *
 *      M O D E L - P L A N E
 *
 */

#include "ray.h"

float plane_distance( RAY ray, MODEL_PLANE obj )
{
        float v, v1, k;

        v1 = obj.A * ray.dir.x + obj.B * ray.dir.y + obj.C * ray.dir.z;

        if( v1 == 0.0f )
                return INFINITE;

        v = -obj.D-obj.A*ray.loc.x-obj.B*ray.loc.y-obj.C*ray.loc.z;
        k = v/v1;

        return k > 0.0f ? k : INFINITE;
}

void plane_hitnormal( MODEL_PLANE obj, VECTOR hit, VECTOR *norm )
{
        norm->x = obj.A;
        norm->y = obj.B;
        norm->z = obj.C;
}

RGB plane_text_hitcolor( MODEL_PLANE_TEXT obj, VECTOR hit )
{
        int u, v;
        u = (int)fabs(hit.x*0.3);
        v = (int)fabs(hit.z*0.3);
	if ( u < 0 )
		u = 0;
	if ( v < 0 )
		v = 0;
	if ( u > 256 )
		u %= 256;
	if ( v > 256 )
		v %= 256;
        return obj.texmap[(int)v*256+(int)u];
}
