/*
code for end credits of loop


swivel | CSR
swivel@csrmusic.org
*/

#include	<stdio.h>
#include	"gfx.h"
#include	"sprite.h"
#include	"../prefs.h"

extern int effekt;
extern int noexit;

void credits(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
	struct PALETTE	*pal, *active_pal;
	struct SPRITE	*sprite;
	char		*pals[5];    /* guest / swivel / acell / troll / csr */
	char		*sprites[5]; /* guest / swivel / acell / troll / csr */
	unsigned char 	*blankcolors;
	int 		fadeleft;
	int 		i = 0;
	int		numcreds = 5;

	noexit = 1;

	active_pal = get_palette();

	sprites[0] = "data/dominus.img";
	sprites[1] = "data/swivel-photo.img";
	sprites[2] = "data/acell-photo.img";
	sprites[3] = "data/troll-photo.img";
	sprites[4] = "data/csr1.img";

	pals[0] = "data/dominus.pal";
	pals[1] = "data/swivel-photo.pal";
	pals[2] = "data/acell-photo.pal";
	pals[3] = "data/troll-photo.pal";
	pals[4] = "data/csr1.pal";

	blankcolors = (unsigned char *)calloc(1, 256 * 3);
	pal = load_palette(pals[0]);
	sprite = load_sprite(sprites[0]);


	while(i < numcreds) {
		i++;

		fadeleft = 1;
		while(fadeleft) {
			fadeleft = fade_pal(active_pal->data, blankcolors, 256, 10);
			set_palette(active_pal);
			usleep(1);
		}

		memset(screen, 0, VWIDTH * VHEIGHT);
		draw_sprite_center(sprite, screen, VWIDTH, VHEIGHT);
		draw_screen(screen);
		unload_sprite(sprite);

		fadeleft = 1;
		while(fadeleft) {
			fadeleft = fade_pal(active_pal->data, pal->data, pal->quantity, 10);
			set_palette(active_pal);
			usleep(1);
			if(!fadeleft)
				unload_palette(pal);
		}

		if( i < numcreds ) {
			sprite = load_sprite(sprites[i]);
			pal = load_palette(pals[i]);
		}

		while(noexit) {
			usleep(100);
		}
		noexit = 1;
	}

	fadeleft = 1;
	while(fadeleft) {
		fadeleft = fade_pal(active_pal->data, blankcolors, 256, 2);
		set_palette(active_pal);
		usleep(2);
	}


	unload_palette(active_pal);
	free(blankcolors);
	return;
}
