
/*
psychadelic scene with music synched spiral and stuph

swivel | CSR
swivel@csrmusic.org
*/

#include	"sprite.h"
#include	"prefs.h"
#include	"spiral.h"
#include	"fastmath.h"


extern int effekt;
extern int noexit;

void genpal(struct PALETTE *pal, int rwt, int gwt, int bwt)
{
	int	quantity, i;

	int	rR = rwt;
	int 	rG = gwt;
	int	rB = bwt;

	rwt = rwt >> 1;
	gwt = gwt >> 1;
	bwt = bwt >> 1;

	quantity = pal->quantity;

	for(i = 0; i < quantity; i++) {

		pal->data[i * 3] = 	abs(255 * fastsin(rR));
		pal->data[i * 3 + 1] = 	abs(255 * fastsin(rG));
		pal->data[i * 3 + 2] = 	abs(255 * fastsin(rB));

		rR += rwt;
		rG += gwt;
		rB += bwt;
	}
}


void strobe(unsigned char *dest, int width, int height)
{
	int	i = width * height;	

	memset(dest, 255, i);
}

void psychadelic(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
        struct PALETTE 	*pal, *active_pal;
	int 		flash = 0;
	
	unsigned char 	*temp;
	unsigned int	i = 0;
	int		fadeleft = 0;

	double		p = 0;
	double		pmove = -.91;
	double		q = 0;
	double		z = .01;

	effekt = 0;
	noexit  = 1;

	active_pal = get_palette();
        pal = load_palette("data/newpal.pal");

	strobe(temp2, VWIDTH, VHEIGHT);

	while(noexit) {

		if(fadeleft) {
			fadeleft=fade_pal(active_pal->data, pal->data, pal->quantity, 7);
			set_palette(active_pal);
		}

		if(flash) {
			draw_screen(temp2);
			flash--;
		} else {

			spiral(screen, 360, p, q, z, z, 
				VWIDTH, VHEIGHT, 
				VWIDTH / 2, VHEIGHT/ 2);

			blur_opt(screen, temp1, VWIDTH * VHEIGHT);

			temp = temp1;
			temp1 = screen;
			screen = temp;


			draw_screen(screen);
		}



		if(effekt) {
			effekt = 0;
			if(pmove < 0) pmove = .091;
			else pmove = -.091;

			genpal(pal, rand() >> 28, rand() >> 28, rand() >> 28);

			fadeleft = 1;

			flash = 6;
		}


		usleep(3);
			
		p += pmove;
		z += .0005;
		q += .0008;
	}


	unload_palette(active_pal);
	unload_palette(pal);

	return;
}

