/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>

#include "3d.h"
#include "video.h"
#include "misc.h"
#include "parts.h"
#include "image.h"
#include "smooth.h"
#include "music.h"

#define FADE_SEC        10
#define FADE_OUT_SEC    15
#define ZERO_SCALE_SEC  5
#define ROT_PER_SEC     0.07
#define N_CUBES         100
#define COPY_SEC        4
#define PIC_SEC         1
#define END_SEC         4

void partCubes( uint secs )
{
  Image texture( "gold2.raw" ),
        texture1( "oldmetl1.raw" ),
        colorpic( "circle1.raw", STRETCH_SCREEN );
  dither = new Image( "dither4.raw" );
//        indy( "indy01.rle", STRETCH_BIT0 );
  FacedObject cube(NO_SHADOW|PERSPECT/*|TWO_SIDE*/);
  cube.ImportASC( "cryst.asc", 0,
                    VID_MAX_SIZE_Y*0.04, &texture, MAP_XY|MAP_SCALE);
  cube.Prepare();
  cube.RotateTo( cosSteps/20,0,0 );
  cube.SetLightTo( 0,0, 1,0 );
  TCollection cubes;
  Image* texture2 = new Image( vidSizeX, vidSizeY, vidBytesPerLine, 0, color );
  FacedObject* spider = new FacedObject(NO_SHADOW|PERSPECT);
  spider->ImportASC( "spider1.asc", 0,
                    VID_MAX_SIZE_Y*0.7, &texture1, MAP_XZ|MAP_SCALE);
  spider->SetLightTo( 0,0, 0.8,0 );
  spider->Prepare();
  spider->RotateTo( -cosSteps/4,cosSteps/8,0 );
//  spider->MoveAbs( 0,0,MAX_Z/2 );
  cubes.Insert(spider);
  vidClearPage(bw,30);
  memsetw( zbuffer, MIN_Z, vidPageSize );
  vidCopyPage( color, colorpic.data );
  int start = miscTimer(), time=start, cube_time=time,
      copy_time=time+FADE_SEC*miscTimerRes, prevtime=time;
  int r=0;
  bool pal_set=false;
  do {
    prevtime = time;
    time = miscTimer();
    if( time > secs*miscTimerRes ) time = secs*miscTimerRes;
    memsetw( zbuffer, MIN_Z, vidPageSize );
    while( cube_time < time && time-start < FADE_SEC*miscTimerRes ) {
      FacedObject* c = new FacedObject(cube);
      c->RotateTo( -cosSteps/10, rand()%cosSteps*2, 0 );
      c->MoveAbs( 0,
        -VID_MAX_SIZE_Y/10+VID_MAX_SIZE_Y/20-rand()%(VID_MAX_SIZE_Y/10),
        MAX_Z/5+rand()%(MAX_Z/2) );
      cubes.Insert(c);
      cube_time += FADE_SEC*miscTimerRes/N_CUBES;
    }
    if( time-start < FADE_SEC*miscTimerRes ) {
//      memsetw( zbuffer, MIN_Z, vidPageSize );
      vidCopyPage( color, colorpic.data );
      double scale = (time-start)/miscTimerRes/FADE_SEC;
      int i;
      for( i=0; i<cubes.Count; i++ ) {
        FacedObject* c = (FacedObject*)cubes.At(i);
        c->ScaleTo( scale, scale, scale );
      }
    }
    else {
      if( time < (secs-FADE_OUT_SEC)*miscTimerRes ) {
        vidCopyPage( color, colorpic.data );
/*
        while( copy_time < time ) {
          int tmp=miscTimer();
          RGB tmp_pal[256];
          int black=vidBlackColor;
          memcpy( tmp_pal, vidCurrentPalette, sizeof(tmp_pal) );
          memset(pal,0,sizeof(tmp_pal));
//          vidSetPalette(pal);
          vidClearPage(vpage1,0);
          indy.ShowTB( (vidSizeX-indy.sizeX)/2, (vidSizeY-indy.sizeY)/2, 255, vpage1 );
          vidClearPage(vpage2,0);
          indy.ShowTB( (vidSizeX-indy.sizeX)/2, (vidSizeY-indy.sizeY)/2, 255, vpage2 );
          for( int i=0; i<256; i++ ) {
            pal[i].red = i/4; pal[i].green=i/8; pal[i].blue=0;
          }
//          vidSetPalette(pal);
          do {
//            SmoothPage(PAGE((int)vpage1+(int)vpage2-(int)vpage),vpage);
            AlignPage(vpage,30,0);
//            AlignPage(vpage,40,0);
//            vidDitherPage(bw,bw,vpage,dither->data);
            vidFlipPage(&vpage,vpage1,vpage2);
          } while( miscTimer()-tmp < PIC_SEC*miscTimerRes );
          memset(pal,0,sizeof(tmp_pal));
//          vidSetPalette(pal);
          vidClearPage(vpage,black);
//          vidDitherPage(color,bw,vpage,dither->data);
          vidFlipPage(&vpage,vpage1,vpage2);
//          vidSetPalette(tmp_pal);
          copy_time += COPY_SEC*miscTimerRes;
          indy.ShowTB( (vidSizeX-indy.sizeX)/2, (vidSizeY-indy.sizeY)/2, 255, bw );
        }
*/

      }
      else {
//        getch();
        double scale = (miscTimerRes*secs-time)/miscTimerRes/(FADE_OUT_SEC-ZERO_SCALE_SEC)-0.5;
        if( scale<0 ) scale = 0;
        int i;
        for( i=0; i<cubes.Count; i++ ) {
          FacedObject* c = (FacedObject*)cubes.At(i);
          c->ScaleTo( scale, scale, scale );
          c->dz *= scale;
        }
      }
    }
    int i;
    for( i=0; i<cubes.Count; i++ ) {
      FacedObject* c = (FacedObject*)cubes.At(i);
      int tmpx = c->rx, tmpy = c->ry;
      if(!i) {
        c->RotateTo( c->rx+(time-start)*cosSteps*ROT_PER_SEC/2/miscTimerRes,
          c->ry+(time-start)*cosSteps*ROT_PER_SEC/miscTimerRes, c->rz );
      }
      else {
        c->RotateTo( c->rx,
          c->ry+(time-start)*cosSteps*ROT_PER_SEC/miscTimerRes, c->rz );
      }
      c->Draw(zbuffer,color,bw);
      c->rx = tmpx; c->ry = tmpy;
    }
    if( time < (secs-FADE_OUT_SEC)*miscTimerRes ) {
      vpage==vpage1 ? SmoothPageH(bw,bw) : SmoothPageV(bw,bw);
    }
    else {
      musSetVolume( (secs*miscTimerRes-time)*63/FADE_OUT_SEC/miscTimerRes );
      SmoothPage(bw,bw);
      AlignPage(bw,(time-prevtime)/miscTimerRes*80,0);
    }
    vidDitherPage(color,bw,vpage,dither->data);
    vidFlipPage(&vpage,vpage1,vpage2);
    if( !pal_set ) {
      pal_set = true;
      vidSetPalette( dither->palette );
    }
  } while ( time < secs*miscTimerRes );
  cubes.FreeAll();
  delete dither;
}
