/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "resource.h"
#include "video.h"
#include "misc.h"
#include "image.h"
#include "3d.h"
#include "parts.h"

#define FADE_TIME (miscTimerRes*10)

extern int frames;

void partFace( uint secs )
{
  Image* texture = titlepic = new Image( "title1.raw" );
  Image facecolor( vidSizeX, vidSizeY, vidBytesPerLine, 0,
                   (uchar*)cmalloc(vidPageSize) ),
        facebw( vidSizeX, vidSizeY, vidBytesPerLine, 0,
                   (uchar*)cmalloc(vidPageSize) );
//  vidClearPage(color,0);
//  vidClearPage(bw,128);

#define N_FACES 7

  FacedObject* faces[N_FACES];
  int i;
  char name[20] = "face4?.3d";
  for( i=0; i<N_FACES; i++ ) {
    faces[i] = new FacedObject(NO_SHADOW|PERSPECT/*|TWO_SIDE*/);
    name[5] = '1'+i;
    faces[i]->Load(name,texture);
/*
    faces[i]->ImportASC( name, 0, VID_MAX_SIZE_X, texture,
                          MAP_NOSCALE|MAP_XY );
*/
    faces[i]->MoveAbs( 0,0,-faces[i]->minz);
    faces[i]->Prepare();
  }

//  FacedObject spider(NO_SHADOW|PERSPECT|MAP_BKGRND/*|TWO_SIDE*/);
//  spider.ImportASC( "spider.asc", 0,
//                    VID_MAX_SIZE_Y*0.2, texture1, MAP_XZ|MAP_NOSCALE);
//  spider.Load( "spider.3d", texture1 );
  spider.ScaleTo( 0.15, 0.15, 1 );
  spider.perspect = 0.85;
//  spider.Prepare();
//  spider.RotateTo( -cosSteps/4, 0, 0 );
//  spider.MoveTo( 0,0,MAX_Z-spider.maxz);

  struct {
    FacedObject* face;
    int spider_x, spider_y, spider_z;
  } phases[] = { { faces[0], 0, 0, 0 },
                 { faces[0], 0, 0, MAX_Z},
                 { faces[1], 0, 0, MAX_Z},
                 { faces[2], -VID_MAX_SIZE_X*0.17, 0, MAX_Z},
                 { faces[3], VID_MAX_SIZE_X*0.17, 0, MAX_Z},
                 { faces[4], -VID_MAX_SIZE_X*0.17, -VID_MAX_SIZE_Y/2, MAX_Z},
                 { faces[5], VID_MAX_SIZE_X*0.17, VID_MAX_SIZE_Y/2, MAX_Z},
                 { faces[1], 0, -VID_MAX_SIZE_Y/4, MAX_Z},
                 { faces[6], 0, VID_MAX_SIZE_Y/4.5, MAX_Z*2/3},
                 { faces[0], 0, VID_MAX_SIZE_Y/5, MIN_Z*2 } };

#define N_PHASES (sizeof(phases)/sizeof(phases[0])-1)

//  face1.RotateTo(0,-cosSteps/4,0);
//  face1.RotateTo(0,-cosSteps/4,0);
  FacedObject face(*faces[0]);
  face.perspect=3.5;
//  face.RotateTo( 0,cosSteps/2,0 );

//  memset( pal, 0, sizeof(pal) );

  int frames=0;
  uint start = miscTimer(), time=start;
  int steps = (secs*miscTimerRes-start)/N_PHASES;
  int end_time = start+steps*N_PHASES-1;
  bool pal_set = false;
  do {
    time = miscTimer();
    if( time >= end_time ) time = end_time;

    if( !pal_set ) {
      if( time-start > FADE_TIME ) {
        vidSetPalette( dither->palette );
        memcpy( pal, dither->palette, sizeof(pal) );
        pal_set = true;
      }
      else {
        RGB tmp_pal[256];
        for( int i=0; i<256; i++ ) {
          int add = MAX_RGB*(time-start)/(FADE_TIME);
          if( pal[i].red+add > dither->palette[i].red )
            tmp_pal[i].red = dither->palette[i].red;
          else
            tmp_pal[i].red = pal[i].red + add;
          if( pal[i].green+add > dither->palette[i].green )
            tmp_pal[i].green = dither->palette[i].green;
          else
            tmp_pal[i].green = pal[i].green + add;
          if( pal[i].blue+add > dither->palette[i].blue )
            tmp_pal[i].blue = dither->palette[i].blue;
          else
            tmp_pal[i].blue = pal[i].blue + add;
        }
        vidSetPalette( tmp_pal );
      }
    }
    memsetw( zbuffer, MIN_Z, vidPageSize );
//    vidCopyPage(color,colorpic.data);
    int n = (time-start)/steps, step = (time-start)%steps;
    face.Morph( *phases[n].face,
                *phases[n+1].face, step, steps, false );
    if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
    if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
    lx += lxs; ly += lys;
    face.SetLightTo( lx,ly, 0.6, 0.2 );
    spider.SetLightTo( 0,0, 0.6, 0.2 );
    spider.RotateTo( (time-start)*cosSteps*3/(end_time-start),
                     (time-start)*cosSteps*2/(end_time-start), 0 );
    spider.MoveTo(
      phases[n].spider_x+
      (phases[n+1].spider_x-phases[n].spider_x) * step / steps,
      phases[n].spider_y+
      (phases[n+1].spider_y-phases[n].spider_y) * step / steps,
      phases[n].spider_z+
      (phases[n+1].spider_z-phases[n].spider_z) * step / steps );

//    vidClearPage( color, vidBlackColor );
    vidClearPage( color, 128 );
    vidClearPage( bw, 128 );
//    vidSizeY /= 2; vidBytesPerLine *= 2;
    face.Draw(zbuffer,color,bw);
/*
    uchar *c1 = color, *c2 = color+vidBytesPerLine,
          *b1 = bw, *b2 = bw+vidBytesPerLine/2;
    for( i=0; i<vidSizeY; i++ ) {
      for( int j=0; j<vidBytesPerLine/2; j++ ) {
        *c1++ = *c2--;
        *b1++ = *b2--;
      }
      c1+=vidBytesPerLine/2; c2+=vidBytesPerLine/2*3;
      b1+=vidBytesPerLine/2; b2+=vidBytesPerLine/2*3;
    }
*/
/*
    for( i=0; i<vidSizeY; i++ ) {
      memcpy( color+vidBytesPerLine/2+i*vidBytesPerLine,
              color+i*vidBytesPerLine, vidSizeX );
      memcpy( bw+vidBytesPerLine/2+i*vidBytesPerLine,
              bw+i*vidBytesPerLine, vidSizeX );
    }
*/
//    vidSizeY *= 2; vidBytesPerLine /= 2;
    spider.Draw(zbuffer,color,bw);
    vidDitherPage(color,bw,vpage,dither->data);
    vidFlipPage(&vpage,vpage1,vpage2);
  } while ( time < end_time );
  for( i=0; i<N_FACES; i++ ) {
    delete faces[i];
  }
}
