/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include <ctype.h>
#include "font.h"
#include "parts.h"

Font::Font( int sizeX, int sizeY )
{
  memset( font, 0, sizeof(font) );
  font[' ']=new TPoly2D;
  size = sizeX;
  text_step_y = sizeY*2.5;
  text_step_x = size*0.5;
  font[' ']->Min.X = 0;
  font[' ']->Max.X = size*65536;
}

void Font::Load( int first, int last, char* _name )
{
  int i;
  char name[256];
  strcpy( name, _name );
  char* num_pos = strchr( name, '?' );
  int width=0;
  for( i=first; i<=last; i++ ) {
    if( num_pos ) *num_pos = tolower(i);
    font[i] = new TPoly2D( name );
    font[i]->Move( -font[i]->SizeX()/2-font[i]->Min.X>>16,
                   -font[i]->SizeY()/2-font[i]->Min.Y>>16 );
    width+=font[i]->SizeX();
  }
  double scale = (double)size/width*(last-first+1);
  for( i=first; i<=last; i++ ) {
    TPoly2D* f = font[i];
    if(f) {
      f->Scale( 0, 0, scale, scale );
    }
  }
}

void Font::DrawString( int x, int y, char* s, int aligment,
                       PAGE page, uchar color )
{
  int i, width = 0;
  for( i=0; i<strlen(s); i++ ) {
    width += getChar(s[i])->SizeX()+text_step_x;
  }
  switch( aligment ) {
    case ALIGN_LEFT: {
      x = x; break;
    }
    case ALIGN_RIGHT: {
      x -= width; break;
    }
    case ALIGN_CENTER:
    defaut: {
      x -= width/2; break;
    }
  }
  for( i=0; i<strlen(s); i++ ) {
    getChar(s[i])->DrawEdges(x,y,drawLinePix,page,color);
    x += getChar(s[i])->SizeX()+text_step_x;
  }
}
