/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __FONT__
#define __FONT__

enum { ALIGN_LEFT,
       ALIGN_RIGHT,
       ALIGN_CENTER };

#include "poly2d.h"

class Font {
  int size;
public:
  TPoly2D* font[256];
  int text_step_x, text_step_y;
  Font( int sizeX, int sizeY );
  void Load( int first, int last, char* _name );
  void Prepare();
  void DrawString( int x, int y, char* s, int aligment,
                   PAGE page, uchar color );
  TPoly2D* getChar( char c ) {
    return font[c] ? font[c] : font[' '];
  }
};

#endif