/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __IMAGE__
#define __IMAGE__

#include "misc.h"
#include "video.h"

#define NO_STRETCH     0
#define STRETCH        1
#define STRETCH_SCREEN 2
#define STRETCH_BIT0   3
#define STRETCH_BIT1   4

struct Image {
  int sizeX, sizeY, bytesPerLine;
  RGB* palette;
  void* buf;
  uchar* data;
  bool loaded;
  Image( char* name, int stretch=NO_STRETCH );
  Image( int sizex, int sizey, int bytesperline, RGB pal[256], uchar* buf );
  ~Image();
  void Show( int x, int y, PAGE );
  void ShowT( int x, int y, PAGE );
  void ShowAdd( int x, int y, PAGE page );
  void ShowTB( int x, int y, uchar color, PAGE );
  void ShowR( int x, int y, int w, int h, PAGE page );
  void ShowRT( int x, int y, int w, int h, PAGE page );
  void ShowRTC( int x, int y, int w, int h, uchar color, PAGE page );
  void ShowRTAdd( int x, int y, int w, int h, PAGE page );
  void StretchTo( int newx, int newy, int newbytesperline );
  void StretchToBit( int newx, int newy, bool neg );
};

#endif