/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "misc.h"
#include "video.h"
#include "parts.h"
#include "smooth.h"

#define N_PICS          9
#define FADE_SEC        5
#define BLOOD_COLOR     141
#define BLOOD_BW        156

void partIndy( uint _secs )
{
  int secs=_secs-FADE_SEC;
  int i;
  Image* indy[N_PICS];
  char name[20]="indy?.rle";
  int tot_len=0;
  for( i=0; i<N_PICS; i++ ) {
    name[4] = '1'+i;
    indy[i] = new Image( name, STRETCH_BIT1 );
    tot_len += indy[i]->sizeX;
  }
  TPoly2D blood3( "blood2.dxf" ), blood2( "blood1.dxf" ),
          blood1(blood2), blood(blood1);
  for( i=0; i<blood1.Points.Count; i++ ) {
    TPoint2D* p = (TPoint2D*)blood1.Points.At(i);
    p->X = vidSizeX/2 << 16;
    p->Y = vidSizeY/2 << 16;
  }
  uint start = miscTimer(), time=start;
  do {
    int i;
    time = miscTimer();
    ll=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lr=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lls=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75,
    lrs=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75;
    lls = ((lls-ll)/vidSizeY);
    lrs = ((lrs-lr)/vidSizeY);
    for( int y=0; y<vidSizeY; y++ ) {
      FillScanLine(bw+vidBytesPerLine*y,ll<<8,((lr-ll)/(vidSizeX+1))<<8);
      ll+=lls; lr+=lrs;
    }
    if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
    if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
    lx += lxs; ly += lys;
    if( time-start < (secs*miscTimerRes-start)/2 ) {
      blood.MorphTo( &blood1, &blood2, time-start, (secs*miscTimerRes-start)/2 );
    }
    else {
      blood.MorphTo( &blood2, &blood3, time-start-(secs*miscTimerRes-start)/2,
                                       (secs*miscTimerRes-start)/2 );
    }
    blood.Draw(fillLine,BLOOD_COLOR,color);
    blood.Draw(fillLine,BLOOD_BW,bw);
//    vidCopyPage( color,circle->data );
    int n = vidSizeX-(time-start)*(tot_len+vidSizeX)/(secs*miscTimerRes-start);
    for( i=0; i<N_PICS; i++ ) {
      indy[i]->ShowTB( n, (vidSizeY-indy[i]->sizeY)/2+vidSizeY/20, 245, bw );
      n += indy[i]->sizeX;
    }
//    SmoothPage(bw,bw);
    vidDitherPage( color, bw, vpage, dither->data );
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );
  secs=_secs;
  memcpy( pal, vidCurrentPalette, sizeof(pal) );
  do {
    time = miscTimer();
    RGB tmp_pal[256];
    for( int i=0; i<256; i++ ) {
      int add = -MAX_RGB/2+MAX_RGB/2*(secs*miscTimerRes-time)/
	        (FADE_SEC*miscTimerRes);
      if( pal[i].red+add < 0 ) tmp_pal[i].red = 0;
      else tmp_pal[i].red = pal[i].red + add;
      if( pal[i].green+add < 0 ) tmp_pal[i].green = 0;
      else tmp_pal[i].green = pal[i].green + add;
      if( pal[i].blue+add < 0 ) tmp_pal[i].blue = 0;
      else tmp_pal[i].blue = pal[i].blue + add;
    }
    vidSetPalette( tmp_pal );
    SmoothPage(bw,bw);
    SmoothPage(bw,bw);
    blood.Draw(fillLine,BLOOD_COLOR,color);
    blood.Draw(fillLine,BLOOD_BW,bw);
    vidDitherPage( color, bw, vpage, dither->data );
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );
  memset( pal, 0, sizeof(pal) );
  vidSetPalette( pal );
  delete circle;
  delete dither;
}
