/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <sys/time.h>
#include "misc.h"
#include "music.h"
#include "video.h"
#include "resource.h"

int cosTable[cosSteps], sinTable[cosSteps];
int cosTable3D[cosSteps], sinTable3D[cosSteps];
int asinTable[asinSteps];

void error( char* msg ) {
  Shutdown();
  printf( "\nFatal: %s\n", msg );
  exit(-1);
}

void* operator new( size_t size )
{
  return cmalloc(size);
}

void operator delete( void* ptr )
{
  cfree(ptr);
}

static size_t allocated=0, max_alloc=0;

void* cmalloc( size_t size )
{
  char* tmp = (char*)malloc(size+8);
  if(!tmp) error( "Not enough memory" );
  *(uint*)tmp = 0x12345678;
  *(uint*)(tmp+4)=size;
  allocated+=size; if( allocated>max_alloc) max_alloc=allocated;
//  printf( "cmalloc(%d), allocated=%d\n", size, allocated );
  return tmp+8;
}

void* crealloc( void* ptr, size_t size )
{
  if(ptr) {
    if( *(((uint*)ptr)-2) != 0x12345678 ) error( "Heap corrupted" );
    uint old_size = *(((uint*)ptr)-1);
    char* tmp = (char*)realloc((char*)ptr-8,size+8);
    if(!tmp) error( "Not enough memory" );
    *(uint*)tmp = 0x12345678;
    *(uint*)(tmp+4)=size;
    allocated -= old_size+size;
    if( allocated>max_alloc) max_alloc=allocated;
    return tmp+8;
  }
  else return cmalloc(size);
}

void cfree( void* ptr )
{
  if(ptr) {
    if( *(((uint*)ptr)-2) != 0x12345678 ) error( "Heap corrupted" );
    uint size = *(((uint*)ptr)-1);
    free((char*)ptr-8);
    allocated -= size;
//    printf( "cfree(%d), allocated=%d\n", size, allocated );
  }
}

void Startup( bool saveconfig )
{
  time_t foo;
  srand(time(&foo));

  int i;
  for( i=0; i<cosSteps; i++ ) {
    cosTable[i] = cos( 2*M_PI*i/cosSteps ) * (1<<cosScale);
    sinTable[i] = sin( 2*M_PI*i/cosSteps ) * (1<<cosScale);
    cosTable3D[i] = cos( 2*M_PI*i/cosSteps ) * (1<<cosScale3D);
    sinTable3D[i] = sin( 2*M_PI*i/cosSteps ) * (1<<cosScale3D);
  }
  for( i=0; i<asinSteps; i++ ) {
    asinTable[i] = asin((double)(i-asinSteps/2)/asinSteps)/M_PI*cosSteps*2;
  }

  musInitMusic();
  vidInitVideo();

  if( saveconfig || !miscLoadConfig( PROJECT_NAME ".cfg" ) ) {
    puts( "\n"PROJECT_NAME". (c)96 Queue Members Group Art Division\n" );
    musChooseCard();
    vidChooseVideoMode();
  }
  else {
    musInitCard();
  }
  if( saveconfig ) {
    miscSaveConfig( PROJECT_NAME ".cfg" );
  }
  vidSetVideoMode();
}

void Shutdown()
{
  musStopMusic();
  musCloseMusic();
  vidCloseVideo();
  printf( "Memory allocated: now=%d, max=%d\n", allocated, max_alloc );
}

void miscSaveConfig( char* filename ) {
  int h = creat( filename, 0 );
  if( h == -1 ) error( "Cannot write configuration file" );
  vidSaveConfig(h);
  musSaveConfig(h);
  close(h);
}

bool miscLoadConfig( char* filename )
{
  int h = open( filename, O_RDONLY );
  if( h == -1 )
    return false;
  else {
    vidLoadConfig(h);
    musLoadConfig(h);
    close(h);
    return true;
  }
}

#define ALLOC_STEP 10

static int (*_compare)(const void*, const void*);

int TCollection_Compare( const void* _1, const void* _2 )
{
  return _compare( *(void**)_1, *(void**)_2 );
}

void TCollection::Sort( int (*compare)(const void*, const void*) )
{
  _compare = compare;
  qsort( Items, Count, sizeof(void*), TCollection_Compare );
}

void TCollection::Insert( void* item )
{
  if( ++Count > allocated ) {
    allocated += ALLOC_STEP;
    void** tmp = Items;
    Items = (void**) cmalloc( sizeof(void*)*allocated );
    memcpy( Items, tmp, sizeof(void*)*(allocated-ALLOC_STEP) );
    cfree(tmp);
  }
  Items[Count-1] = item;
}

void TCollection::Delete(int index)
{
//  memcpy( &Items[index], &Items[index+1], sizeof(void*)*(allocated-index-1) );
//  Count--;
  if( index>=0 ) Items[index]=0;
}

void TCollection::PackDelete(int index)
{
  if( index>=0 ) {
    memcpy( &Items[index], &Items[index+1], sizeof(void*)*(allocated-index-1) );
    Count--;
  }
}

int TCollection::IndexOf( void* item )
{
  for( int i=0; i<Count; i++ ) {
    if( item == Items[i] ) return i;
  }
  return -1;
}

void TCollection::Pack()
{
  int i;
  while( (i=IndexOf(0)) != -1 ) PackDelete(i);
}

void TCollection::FreeAll()
{
  for( int i=0; i<Count; i++ ) {
    delete Items[i];
  }
  DeleteAll();
}

TCollection::~TCollection() {
  FreeAll();
  cfree(Items);
}

char* getToken(FILE* fp, const char* delimiters )
{
  static char buf[1024];
  char* ptr = buf;
  do {
    *ptr = fgetc(fp);
  } while ( strchr( delimiters, *ptr ) );
  do {
    *(++ptr) = fgetc(fp);
  } while ( !strchr( delimiters, *ptr ) && (ptr-buf)<1023 );
  *ptr = 0;
//  printf( "%s\n", buf );
  return buf;
}

unsigned long timerStart;

void miscStartTimer()
{
  struct timeval tv; 
  struct timezone tz;
  gettimeofday( &tv, &tz );
  timerStart = tv.tv_usec/1000+tv.tv_sec*1000;
}

uint miscTimer()
{
  struct timeval tv; 
  struct timezone tz;
  gettimeofday( &tv, &tz );
  return tv.tv_usec/1000+tv.tv_sec*1000-timerStart;
}

void memsetw( void* dst, short value, size_t length )
{
  for( int i=0; i<length; i++ ) ((ushort*)dst)[i]=value;
}

int miscGetNumber( const char* str, int min, int max )
{
  printf(str);
  int res;
  do {
    char str[256];
    res = atoi(fgets(str,255,stdin)); 
  } while( res<min || res>max );
  return res;
}

