/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __PARTS__
#define __PARTS__

#include "video.h"
#include "image.h"
#include "poly2d.h"
#include "3d.h"
#include "font.h"

#define N_FIGS    3

extern RGB pal[256];
extern PAGE color, bw, vpage1, vpage2, vpage;
extern Image *titlepic, *dither, *circle, *colortext, *linepic, *line1pic;
extern int lx,ly,lxs,lys,ll,lr,lls,lrs;
extern short* zbuffer;
extern TPoly2D *fire1, *fire2;
extern FacedObject spider;
extern Font* font;
extern FacedObject *figs[N_FIGS];

void FillScanLine( uchar* offset, uint l, int ls );

void partInit();
void partDone();
void partFire( uint secs );
void partFace( uint secs );
void partTitle( uint secs );
void partTrees( uint secs );
void partCubes( uint secs );
void partFigs( uint secs );
void partIndy( uint secs );
void partScroll( uint secs );

void fillLine( int Y, int X1, int X2, uchar color, PAGE page );
void drawLine( PAGE page, int x1, int y1, int x2, int y2, uchar color );
void drawLine1( PAGE page, int x1, int y1, int x2, int y2, uchar color );
void drawLinePix( PAGE page, int x1, int y1, int x2, int y2, uchar color );

#endif
