/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <string.h>
#include "misc.h"
#include "video.h"
#include "image.h"
#include "parts.h"
#include "poly2d.h"
#include "resource.h"
#include "music.h"

#define FADE_TIME (miscTimerRes*5)
#define FADE_OUT_TIME (miscTimerRes*5)

void partScroll( uint secs )
{
  memset(pal,0,sizeof(pal));
  vidSetPalette(pal);
  delete color; delete bw;
  int oldSizeX=vidSizeX, oldSizeY=vidSizeY;
  if( vidSizeX*pixel_size < 640 ) {
    vidFreePage(vpage1); vidFreePage(vpage2);
    vidVideoMode=oldSizeX*1.5;
    vidSetVideoMode();
    vpage1=vidAllocPage(false);
    vpage2=vidAllocPage(false);
    vpage=vpage2;
  }
  for( int i=0; i<256; i++ ) {
    if( font->font[i] ) {
      font->font[i]->Scale( 0,0, (double)vidSizeX/oldSizeX/1.5,
			   (double)vidSizeY/oldSizeY/1.5 );
    }
  }
  font->text_step_x *= (double)vidSizeX/oldSizeX/1.5;
  font->text_step_y *= (double)vidSizeY/oldSizeY/1.5;
  Image back( "sacrplac.raw", STRETCH_SCREEN );
  line1pic = new Image( "line1.raw", STRETCH );
  PAGE buf = vidAllocPage(true);
  TPoly2D horizon("horizon.dxf");
  TPoly2D spider2( "fire1.dxf" );
  spider2.Scale( vidSizeX/2, vidSizeY/2, 0.65, 0.65 );
  spider2.Move( 0, -vidSizeY*0.2 );
  TPoly2D title( "title.dxf" );
  title.Scale( vidSizeX/2, vidSizeY/2, 1, 0.7 );
  title.Move( 0, vidSizeY*0.3 );
  TCollection strings;
  FILE* fp = resOpenFile( "scroll" );
  char* str;
  do {
    strings.Insert( strdup( str=getToken( fp, "\r\n" ) ) );
  } while( strcmp(str, "EOF") );
  strings.PackDelete(strings.Count-1);
  resClose(fp);
  int scroll_size = (strings.Count*font->text_step_y+
                    ((title.Max.Y-spider2.Min.Y)>>16)+vidSizeY*1.2);
  uint start = miscTimer(), time=start;
  bool pal_set = false;
  do {
    time = miscTimer();
    if( time>secs*miscTimerRes ) time=secs*miscTimerRes;
    if( !pal_set ) {
      if( time-start > FADE_TIME ) {
        vidSetPalette( back.palette );
        memcpy( pal, back.palette, sizeof(pal) );
        pal_set = true;
      }
      else {
        for( int i=0; i<256; i++ ) {
          int add = MAX_RGB*(time-start)/(FADE_TIME);
          if( add > back.palette[i].red )
            pal[i].red = back.palette[i].red;
          else
            pal[i].red = add;
          if( add > back.palette[i].green )
            pal[i].green= back.palette[i].green;
          else
            pal[i].green = add;
          if( add > back.palette[i].blue)
            pal[i].blue = back.palette[i].blue;
          else
            pal[i].blue = add;
        }
        vidSetPalette( pal );
      }
    }
    vidCopyPage(vpage,back.data);
    vidClearPage(buf);
    int y = vidSizeY-(time-start)/(secs*miscTimerRes-start)*scroll_size;
    for( int i=0; i<strings.Count; i++ ) {
      if( y+font->text_step_y > 0 && y < vidSizeY ) {
        font->DrawString( vidSizeX/2, y, (char*)strings.At(i), ALIGN_CENTER,
                          buf, 255 );
      }
      y += font->text_step_y;
    }
    if( y < vidSizeY ) {
      spider2.DrawEdges( 0, y, drawLine1, buf, 0 );
      title.DrawEdges( 0, y, drawLine1, buf, 0 );
    }
    horizon.Draw(fillLine,0,buf);
    vidCopyPageT(vpage,buf);
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );
  strings.DeleteAll();
  start=miscTimer();
  int add=0;
  do {
    time = miscTimer();
    int add = MAX_RGB*(time-start)/(FADE_OUT_TIME);
    for( int i=0; i<256; i++ ) {
      if( back.palette[i].red-add < 0 )
        pal[i].red = 0;
      else
        pal[i].red = back.palette[i].red-add;
      if( back.palette[i].green-add < 0 )
        pal[i].green = 0;
      else
        pal[i].green = back.palette[i].green-add;
      if( back.palette[i].blue-add < 0 )
        pal[i].blue= 0;
      else
        pal[i].blue= back.palette[i].blue-add;
    }
    vidShowPage(vpage);
    vidSetPalette( pal );
    musSetVolume(63-add*63/MAX_RGB);
  } while( time<FADE_OUT_TIME+secs*miscTimerRes );
}
