/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "video.h"
#include "smooth.h"

void SmoothPage( PAGE frompage, PAGE topage ) {
  memset( topage, 0, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i-1]+frompage[i+1]+
                 frompage[i+vidBytesPerLine]+frompage[i-vidBytesPerLine])>>2;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 0, vidBytesPerLine );
}

void SmoothPageNorm( PAGE frompage, PAGE topage ) {
  memset( topage, 128, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i-1]+frompage[i+1]+128*4+
                 frompage[i+vidBytesPerLine]+frompage[i-vidBytesPerLine])>>3;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 128, vidBytesPerLine );
}

void SmoothPageH( PAGE frompage, PAGE topage ) {
  memset( topage, 0, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i-1]+frompage[i+1])>>1;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 0, vidBytesPerLine );
}

void SmoothPageV( PAGE frompage, PAGE topage ) {
  memset( topage, 0, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i+vidBytesPerLine]+frompage[i-vidBytesPerLine])>>1;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 0, vidBytesPerLine );
}

void SmoothPageHNorm( PAGE frompage, PAGE topage ) {
  memset( topage, 128, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i-1]+frompage[i+1]+128*2)>>2;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 128, vidBytesPerLine );
}

void SmoothPageVNorm( PAGE frompage, PAGE topage ) {
  memset( topage, 128, vidBytesPerLine );
  for( int i=vidBytesPerLine; i<vidPageSize-vidBytesPerLine; i++ ) {
    topage[i] = (frompage[i+vidBytesPerLine]+
		 frompage[i-vidBytesPerLine]+128*2)>>2;
  }
  memset( topage+vidPageSize-vidBytesPerLine, 128, vidBytesPerLine );
}

void AlignPage( PAGE page, uchar step, uchar value ) {
  for( int i=0; i<vidPageSize; i++ ) {
    int tmp = page[i] - value;
    if( abs(tmp) < step ) page[i]=value;
    else {
      if( tmp > 0 ) {
	page[i] -= step;
      }
      else {
	page[i] += step;
      }
    }
  }
}

void AlignToPage( PAGE frompage, PAGE topage, uchar step ) {
  for( int i=0; i<vidPageSize; i++ ) {
    int tmp = frompage[i] - topage[i];
    if( abs(tmp) < step ) frompage[i]=topage[i];
    else {
      if( tmp > 0 ) {
	frompage[i] -= step;
      }
      else {
	frompage[i] += step;
      }
    }
  }
}

