/*
 *
 *   HElliZER resource unpacker (command: unpack HElliZER.EXE).
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
 
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

struct entry {
  char name[16];
  int offset, size;
} *table=0;

int resource_number=0;

void main( int argc, char* argv[] )
{
  FILE* f = fopen( argv[1], "rb" );
  if(f) {
    fseek( f, -4, SEEK_END );
    int n;
    fread( &n, sizeof(int), 1, f );
    if( n == 0x12345678 ) {
      fseek( f, -8, SEEK_END );
      fread( &n, sizeof(int), 1, f );
      printf( "table offset=%d\n", n );
      fseek( f, n, SEEK_SET );
      fread( &resource_number, sizeof(int), 1, f );
      printf( "resource_number=%d\n", resource_number );
      table = (entry*)malloc(sizeof(entry)*resource_number);
      printf( "table=%d, size=%d\n", table, sizeof(entry)*resource_number );
      fread( table, sizeof(entry)*resource_number, 1, f );
      for( int i=0; i<resource_number; i++ ) {
	for( int j=0; j<strlen(table[i].name); j++ ) 
	  table[i].name[j] = tolower(table[i].name[j]);
        printf( "name=%s, offset=%d\n", table[i].name, table[i].offset );
	fseek( f, table[i].offset, SEEK_SET );
	void* buf=malloc(table[i].size);
	fread( buf, table[i].size, 1, f );
	FILE* out = fopen( table[i].name, "wb+" );
	fwrite( buf, table[i].size, 1, out );
	fclose(out);
	free(buf);
      }
    }
    fclose(f);
  }
}



