/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "video.h"
#include "misc.h"
#include "music.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#define XK_LATIN1
#define XK_MISCELLANY
#include <X11/keysymdef.h>

bool vidInitialized = false;
int frameCount = 0;

int vidSizeX, vidSizeY, vidPageSize, vidPageLength, vidBytesPerLine,
    vidMaxPage, vidVideoMode;

#define N_GAMMA 4
uchar cur_gamma=0, gamma[N_GAMMA][MAX_RGB+1];

Display* display;
int nscreen;
Drawable window;
GC gc;
XImage* image;    
XColor colors[256];
Visual* visual;
Colormap colormap=0;
int depth,real_depth;
char* image_data=0;
int bytesPerLine;
int pixel_size;
int start_time;
#define rgb_bits 5
#define max_rgb (1<<rgb_bits)
unsigned long rgb_table[max_rgb][max_rgb][max_rgb];

void vidInitVideo() {
  for( int i=0; i<N_GAMMA; i++ ) {
    for( int j=0; j<=MAX_RGB; j++ ) {
      int tmp = int((1+(double)i/N_GAMMA)*j);
      if( tmp>MAX_RGB ) tmp = MAX_RGB;
      gamma[i][j]=tmp;
    }
  }
  display = XOpenDisplay(0);
  if(display) {
    nscreen = DefaultScreen(display);
    window = XCreateSimpleWindow(display,RootWindow(display,nscreen),0,0,
				 1,1,0,0,0 );
    XSetStandardProperties(display,window,PROJECT_NAME,PROJECT_NAME,0,0,0,0);
    XMapWindow(display,window);
    gc = XCreateGC(display,window,0,NULL);
    depth=DefaultDepth(display,nscreen);
    int nxpfv;
    XPixmapFormatValues* xpfv = XListPixmapFormats(display,&nxpfv);
    for( int i=0; i<nxpfv; i++ ) {
      if( depth == xpfv[i].depth )
	real_depth=xpfv[i].bits_per_pixel/8;
    }
//    printf("display depth=%d, bytes per pixel=%d\n",depth,real_depth);
    visual=DefaultVisual(display,nscreen);
    XEvent event;
    XSetWindowAttributes xswa;
    xswa.event_mask = KeyPress|KeyRelease;
    XChangeWindowAttributes(display,window, CWEventMask, &xswa );
  }
  else {
    error( "Cannot open display" );
  }
  if( visual->c_class == TrueColor |
     visual->c_class == StaticColor |
     visual->c_class == StaticGray ) {
    colormap = XCreateColormap(display,window,visual,AllocNone);
    int r,g,b;
    for( r=0; r<max_rgb; r++ ) {
      for( g=0; g<max_rgb; g++ ) {
        printf("Allocating colors, %d of %d...             \r", 
               r*max_rgb*max_rgb+g*max_rgb+b,max_rgb*max_rgb*max_rgb);
        for( b=0; b<max_rgb; b++ ) {
   	  XColor foo;
	  foo.red=r<<(16-rgb_bits);
 	  foo.green=g<<(16-rgb_bits);
	  foo.blue=b<<(16-rgb_bits);
	  foo.flags=DoRed|DoGreen|DoBlue;
          XAllocColor(display,colormap,&foo);
          rgb_table[r][g][b] = foo.pixel;
        }	 
      }
    }
    printf("                                              \r");
  }
  else {
    colormap = XCreateColormap(display,window,visual,AllocAll);
  }
  vidInitialized = true;
}

void vidSetVideoMode() {
  vidBytesPerLine = vidSizeX = min( VID_MAX_SIZE_X, vidVideoMode );
  vidSizeY = vidSizeX*3/4;;
  vidPageSize = vidBytesPerLine*vidSizeY;
  XMoveResizeWindow(display,window,
		    (DisplayWidth(display,nscreen)-vidSizeX*pixel_size)/2,
		    (DisplayHeight(display,nscreen)-vidSizeY*pixel_size)/2,
		    vidSizeX*pixel_size,vidSizeY*pixel_size);
  bytesPerLine = vidBytesPerLine*real_depth*pixel_size;
//  printf("bytesPerLine=%d\n",bytesPerLine);
  if( image ) XDestroyImage(image);
  image_data = (char*)malloc(bytesPerLine*vidSizeY*pixel_size);
  image = XCreateImage(display,visual,depth,ZPixmap,0,image_data,
		       vidSizeX*pixel_size,vidSizeY*pixel_size,8,bytesPerLine);
  //    printf("image->bits_per_pixel=%d\n",image->bits_per_pixel);
}

void vidCloseVideo() {
  printf("Average frames per second = %5.2f\n",
	 frameCount*miscTimerRes/(miscTimer()-start_time) );
  if( vidInitialized ) {
    XDestroyWindow(display,window);
    if(image) XDestroyImage(image);
    XFreeGC(display,gc);
    XCloseDisplay(display);
  }
}

void vidChooseVideoMode() {
  char str[256];
  sprintf(str,"Enter horizontal resolution (up to %d) : ", VID_MAX_SIZE_X);
  vidVideoMode=miscGetNumber( str,1,VID_MAX_SIZE_X );
  pixel_size=miscGetNumber("Enter resolution unit size in pixels (1 or 2): ",
			   1,2 );
}

void vidSaveConfig( int h )
{
  write( h, &vidVideoMode, sizeof(vidVideoMode) );
  write( h, &pixel_size, sizeof(pixel_size) );
}

void vidLoadConfig( int h )
{
  read( h, &vidVideoMode, sizeof(vidVideoMode) );
  read( h, &pixel_size, sizeof(pixel_size) );
}

int vidBlackColor;
RGB vidCurrentPalette[256];

void vidSetPalette( RGB* pal ) {
  memcpy( vidCurrentPalette, pal, sizeof(vidCurrentPalette) );
  if( visual->c_class == TrueColor |
     visual->c_class == StaticColor |
     visual->c_class == StaticGray ) {
    for(int i=0; i<256; i++ ) {
      colors[i].pixel=rgb_table         
        [gamma[cur_gamma][pal[i].red]>>(8-rgb_bits)]
        [gamma[cur_gamma][pal[i].green]>>(8-rgb_bits)]
        [gamma[cur_gamma][pal[i].blue]>>(8-rgb_bits)];
    }
  }
  else {
    for(int i=0; i<256; i++ ) {
      colors[i].pixel=i;
      colors[i].red=gamma[cur_gamma][pal[i].red]<<8;
      colors[i].green=gamma[cur_gamma][pal[i].green]<<8;
      colors[i].blue=gamma[cur_gamma][pal[i].blue]<<8;
      colors[i].flags=DoRed|DoGreen|DoBlue;
    }
    XStoreColors(display,colormap,colors,256);
    XSetWindowColormap(display,window,colormap);
  }
}

PAGE vidAllocPage( bool inRAM ) {
  return (PAGE)cmalloc(vidPageSize);
}

void vidFreePage( PAGE Page ) {
  cfree(Page);
}

void vidCopyPage( PAGE topage, PAGE frompage )
{
  memcpy( topage, frompage, vidPageSize );
}

void vidCopyPageT( PAGE topage, PAGE frompage )
{
  for( int i=0; i<vidPageSize; i++ )
    if( frompage[i] ) topage[i] = frompage[i];
}

void vidShowPage( PAGE Page )
{
  if( !start_time ) start_time = miscTimer();
  frameCount++;
  static time=0;
  XEvent event;
  if( XCheckWindowEvent(display,window,KeyPressMask,&event) ) {
    KeySym keysym = XLookupKeysym( &event.xkey, 0 );
//    printf("keycode=%d, keysym=%x (%s)\n",event.xkey.keycode, keysym,
//	   XKeysymToString(keysym) );
    switch(keysym) {
      case XK_F11: {
        cur_gamma = (cur_gamma+1)%N_GAMMA;
        vidSetPalette( vidCurrentPalette );
        break;
      }
      case XK_Escape: {
        Shutdown();
        exit(1);
        break;
      }
/*
   doesn't work 'cause music is playing by child process anyway

      case XK_KP_Add: {
        if( musGetVolume() < 53 )
          musSetVolume( musGetVolume()+10 );
        else
          musSetVolume(63);
        break;
      }
      case XK_KP_Subtract: {
        if( musGetVolume() > 10 )
          musSetVolume( musGetVolume()-10 );
        else
          musSetVolume(0);
        break;
      }
*/
    }
  }
/*
  if( *(uchar*)0x417 & 3 ) {
    int fps = miscTimerRes/(miscTimer()-time);
    time=miscTimer();
    for( int i=0; i<fps; i++ ) {
      int c= i<8 ? 255 : 254;
      Page[i*3]=255; Page[i*3+1]=255;
      Page[i*3+vidBytesPerLine]=255; Page[i*3+1+vidBytesPerLine]=255;
    }
  }
*/
  if( real_depth == sizeof(char) ) {
    if( visual->c_class == TrueColor |
       visual->c_class == StaticColor |
       visual->c_class == StaticGray ) {
      switch( pixel_size ) {
      case 1:
	for( int i=vidPageSize-1; i; i-- ) {
	  image_data[i]=colors[Page[i]].pixel;
	}
	break;
      case 2:
	char *foo1=image_data; 
	PAGE foo2=Page;
	for( int y=0; y<vidSizeY; y++ ) {
	  for( int x=0; x<vidSizeX; x++ ) {
	    foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
	  };
	  memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
	  foo1+=bytesPerLine*2; 
	  foo2+=vidBytesPerLine;
	}
	break;
      }
    }
    else {
      switch( pixel_size ) {
      case 1:
	memcpy( image_data, Page, vidPageSize );
	break;
      case 2:
	char *foo1=image_data; 
	PAGE foo2=Page;
	for( int y=0; y<vidSizeY; y++ ) {
	  for( int x=0; x<vidSizeX; x++ ) {
	    foo1[x*2]=foo1[x*2+1]=foo2[x];
	  };
	  memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
	  foo1+=bytesPerLine*2; 
	  foo2+=vidBytesPerLine;
	}
	break;
      }
    }
  }
  else if( real_depth == sizeof(short) ) {
    switch( pixel_size ) {
    case 1:
      for( int i=vidPageSize-1; i; i-- ) {
	((short*)image_data)[i]=colors[Page[i]].pixel;
      }
      break;
    case 2:
      short* foo1=(short*)image_data; 
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
	for( int x=0; x<vidSizeX; x++ ) {
	  foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
	};
	memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
	foo1+=bytesPerLine*2; 
	foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else if( real_depth == sizeof(int) ) {
    switch( pixel_size ) {
    case 1:
      for( int i=vidPageSize-1; i; i-- ) {
	((int*)image_data)[i]=colors[Page[i]].pixel;
      }
      break;
    case 2:
      int* foo1=(int*)image_data; 
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
	for( int x=0; x<vidSizeX; x++ ) {
	  foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
	};
	memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
	foo1+=bytesPerLine*2; 
	foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else if( real_depth == sizeof(long) ) {
    switch( pixel_size ) {
    case 1:
      for( int i=vidPageSize-1; i; i-- ) {
	((long*)image_data)[i]=colors[Page[i]].pixel;
      }
      break;
    case 2:
      long* foo1=(long*)image_data; 
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
	for( int x=0; x<vidSizeX; x++ ) {
	  foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
	};
	memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
	foo1+=bytesPerLine*2; 
	foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else {
    char str[256];
    sprintf( str, "%d screen depth is not supported", depth );
    error(str);
  }
  XPutImage(display,window,gc,image,0,0,0,0,
	    vidSizeX*pixel_size,vidSizeY*pixel_size);
}

void vidClearPage( PAGE Page, int value ) {
  memset( Page, value, vidPageSize );
}

static int total;

void vidFlipPage( PAGE* vpage, PAGE vpage1, PAGE vpage2 )
{
  vidShowPage(*vpage);
  *vpage = PAGE( (int)vpage1 + (int)vpage2 - (int)*vpage );
}

void vidDitherPage( PAGE colorpage, PAGE bwpage, PAGE topage,
                    PAGE dithertable )
{
  for( int i=vidPageSize-1; i; i-- ) {
    topage[i] = dithertable[ (colorpage[i]<<8) + bwpage[i] ];
  }
}

void vidStartVideo()
{
  XSync(display,False);
}
