/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __VIDEO__
#define __VIDEO__

#define VID_MAX_SIZE_X  640
#define VID_MAX_SIZE_Y  480

#define MAX_RGB 255

typedef struct { unsigned char red, green, blue; } RGB;
typedef unsigned char* PAGE;

extern "C" int vidSizeX, vidSizeY, vidPageSize, vidBytesPerLine, vidVideoMode;

// kludge
extern int pixel_size;

extern int vidBlackColor;
extern RGB vidCurrentPalette[256];

#define vidScaleX(x) ((x)*vidSizeX/VID_MAX_SIZE_X)
#define vidScaleY(y) ((y)*vidSizeY/VID_MAX_SIZE_Y)

void vidInitVideo();
void vidSetVideoMode();
void vidCloseVideo();
void vidChooseVideoMode();
void vidSetPalette( RGB* pal );
PAGE vidAllocPage( bool inRAM );
void vidFreePage( PAGE Page );
void vidShowPage( PAGE Page );
void vidFlipPage( PAGE* vpage, PAGE vpage1, PAGE vpage2 );
void vidCopyPage( PAGE topage, PAGE frompage );
void vidCopyPageT( PAGE topage, PAGE frompage );
void vidClearPage( PAGE Page, int value=0 );
void vidDitherPage( PAGE colorpage, PAGE bwpage, PAGE topage,
                    PAGE dithertable );
void vidSaveConfig( int h );
void vidLoadConfig( int h );
void vidStartVideo();

#endif

