/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __3D__
#define __3D__

#include <stdio.h>
#include <math.h>
#include "video.h"
#include "misc.h"
#include "image.h"

//#define PURE_C

#define MAX_Z   512
#define MIN_Z   (-MAX_Z)

struct Vector {
  int x,y,z;
  Vector() {};
  Vector( int _x, int _y, int _z ) {
    x=_x; y=_y; z=_z;
  }
  Vector( Vector& n ) { *this=n; }
  void Normalize() {
    double n = sqrt(sqr((double)x) + sqr((double)y) + sqr((double)z))/256;
    if(n>0) {
      x /= n; y /= n; z /= n;
    }
  }
  void Move( int dx, int dy, int dz )
  {
    x += dx; y+=dy; z+=dz;
  }
  void Rotate( int cx, int cy, int cz, int rx, int ry, int rz );
  void Store( FILE* fp ) { fprintf( fp, "%d %d %d ",x,y,z ); }
  void Load( FILE* fp ) { 
    fscanf( fp, "%d %d %d ",&x,&y,&z ); 
  }
};

struct Point: public Vector {
  int l, tx, ty;
  Point(): Vector() {}
  Point( int _x, int _y, int _z, int _tx, int _ty, int _l=0 ) :
  Vector( _x, _y, _z ) {
    tx = _tx; ty = _ty; l=_l;
  }
  Point( Point& p ) { *this=p; }
  void Store( FILE* fp ) { 
    Vector::Store(fp);
    fprintf( fp, "%d %d %d ",l,tx,ty ); 
  }
  void Load( FILE* fp ) { 
    Vector::Load(fp);
    fscanf( fp, "%d %d %d ",&l,&tx,&ty ); 
  }
};

struct Face {
  Point* vert[3];
  Vector normal;
  uchar** yOffset;
  Face( Point* p1, Point* p2, Point* p3, uchar** yOffset );
  Face( Point* p1, Point* p2, Point* p3, uchar** _yOffset, Vector _normal )
  {
    vert[0]=p1; vert[1]=p2; vert[2]=p3; normal = _normal;
    yOffset = _yOffset;
  }
  void Draw();
};

struct Object3D {
  int dx, dy, dz, rx, ry, rz, lx, ly; double lv, lo;
  double sx, sy, sz;
  void RotateTo( int _rx, int _ry, int _rz ) {
    rx = _rx; ry = _ry; rz = _rz;
  }
  void SetLightTo( int _lx, int _ly, double _lv, double _lo ) {
    lx = _lx; ly = _ly; lv = _lv; lo=_lo;
  }
  void MoveTo( int _dx, int _dy, int _dz ) {
    dx = _dx; dy = _dy; dz = _dz;
  }
  void ScaleTo( double _sx, double _sy, double _sz ) {
    sx = _sx; sy = _sy; sz = _sz;
  }
  Object3D( int _dx=0,int _dy=0,int _dz=0,
            int _rx=0,int _ry=0,int _rz=0,
            int _lx=0,int _ly=0, double _lv=0.5, double _lo=0.5,
            double _sx=1,double _sy=1,double _sz=1 ) {
    dx=_dx,dy=_dy,dz=_dz,rx=_rx,ry=_ry,rz=_rz,
    lx=_lx,ly=_ly,lv=_lv,lo=_lo,sx=_sx,sy=_sy,sz=_sz;
  };
};

#define MAP_XY       (1<<0)
#define MAP_YZ       (1<<1)
#define MAP_XZ       (1<<2)
#define MAP_SPHERE   (1<<3)
#define MAP_NORMAL   (1<<4)
#define MAP_SCALE    0
#define MAP_NOSCALE  (1<<5)
#define MAP_BKGRND   (1<<6)

#define SHADOW       (1<<7)
#define NO_SHADOW    0

#define PERSPECT     (1<<8)
#define NO_PERSPECT  0

#define ONE_SIDE     0
#define TWO_SIDE     (1<<9)

struct FacedObject: public Object3D {
  int maxx,maxy,maxz,minx,miny,minz;
  TCollection points, faces, normals, tmp_points, tmp_faces;
  uint flags;
  double perspect;
  FacedObject( uint flags );
  FacedObject( FacedObject& );
  void Load( char* filename, Image* texture );
  void Store( char* filename );
  void ImportASC( char* filename, char* name, double Scale,
                  Image* texture, int mapping );
  void Prepare();
  void Draw( short* zbuffer, PAGE color, PAGE bw );
  void Morph( FacedObject&, FacedObject&, int step, int steps,
              bool morphTexture );
  void MoveAbs( int dx, int dy, int dz );
  void RotateAbs( int rx, int ry, int rz );
  setDrawLineShadow( PAGE color, PAGE bw, int shadow_offset );
  setDrawLineNoShadow( PAGE color, PAGE bw );
  setDrawLineNoTexture( PAGE bw );
};

#endif
