/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */

#include "misc.h"
#include "video.h"
#include "3d.h"
#include "parts.h"

#define FADE_SEC  10

void partFigs( uint secs )
{
  uint start = miscTimer(), time=start;
  int steps = (secs*miscTimerRes-start)/N_FIGS;
  do {
    int i;
    time = miscTimer();
    ll=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lr=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lls=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75,
    lrs=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75;
    lls = ((lls-ll)/vidSizeY);
    lrs = ((lrs-lr)/vidSizeY);
    for( int y=0; y<vidSizeY; y++ ) {
      FillScanLine(bw+vidBytesPerLine*y,ll<<8,((lr-ll)/(vidSizeX+1))<<8);
      ll+=lls; lr+=lrs;
    }
    if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
    if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
    lx += lxs; ly += lys;
    vidCopyPage( color,circle->data );
    if( time > (secs-FADE_SEC)*miscTimerRes ) {
      double scale = (secs*miscTimerRes-time)/miscTimerRes/FADE_SEC;
      int i;
      for( i=0; i<N_FIGS; i++ ) {
        figs[i]->ScaleTo( scale, scale, scale );
      }
    }
    else {
      if( time-start < FADE_SEC*miscTimerRes ) {
        double scale = (time-start)/miscTimerRes/FADE_SEC;
        int i;
        for( i=0; i<N_FIGS; i++ ) {
          figs[i]->ScaleTo( scale, scale, scale );
        }
      }
    }
    memsetw( zbuffer, MIN_Z, vidPageSize );
    int n = (time-start)/steps, step = (time-start)%steps;
    for( i=0; i<N_FIGS; i++ ) {
      figs[i]->SetLightTo( lx, ly, 1, 0 );
      int rx=figs[i]->rx, ry=figs[i]->ry, rz=figs[i]->rz;

      figs[i]->RotateTo( (time-start)*cosSteps*rx/(secs*miscTimerRes-start),
                           (time-start)*cosSteps*ry/(secs*miscTimerRes-start),
                           (time-start)*cosSteps*rz/(secs*miscTimerRes-start));

      figs[i]->Draw(zbuffer,color,bw);
      figs[i]->rx=rx, figs[i]->ry=ry, figs[i]->rz=rz;
    }
    vidDitherPage( color, bw, vpage, dither->data );
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );

//  delete circle;
//  delete dither;
}