/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "misc.h"
#include "video.h"
#include "image.h"
#include "poly2d.h"
#include "smooth.h"
#include "parts.h"
#include "resource.h"
#include "font.h"

#define END_SECS 4

ushort bp=0;
int ebx=0;

void doFire(PAGE page, int size, int hsize)
{
//  puts("fire");

/*
"xchg   ebp,_ebp           "\
"add    ecx,ebx            "\
"sub    ecx,edi            "\
"dec    ecx                "\
"lea    esi,[edi*2+ebx+1]  "\
"mov    ebx,_ebx           "\
"or     ebx,ebx            "\
"jne    no_loadebx         "\
"mov    ebx,esi            "\
"no_loadebx:               "\
"_loop:                    "\
"mov    al,[ebx]           "\
"cmp    al,193+32          "\
"jae    no_zero            "\
"mov    al,1               "\
"no_zero:                  "\
"dec    al                 "\
"mov    [ebx+1],al         "\
"mov    [ebx-1],al         "\
"mov    [ebx+edi],al       "\
"neg    edi                "\
"mov    [ebx+edi],al       "\
"mov    [ebx+edi*2],al     "\
"neg    edi                "\
"no_draw:                  "\
"sub    ebx,ebp            "\
"inc    bp                 "\
"check:                    "\
"cmp    ebx,esi            "\
"jae    no_correct         "\
"sub    ebx,esi            "\
"add    ebx,ecx            "\
"jmp    check              "\
"no_correct:               "\
"test    bp,0FFFFh         "\
"jne    _loop              "\
"xchg   ebp,_ebp           "\
"mov    _ebx,ebx           "\
parm [ebx] [ecx] [edi]\
*/

  int ecx=size-hsize-1, esi=hsize*2+1;
  if( !ebx ) ebx=esi;
  do {
    int tmp;
    tmp=page[ebx];
    if( tmp < 193+32 ) {
      tmp=0;
    }
    else {
      tmp--;
    }
    page[ebx+1]=page[ebx-1]=page[ebx+hsize]=page[ebx-hsize]=
    page[ebx-hsize*2]=tmp;
    ebx-=bp++;
    while( ebx<esi ) ebx+=ecx-esi;
  } while(bp);
}

Image *pic1, *pic2;
PAGE fire, text;

void copyColor( int Y, int X1, int X2, uchar Color, PAGE page )
{
  if( Y<0 || Y>=vidSizeY ) return;
  if( X1 > X2 ) {
    int tmp = X1; X1 = X2; X2 = tmp;
  }
  if( X1 < 0 ) X1 = 0;
  if( X1 >= vidSizeX ) X1 = vidSizeX-1;
  if( X2 < 0 ) X2 = 0;
  if( X2 >= vidSizeX ) X2 = vidSizeX-1;
//  page[Y*vidBytesPerLine+X1] = 255;
//  page[Y*vidBytesPerLine+X2] = 255;
  memcpy( color+vidBytesPerLine*Y+X1, pic2->data+vidBytesPerLine*Y+X1,
          X2-X1+1 );

  for( int i=0; i<X2-X1+1; i++ ) {
    if( text[vidBytesPerLine*Y+X1+i] ) {
      bw[vidBytesPerLine*Y+X1+i] = Color;
    }
  }
}

void partFire( uint _secs )
{
  int secs = _secs - END_SECS;
  titlepic->StretchTo( vidSizeX, vidSizeY, vidBytesPerLine );
  pic1 = titlepic;
  circle = pic2 = new Image( "circle.raw", STRETCH_SCREEN );
  fire = vidAllocPage( true );
  int i;
  TPoly2D P(*fire1);

  text = vidAllocPage( true );

  TCollection strings;
  FILE* fp = resOpenFile( "text" );
  char* str;
  do {
    strings.Insert( strdup( str=getToken( fp, "\r\n" ) ) );
  } while( strcmp(str, "EOF") );
  strings.PackDelete(strings.Count-1);
  resClose(fp);

  vidSetPalette( dither->palette );
//  vidClearPage(bw,128);
  vidClearPage(fire,0);
  fire1->Draw( fillLine, 255, fire );
  uint start = miscTimer(), time=start;
  do {
    time = miscTimer();
    ll=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lr=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lls=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75,
    lrs=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75;
    lls = ((lls-ll)/vidSizeY);
    lrs = ((lrs-lr)/vidSizeY);
    int y;
    for( y=0; y<vidSizeY; y++ ) {
      FillScanLine(bw+vidBytesPerLine*y,ll<<8,((lr-ll)/(vidSizeX+1))<<8);
      ll+=lls; lr+=lrs;
    }
    if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
    if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
    lx += lxs; ly += lys;

    vidClearPage(text,0);

    y = vidSizeY-(time-start)/(secs*miscTimerRes-start)*
        (strings.Count*font->text_step_y+vidSizeY);
    for( i=0; i<strings.Count; i++ ) {
      font->DrawString( vidSizeX/2, y, (char*)strings.At(i), ALIGN_CENTER,
                        text, 250 );
      y += font->text_step_y;
    }

    vidCopyPage( color, pic1->data );
    P.MorphTo( fire1, fire2, time-start, secs*miscTimerRes-start );
    P.Draw(copyColor,255,fire);
    P.DrawEdges( 0,0,drawLinePix, fire, 255 );
    memset( fire, 0, vidBytesPerLine );
    memset( fire+vidPageSize-vidBytesPerLine, 0, vidBytesPerLine );
    doFire( fire, vidPageSize, vidBytesPerLine );
    vidCopyPageT( color, fire );
//    vidCopyPageT( bw, text );
//    SmoothPageNorm( bw, bw );
    vidDitherPage( color, bw, vpage, dither->data );
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );

  secs = _secs;
  start = miscTimer(), time=start;
  do {
    time = miscTimer();
    ll=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lr=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly+VID_MAX_SIZE_Y/2)))*65536*0.75,
    lls=(560-sqrt(sqr(lx+VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75,
    lrs=(560-sqrt(sqr(lx-VID_MAX_SIZE_X/2)+sqr(ly-VID_MAX_SIZE_Y/2)))*65536*0.75;
    lls = ((lls-ll)/vidSizeY);
    lrs = ((lrs-lr)/vidSizeY);
    for( int y=0; y<vidSizeY; y++ ) {
      FillScanLine(bw+vidBytesPerLine*y,ll<<8,((lr-ll)/(vidSizeX+1))<<8);
      ll+=lls; lr+=lrs;
    }
    if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
    if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
    lx += lxs; ly += lys;
    vidCopyPage( color, pic2->data );
    doFire( fire, vidPageSize, vidBytesPerLine );
    vidCopyPageT( color, fire );
    SmoothPageNorm( bw, bw );
    vidDitherPage( color, bw, vpage, dither->data );
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );
  delete pic1; strings.DeleteAll();
//  delete pic2; delete dither;
  vidFreePage(fire);
  vidFreePage(text);
}
