/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __MISC__
#define __MISC__

#include <stdio.h>
#include <stdlib.h>
#include "video.h"

#ifndef M_PI
#define M_PI    3.141592653589
#endif

typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;

#ifndef max
#define max(a,b)  (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)  (((a) < (b)) ? (a) : (b))
#endif

#define sqr(x)  ((x)*(x))

#define PROJECT_NAME    "HElliZER"

#define cosSteps     4096
#define cosScale     6
#define cosScale3D   16
#define asinSteps    VID_MAX_SIZE_X

extern int cosTable[cosSteps], sinTable[cosSteps];
extern int cosTable3D[cosSteps], sinTable3D[cosSteps];
extern int asinTable[asinSteps];

void error( char* );

void* cmalloc( size_t );
void* crealloc( void*, size_t );
void cfree( void* );

void Startup( bool saveconfig );
void Shutdown();

void miscSaveConfig( char* filename );
bool miscLoadConfig( char* filename );

class TCollection {
  int allocated;
public:
  void** Items;
  int Count;
  TCollection(void) {
    Count = 0; allocated = 0; Items = 0;
  };
  void Insert( void* );
  void Delete(int index);
  void Delete(void* item) { Delete(IndexOf(item)); };
  void PackDelete(int index);
  void PackDelete(void* item) { PackDelete(IndexOf(item)); };
  void Free(int index) { delete Items[index]; Delete(index); }
  void Free(void* item) { Free(IndexOf(item)); }
  void DeleteAll() { Count = 0; }
  void FreeAll();
  void* At(int index) { return Items[index]; }
  int IndexOf(void*);
  void Sort( int (*compare)(const void*,const void*) );
  void Pack();
  ~TCollection();
};

char* getToken(FILE* fp, const char* delimiters );

#define miscTimerRes    1000.0
void miscStartTimer();
uint miscTimer();

void memsetw( void* dst, short value, size_t length );

int miscGetNumber( const char* str, int min, int max );

#endif
