/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdlib.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include "music.h"
#include "misc.h"
#include "resource.h"

#define SampleChannels 8

bool musInitialized = false, musPlaying = false;
musMODULE musModule;
int ModChannels;

#include <unistd.h>
#include <fcntl.h>
#include "mikmod/mikmod.h"

static void tickhandler(void)
{
        MP_HandleTick();    /* play 1 tick of the module */
        MD_SetBPM(mp_bpm);
}

void musInitMusic(void) {
  md_dmabufsize   =16384;                    
  MD_RegisterPlayer(&tickhandler);
  ML_RegisterLoader(&load_s3m);

	/*
		Register the drivers we want to use:
	*/

	MD_RegisterDriver(&drv_raw);

#ifdef SUN
	MD_RegisterDriver(&drv_sun);
#elif defined(SOLARIS)
	MD_RegisterDriver(&drv_sun);
#elif defined(__alpha)
        MD_RegisterDriver(&drv_AF);
#elif defined(LINUX)
        MD_RegisterDriver(&drv_vox);
	#ifdef ULTRA
	       MD_RegisterDriver(&drv_ultra);
	#endif /* ULTRA */
#elif defined(__hpux)
        MD_RegisterDriver(&drv_hp);
#elif defined(AIX)
        MD_RegisterDriver(&drv_aix);
#elif defined(SGI)
        MD_RegisterDriver(&drv_sgi);
#elif defined(Win32)
	MD_RegisterDriver(&drv_win32);
#endif

/* !!! drv_nos MUST be the last registred driver */

        MD_RegisterDriver(&drv_nos);
}

void musInitCard() {
  if(!MD_Init()){
    char str[256];
    sprintf( str, "\tCannot initialize sound system for device #%d \n\t(%s)",
             md_device, myerr );
    error(str);
  }
  musInitialized = true;
}

void musLoadModule(char* name) {
  FILE* fp = resOpenFile(name);
  if( !(musModule=ML_LoadFP(fp)) ) error("Cannot load module");
  resClose(fp);
  MP_Init(musModule);
  ModChannels = musModule->numchn;
  md_numchn = ModChannels + SampleChannels;
}

void musSetModule( uchar* gm ) {
}

int parent_pid, child_pid;

void musStartMusic() {
  if( !musPlaying && md_driver!=&drv_nos ) {
    musPlaying = true;
    parent_pid=getpid();
    if( !(child_pid=fork()) ) {
      MD_PlayStart();
      musSetVolume(63);
      for(;;) {
	timeval tv;
	tv.tv_sec=0; tv.tv_usec=50000;
	select(0,0,0,0,&tv);
	MD_Update();
	int foo;
	if( getppid() != parent_pid ) {
	  exit(0);
	}
      }
    }
  }
}

void musStopMusic() {
  if( musPlaying ) {
/*
    MD_PlayStop();
*/
    ML_Free(musModule);
    if( md_driver != &drv_nos )
      kill(child_pid,SIGKILL);
    musPlaying = false;
  }
}

void musCloseMusic() {
  if( musInitialized ) {
    MD_Exit();
  }
}

void musLoadConfig( int h ) {
  read( h, &md_device, sizeof(md_device) );
  read( h, &md_mixfreq, sizeof(md_mixfreq) );
  read( h, &md_mode, sizeof(md_mode) );
}

void musSaveConfig( int h ) {
  write( h, &md_device, sizeof(md_device) );
  write( h, &md_mixfreq, sizeof(md_mixfreq) );
  write( h, &md_mode, sizeof(md_mode) );
}

int musChooseCard() {
  int c;
  puts( "Choose sound device :" );
  MD_InfoDriver();
  md_device=miscGetNumber( "Type corresponding number : ",1,99 );
  if( md_device != 1 ) {
    md_mixfreq = miscGetNumber("Enter mixing frequency (eg. 22000) : ",
			       0,50000);
    switch(miscGetNumber("Choose output mode:\n"
			 "1. 8 bits, mono\n"
			 "2. 8 bits, stereo\n"
			 "3. 16 bits, mono\n"
			 "4. 16 bits, stereo\n"
			 "Type corresponding number : ",1,4)) {
    case 1:
      md_mode=0; break;
    case 2:
      md_mode=DMODE_STEREO; break;
    case 3:
      md_mode=DMODE_16BITS; break;
    case 4:
      md_mode=DMODE_16BITS|DMODE_STEREO; break;
    }
//    md_mode|=DMODE_INTERP;
  }
  musInitCard();
}

musSAMPLE musLoadSample( char* name ) {
  FILE* fp = resOpenFile(name);
  return MW_LoadWavFP(fp);
}

void musPlaySample( musSAMPLE s, uchar volume, uchar panning, int frequency ) {
static int CurChannel = ModChannels;
  MD_VoiceSetVolume(CurChannel,volume%64);
  MD_VoiceSetPanning(CurChannel,panning);
  MD_VoiceSetFrequency(CurChannel,frequency);
  MD_VoicePlay(CurChannel,s->handle,0,s->length,0,0,s->flags);
  CurChannel++;
  if( CurChannel >= ModChannels+SampleChannels )
    CurChannel = ModChannels;
}

void musFreeSample( musSAMPLE s ) {
  MW_FreeWav(s);
}

void musSetVolume( int vol )
{
  mp_volume = uchar(1 + vol*98.0/63);
}

int musGetVolume()
{
  return mp_volume*63/100;
}
