/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __MUSIC__
#define __MUSIC__

#include "mikmod/mikmod.h"
typedef UNIMOD*         musMODULE;
typedef SAMPLE*         musSAMPLE;

#include "misc.h"

void musInitMusic(void);
void musInitCard();
void musLoadModule( char* name );
void musSetModule( uchar* );
void musFreeModule( uchar* gm );
void musStartMusic();
void musStopMusic();
musSAMPLE musLoadSample( char* name );
void musPlaySample( musSAMPLE s, uchar volume, uchar panning, int frequency );
void musFreeSample( musSAMPLE );
//  void getMusicInfo( int* pattern, int* row );
void musCloseMusic();
void musLoadConfig( int handle );
void musSaveConfig( int handle );
int musChooseCard();
void musSetVolume(int vol); //0..63
int musGetVolume();

extern bool musInitialized, musPlaying;

#endif









