/*

 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "parts.h"

RGB pal[256];
PAGE color, bw, vpage1, vpage2, vpage;
Image *titlepic, *dither, *circle, *colortext, *linepic, *line1pic;
int lx = 0, ly = 0, lxs = 10, lys = 7, ll, lr, lls, lrs;
short *zbuffer;
TPoly2D *fire1, *fire2;
FacedObject spider (NO_SHADOW | PERSPECT | MAP_BKGRND);
Font *font;
FacedObject *figs[N_FIGS];

void 
partInit ()
{
  color = vidAllocPage (true);
  bw = vidAllocPage (true);
  zbuffer = new short[vidPageSize];
  fire1 = new TPoly2D ("fire1.dxf");
  fire2 = new TPoly2D ("fire2.dxf");
  colortext = new Image (vidSizeX, vidSizeY, vidBytesPerLine, 0, color);
  linepic = new Image ("line.raw", STRETCH);
  vpage1 = vidAllocPage (false);
  vpage2 = vidAllocPage (false);
  vpage = vpage2;
  font = new Font (vidSizeX / 40, vidSizeY / 20);
//  font->Load( '.', '.', "point.dxf" );
  //  font->Load( '0', '9', "?.dxf" );
  font->Load ('a', 'z', "?.dxf");
  font->Load ('A', 'Z', "?.dxf");
  char name[10] = "fig?.asc";
  Image *texts[N_FIGS] =
  {new Image ("gold1.raw"),
   new Image ("oldmetal.raw"), colortext};
  int i;
  for (i = 0; i < N_FIGS; i++)
    {
      figs[i] = new FacedObject (SHADOW | PERSPECT /*|TWO_SIDE */ );
      name[3] = '1' + i;
//    faces[i]->Load(name,texture);
      switch (i)
	{
	case 0:
	  {
	    figs[i]->ImportASC (name, 0, VID_MAX_SIZE_X * 0.35, texts[i],
				MAP_SCALE | MAP_XY);
	    figs[i]->RotateTo (2, 3, 5);
	    figs[i]->MoveAbs (0, 0, MIN_Z / 4);
	    break;
	  }
	case 1:
	  {
	    figs[i]->ImportASC (name, 0, VID_MAX_SIZE_X * 0.35, texts[i],
				MAP_SCALE | MAP_XZ);
	    figs[i]->RotateTo (-5, 2, 3);
	    figs[i]->MoveAbs (0, 0, MAX_Z / 4);
	    break;
	  }
	case 2:
	  {
	    figs[i]->ImportASC (name, 0, VID_MAX_SIZE_X * 0.45, texts[i],
				MAP_SCALE | MAP_XY);
	    figs[i]->RotateTo (1, -3, 4);
//        figs[i]->MoveAbs(0,0,(i-1)*MAX_Z/3);
	    break;
	  }
	}
      figs[i]->Prepare ();
      figs[i]->perspect = 1.8;
    }
}

void 
partDone ()
{
  vidFreePage (vpage1);
  vidFreePage (vpage2);
  delete zbuffer;
  delete fire1;
  delete fire2;
  delete linepic;
}

void 
fillLine (int Y, int X1, int X2, uchar color, PAGE page)
{
  if (X1 > X2)
    {
      int tmp = X1;
      X1 = X2;
      X2 = tmp;
    }
  if (X1 < 0)
    X1 = 0;
  if (X1 >= vidSizeX)
    X1 = vidSizeX - 1;
  if (X2 < 0)
    X2 = 0;
  if (X2 >= vidSizeX)
    X2 = vidSizeX - 1;
  memset (page + vidBytesPerLine * Y + X1, color, X2 - X1 + 1);
}

void 
drawLine (PAGE page, int x1, int y1, int x2, int y2, uchar color)
{
  if (abs (x1 - x2) > abs (y1 - y2))
    {
      for (int i = x1; i != x2; i += (x2 - x1) / abs (x2 - x1))
	{
//      page[ (y1+(y2-y1)*(i-x1)/(x2-x1))*vidBytesPerLine+i ] = color;
	  linepic->ShowT (i - linepic->sizeX / 2,
			  (y1 + (y2 - y1) * (i - x1) / (x2 - x1)) - linepic->sizeY / 2, page);
	}
    }
  else
    {
      for (int i = y1; i != y2; i += (y2 - y1) / abs (y2 - y1))
	{
//      page[ (x1+(x2-x1)*(i-y1)/(y2-y1))+i*vidBytesPerLine ] = color;
	  linepic->ShowT ((x1 + (x2 - x1) * (i - y1) / (y2 - y1)) - linepic->sizeX / 2,
			  i - linepic->sizeY / 2, page);
	}
    }
}

void 
drawLine1 (PAGE page, int x1, int y1, int x2, int y2, uchar color)
{
  if (abs (x1 - x2) > abs (y1 - y2))
    {
      for (int i = x1; i != x2; i += (x2 - x1) / abs (x2 - x1))
	{
	  line1pic->ShowT (i - linepic->sizeX / 2,
			   (y1 + (y2 - y1) * (i - x1) / (x2 - x1)) - linepic->sizeY / 2, page);
	}
    }
  else
    {
      for (int i = y1; i != y2; i += (y2 - y1) / abs (y2 - y1))
	{
	  line1pic->ShowT ((x1 + (x2 - x1) * (i - y1) / (y2 - y1)) - linepic->sizeX / 2,
			   i - linepic->sizeY / 2, page);
	}
    }
}

void 
drawLinePix (PAGE page, int x1, int y1, int x2, int y2, uchar color)
{
  if (x1 == x2 && y1 == y2)
    {
      if (x1 >= 0 && x1 < vidSizeX && y1 >= 0 && y1 < vidSizeY)
	page[y1 * vidBytesPerLine + x1] = color;
    }
  else
    {
      if (abs (x1 - x2) > abs (y1 - y2))
	{
	  int y = y1 << 16, stepy = ((y2 - y1) << 16) / abs (x2 - x1);
	  int stepx = (x2 - x1) / abs (x2 - x1);
	  for (int x = x1; x != x2; x += stepx, y += stepy)
	    {
	      if (x >= 0 && x < vidSizeX && y >= 0 && (y >> 16) < vidSizeY)
		page[(y >> 16) * vidBytesPerLine + x] = color;
	    }
	}
      else
	{
	  int x = x1 << 16, stepx = ((x2 - x1) << 16) / abs (y2 - y1);
	  int stepy = (y2 - y1) / abs (y2 - y1);
	  for (int y = y1; y != y2; x += stepx, y += stepy)
	    {
	      if (x >= 0 && (x >> 16) < vidSizeX && y >= 0 && y < vidSizeY)
		page[y * vidBytesPerLine + (x >> 16)] = color;
	    }
	}
    }
}

void 
FillScanLine (uchar * offset, uint l, int ls)
{
  for (int i = 0; i < vidBytesPerLine; i++)
    {
      offset[i] = l >> 24;
      l += ls;
    }
}
