/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
/* port from old pascal version produces so ugly-looking code */

#include <stdio.h>
#include <string.h>
#include "poly2d.h"
#include "misc.h"
#include "resource.h"
#include "video.h"

void TPoint2D::Draw( PAGE Buffer )
{
}

void TPoint2D::Rotate( int CX, int CY, int R )
{
  R = R % cosSteps;
  if( R < 0 ) R = cosSteps+R;
  int TX = (X>>4)-(CX<<12), TY = (Y>>4)-(CY<<12);
  if( R ) {
    int TTX = ( cosTable[R]*TX+sinTable[R]*TY) / (1 << cosScale);
    int TTY = ( cosTable[R]*TY-sinTable[R]*TX) / (1 << cosScale);
    X = (TTX<<4)+(CX<<16);
    Y = (TTY<<4)+(CY<<16);
  }
}

void TPoly2D::Load(FILE* fp)
{
  int Count;
  fread( &Count, sizeof(Count),1, fp );
  int i;
  for( i=0; i<Count; i++ ) {
    PPoint2D P = new TPoint2D(0,0);
    fread( &(P->X),sizeof(P->X),1,fp);
    fread( &(P->Y),sizeof(P->Y),1,fp);
    Points.Insert(P);
  }
  fread( &Count, sizeof(Count),1, fp );
  for( i=0; i<Count; i++ ) {
    int A,B;
    fread( &A,sizeof(A),1,fp);
    fread( &B,sizeof(B),1,fp);
    Edges.Insert( new TEdge( (PPoint2D)Points.At(A), (PPoint2D)Points.At(B) ));
  }
}

void TPoly2D::Store( FILE* fp )
{
  fwrite( &(Points.Count),sizeof(Points.Count),1,fp);
  int i;
  for( i=0; i<Points.Count; i++ ) {
    int tmp = ( (PPoint2D)( Points.At(i) ) )->X;
    fwrite( &tmp,sizeof(tmp),1,fp);
    tmp = ((PPoint2D)(Points.At(i)))->Y;
    fwrite( &tmp,sizeof(tmp),1,fp);
  }
  fwrite( &(Edges.Count),sizeof(Edges.Count),1,fp);
  for( i=0; i<Edges.Count; i++ ) {
    int tmp = Points.IndexOf( ((PEdge)(Edges.At(i)))->A );
    fwrite( &tmp,sizeof(tmp),1,fp);
    tmp = Points.IndexOf( ((PEdge)(Edges.At(i)))->B );
    fwrite( &tmp,sizeof(tmp),1,fp);
  }
}

TPoly2D::TPoly2D( char* Name ):
         TPoint2D(0,0), Edges(), Points(), Min(0,0), Max(0,0)
{
  FILE* fp = resOpenFile(Name);
  if( *(strrchr( Name, '.' )+1) == '2' ) {
    Load(fp);
  }
  else {
//    printf( "loading DXF %s\n", Name );
    LoadDXF(fp);
  }
  resClose(fp);
  TPoint2D* p = (TPoint2D*)Points.At(0);
  Min.X=Max.X=p->X; Min.Y=Max.Y=p->Y;
  for( int i=0; i<Points.Count; i++ ) {
    TPoint2D* p = (TPoint2D*)Points.At(i);
    if( Min.X > p->X ) Min.X = p->X;
    if( Min.Y > p->Y ) Min.Y = p->Y;
    if( Max.X < p->X ) Max.X = p->X;
    if( Max.Y < p->Y ) Max.Y = p->Y;
  }
};

TPoly2D::TPoly2D( TPoly2D& Poly ):
  TPoint2D(0,0), Edges(), Points(), Min(0,0), Max(0,0)
{
  int i;
  for( i=0; i<Poly.Points.Count; i++ ) {
    Points.Insert( new TPoint2D( *(PPoint2D)(Poly.Points.At(i)) ) );
  }
  for( i=0; i<Poly.Edges.Count; i++ ) {
    Edges.Insert( new TEdge(
           (PPoint2D)( Points.At(
             Poly.Points.IndexOf( ((PEdge)(Poly.Edges.At(i)))->A )
           ) ),
           (PPoint2D)( Points.At(
             Poly.Points.IndexOf( ((PEdge)(Poly.Edges.At(i)))->B )
           ) ) ) );
  }
  Max.X = Poly.Max.X; Max.Y = Poly.Max.Y;
  Min.X = Poly.Min.X; Min.Y = Poly.Min.Y;
}

char* S="";
bool NewLine, was_eof;
PPoint2D P1, P2;

#define GetToken(fp) getToken(fp," \n\r" );

void TPoly2D::GetNextPoint(FILE* fp)
{
//  puts( "GetNextPoint" );
  P1 = P2;
  while ( strcmp(S,"VERTEX") && !was_eof ) {
    if( !strcmp(S,"POLYLINE") ) NewLine = true;
    S = GetToken(fp);
    if( !strcmp(S,"EOF") ) was_eof = true;
//    cout << '(' << S << ")\n";
  }
  if( was_eof ) return;
  GetToken(fp);
  GetToken(fp);
  GetToken(fp);
  S = GetToken(fp);
  float FX = atof(S);
  GetToken(fp);
  S = GetToken(fp);
  float FY = atof(S);
  GetToken(fp);
  S = GetToken(fp);
  P2 = new TPoint2D( (vidScaleX(FX)*2+vidSizeX/2)*65536.0,
                       (vidSizeY/2 - vidScaleY(FY*2))*65536.0 );
  if( !was_eof ) Points.Insert(P2);
}

void TPoly2D::GetNextEdge(FILE* fp)
{
//  puts( "GetNextEdge" );
  GetNextPoint(fp);
  if( was_eof ) return;
  if(NewLine) {
    NewLine = false;
    GetNextPoint(fp);
  }
}

void TPoly2D::LoadDXF( FILE* fp )
{
  was_eof = false;
  GetNextEdge(fp);
  while( !was_eof ) {
    Edges.Insert( new TEdge( P1, P2 ) );
    GetNextEdge(fp);
  };
}

void TEdge::PrepareToDraw()
{
  if( A->Y > B->Y ) {
    PPoint2D Tmp = A; A = B; B = Tmp;
  }
  CurX = A->X;
  if( (B->Y>>16) - (A->Y>>16) ) {
    Step = (B->X - A->X) / ((B->Y>>16) - (A->Y>>16));
  }
  else {
    Step = 0;
  }
  if( A->Y < 0 ) {
    CurX -= (A->Y>>16)*Step;
  }
}

void TPoint2D::MorphTo( PPoint2D Point1, PPoint2D Point2, int NStep, int NSteps )
{
  X = (Point2->X-Point1->X)/NSteps*NStep+Point1->X;
  Y = (Point2->Y-Point1->Y)/NSteps*NStep+Point1->Y;
}

int CompareEdgeA( const void* Key1, const void* Key2 )
{
  if( !Key1 || !Key2 ) return 0;
  if( ((PEdge)Key1)->A->Y < ((PEdge)Key2)->A->Y ) return -1;
  if( ((PEdge)Key1)->A->Y > ((PEdge)Key2)->A->Y ) return 1;
  return 0;
}

int CompareEdgeB( const void* Key1, const void* Key2 )
{
  if( !Key1 || !Key2 ) return 0;
  if( ((PEdge)Key1)->B->Y < ((PEdge)Key2)->B->Y ) return -1;
  if( ((PEdge)Key1)->B->Y > ((PEdge)Key2)->B->Y ) return 1;
  return 0;
}

int CompareEdgeX( const void* Key1, const void* Key2 )
{
  if( !Key1 || !Key2 ) return 0;
  if( ((PEdge)Key1)->CurX < ((PEdge)Key2)->CurX ) return -1;
  if( ((PEdge)Key1)->CurX > ((PEdge)Key2)->CurX ) return 1;
  return 0;
}

void TPoly2D::Draw( PFLineDraw PLine, uchar Color, PAGE Buffer )
{
  TCollection EdgesA, EdgesB, ScanLine;
  int VMin = 32767, VMax = -32767, i;
  for( i=0; i<Edges.Count; i++ ) {
    PEdge Tmp = (PEdge)(Edges.At(i));
    Tmp->PrepareToDraw();
    if( Tmp->B->Y>>16 < 0 || Tmp->A->Y>>16 > vidSizeY) continue;
    VMin = min( VMin, Tmp->A->Y>>16 );
    VMax = max( VMax, Tmp->B->Y>>16 );
    EdgesA.Insert(Tmp);
    EdgesB.Insert(Tmp);
  }
  EdgesA.Sort( CompareEdgeA );
  EdgesB.Sort( CompareEdgeB );
  if( VMin < 0 ) VMin = 0;
  if( VMax >= vidSizeY ) VMax = vidSizeY-1;

  int K = 0, L = 0;
  PEdge Tmp;

  for( i=VMin; i<=VMax; i++ ) {

    if( K < EdgesA.Count ) {
      Tmp = PEdge(EdgesA.At(K));
      while (Tmp->A->Y>>16 <=i) {
        ScanLine.Insert( Tmp );
        if( ++K >= EdgesA.Count ) break;
        Tmp = (PEdge)(EdgesA.At(K));
      }
    }
    if( L < EdgesB.Count ) {
      Tmp = (PEdge)(EdgesB.At(L));
      while( Tmp->B->Y>>16 == i) {
        ScanLine.PackDelete( Tmp );
        if( ++L >= EdgesB.Count ) break;
        Tmp = (PEdge)(EdgesB.At(L));
      }
    }

    if( !ScanLine.Count ) continue;

    if( ScanLine.Count % 2 ) {
      error( "poly2d draw bug" );
    }

    int J = 1;
//    ScanLine.Pack();
    ScanLine.Sort( CompareEdgeX );
    PEdge Tmp1 = PEdge(ScanLine.At(0));
    do {
      Tmp = Tmp1;
      Tmp1 = (PEdge)(ScanLine.At(J));
      PLine( i, Tmp->CurX>>16, Tmp1->CurX>>16, Color, Buffer );
      Tmp->CurX += Tmp->Step;
      if( ++J >= ScanLine.Count ) break;
      Tmp = Tmp1;
      Tmp1 = (PEdge)(ScanLine.At(J));
      Tmp->CurX += Tmp->Step;
      J++;
    } while(1);
    Tmp1->CurX += Tmp1->Step;
  }
  EdgesA.DeleteAll();
  EdgesB.DeleteAll();
  ScanLine.DeleteAll();
}

void TPoly2D::Move( int DX, int DY )
{
  for( int i=0; i<Points.Count; i++ )
    ((PPoint2D)(Points.At(i)))->Move( DX,DY );
  Max.Move(DX,DY);
  Min.Move(DX,DY);
}

void TPoly2D::MoveTo( PPoly2D Poly, int DX, int DY )
{
  for( int i=0; i<Points.Count; i++ ) {
    *((PPoint2D)(Points.At(i))) = *((PPoint2D)(Poly->Points.At(i)));
    ((PPoint2D)(Points.At(i)))->Move( DX,DY );
  }
  Min = Poly->Min; Max = Poly->Max;
  Min.Move(DX,DY);
  Max.Move(DX,DY);
}

void TPoly2D::Rotate( int CX, int CY, int R )
{
  for( int i=0; i<Points.Count; i++ )
    ((PPoint2D)(Points.At(i)))->Rotate( CX,CY,R );
}

void TPoly2D::RotateTo( PPoly2D Poly, int CX, int CY, int R )
{
  for( int i=0; i<Points.Count; i++ ) {
    *((PPoint2D)(Points.At(i))) = *((PPoint2D)(Poly->Points.At(i)));
    ((PPoint2D)(Points.At(i)))->Rotate( CX,CY,R );
  }
}

void TPoly2D::MorphTo( PPoly2D Poly1, PPoly2D Poly2, int NStep, int NSteps )
{
  for( int i=0; i<Points.Count; i++ ) {
    ((PPoint2D)(Points.At(i)))->MorphTo(
      (PPoint2D) (Poly1->Points.At(i)),
      (PPoint2D) (Poly2->Points.At(i)), NStep, NSteps );
  }
}

void TPoint2D::Scale( int CX, int CY, double RX, double RY )
{
  int NCX,NCY;
  NCX = CX<<16; NCY = CY<<16;
//  printf( "X=%d, NCX=%d, RX=%d\n", X,NCX,RX );
  X = (X-NCX)*RX + NCX;
  Y = (Y-NCY)*RY + NCY;
}

void TPoly2D::Scale( int CX, int CY, double RX, double RY )
{
  for( int i=0; i<Points.Count; i++ )
    ((PPoint2D)(Points.At(i)))->Scale( CX,CY, RX,RY );
//  printf( "%d: Min(%d,%d), Max(%d,%d)\n",this,Min.X,Min.Y,Max.X,Max.Y);
  Min.Scale(CX,CY,RX,RY);
  Max.Scale(CX,CY,RX,RY);
}

void TPoly2D::ScaleTo( PPoly2D Poly, int CX, int CY, double RX, double RY )
{
  for( int i=0; i<Points.Count; i++ ) {
    *((PPoint2D)(Points.At(i))) = *((PPoint2D)(Poly->Points.At(i)));
    ((PPoint2D)(Points.At(i)))->Scale( CX,CY, RX,RY );
  }
  Min = Poly->Min; Max = Poly->Max;
  Min.Scale(CX,CY,RX,RY);
  Max.Scale(CX,CY,RX,RY);
}

TPoly2D::~TPoly2D()
{
  Edges.DeleteAll();
}

void TPoly2D::DrawEdges( int x, int y, EdgeDrawProc p, PAGE page, uchar Color )
{
  for( int i=0; i<Edges.Count; i++ ) {
    PEdge e = (PEdge)Edges.At(i);
    p( page, x+(e->A->X>>16), y+(e->A->Y>>16),
             x+(e->B->X>>16), y+(e->B->Y>>16), Color );
  }
}
