/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "resource.h"
#include "video.h"
#include "misc.h"
#include "image.h"
#include "3d.h"
#include "poly2d.h"
#include "smooth.h"
#include "parts.h"

#define FADE_TIME (miscTimerRes*5)
#define KNIFE_SECS 7
//#define SPIDER_FADE_TIME (miscTimerRes*1)
#define SPIDER_SECS 15
#define FADE_OUT_TIME (miscTimerRes*3)

void partTitle( uint _secs )
{
  int secs=_secs-KNIFE_SECS-SPIDER_SECS;
  Image sign( "indy1.rle" );
  PAGE bw_org = vidAllocPage( true );
  TPoly2D title( "title.dxf" );
  Image colorpic( "title1.raw", STRETCH_SCREEN ),
        texture("gold1.raw"), texture1("oldmetal.raw"),
        droppic( "drop.raw", STRETCH );
  dither = new Image( "dither2.raw" );
//  vidSetPalette( 0, 256, dither.palette );
  for( int y=0; y<vidSizeY; y++ ) {
    memset( bw_org+y*vidBytesPerLine, 170-y*90/vidSizeY, vidBytesPerLine );
  }

  FacedObject knife(NO_SHADOW|PERSPECT);
  knife.ImportASC( "knife.asc", "Object01", VID_MAX_SIZE_Y*0.8,
                   &texture, MAP_YZ|MAP_SCALE);
  knife.ImportASC( "knife.asc", "Object02",
                   VID_MAX_SIZE_Y*0.8, &texture, MAP_YZ|MAP_SCALE);
  knife.ImportASC( "knife.asc", "Object03",
                   VID_MAX_SIZE_Y*0.8, &texture1, MAP_YZ|MAP_SCALE);
  knife.ImportASC( "knife.asc", "Object04",
                   VID_MAX_SIZE_Y*0.8, &texture1, MAP_XY|MAP_SCALE);
  knife.MoveAbs( 0,0,-knife.minz);
  knife.Prepare();

/*
  spider.ImportASC( "spider.asc", 0,
                    VID_MAX_SIZE_Y*0.8, &colorpic, MAP_XZ|MAP_NOSCALE);
*/
  spider.Load( "spider.3d", colortext );
  spider.Prepare();
  spider.RotateTo( -cosSteps/4, 0, 0 );
  spider.MoveTo( 0,0,MIN_Z-spider.maxz);
//  spider.perspect = 0.5;

#define DROP_TIME (miscTimerRes/20)

  struct drop {
    int x,y,step,time;
    drop( int _x, int _y, int _step, int _time ) {
      x = _x; y = _y; step= _step; time = _time;
    }
  };
  TCollection drops;

//  for( int i=0; i<droppic.sizeY*droppic.bytesPerLine; i++ ) {
//    if( droppic.data[i] )
//      droppic.data[i] = 192+32+(i/droppic.bytesPerLine)*32/droppic.sizeY;
//      droppic.data[i] = 255;
//  }
  RGB tmp_pal[256];

  int frames=0;
  int start = miscTimer(), time=start, drop_time=time;
  int edge_time = (secs*miscTimerRes-start)/title.Edges.Count;
  int n,prevn=0;
  bool pal_set = false;
  do {
    time = miscTimer();
    if( time>secs*miscTimerRes ) time=secs*miscTimerRes;

    if( !pal_set ) {
      if( time-start > FADE_TIME ) {
        vidSetPalette( dither->palette );
        memcpy( pal, dither->palette, sizeof(pal) );
        pal_set = true;
      }
      else {
        for( int i=0; i<256; i++ ) {
          int add = MAX_RGB*2*(time-start)/(FADE_TIME);
          if( pal[i].red-add < dither->palette[i].red )
            tmp_pal[i].red = dither->palette[i].red;
          else
            tmp_pal[i].red = pal[i].red - add;
          if( pal[i].green+add > dither->palette[i].green )
            tmp_pal[i].green = dither->palette[i].green;
          else
            tmp_pal[i].green = pal[i].green + add;
          if( pal[i].blue+add > dither->palette[i].blue )
            tmp_pal[i].blue = dither->palette[i].blue;
          else
            tmp_pal[i].blue = pal[i].blue + add;
        }
        vidSetPalette( tmp_pal );
      }
    }
    memsetw( zbuffer, MIN_Z, vidPageSize );
    vidCopyPage(color,colorpic.data);
    while( drop_time <= time ) {
      int n = (drop_time-start)/edge_time, l = (drop_time-start)%edge_time;
      if( n>=title.Edges.Count ) break;
      int x1 = ((PEdge)title.Edges.At(n))->A->X >> 16,
          y1 = ((PEdge)title.Edges.At(n))->A->Y >> 16,
          x2 = ((PEdge)title.Edges.At(n))->B->X >> 16,
          y2 = ((PEdge)title.Edges.At(n))->B->Y >> 16;
  //    droppic.ShowT( x1+(x2-x1)*l/edge_time, y1+(y2-y1)*l/edge_time,
  //                   colorpic.data );
      drops.Insert( new drop( x1+(x2-x1)*l/edge_time, y1+(y2-y1)*l/edge_time,
                              vidSizeX/10-rand()%(vidSizeX/5), time ) );
      drop_time += DROP_TIME;
    }
    SmoothPage( bw_org, bw );
    int i;
    for( i=0; i<drops.Count; i++ ) {
      drop* d = (drop*)drops.At(i);
      int x = d->x + (time-d->time)*d->step/miscTimerRes*vidSizeX/VID_MAX_SIZE_X,
          y = d->y + sqr((time-d->time)/miscTimerRes)*vidSizeY/10;
      if( x<0 || x>=vidSizeX || y<0 || y>=vidSizeY ) {
        drops.Delete(d); delete d; d=0;
      }
      if(d) {
        droppic.ShowAdd( x-droppic.sizeX/2, y-droppic.sizeY/2, bw );
        color[y*vidBytesPerLine+x]=255;
      }
    }
    drops.Pack();
    do {
      n = (time-start)/edge_time;
      int l = (time-start)%edge_time;
      if( prevn != n ) {
        n=prevn++;
        l=edge_time;
      }
      if( n>=title.Edges.Count ) break;
      int x1 = ((PEdge)title.Edges.At(n))->A->X >> 16,
          y1 = ((PEdge)title.Edges.At(n))->A->Y >> 16,
          x2 = ((PEdge)title.Edges.At(n))->B->X >> 16,
          y2 = ((PEdge)title.Edges.At(n))->B->Y >> 16;
      x1 = x1*VID_MAX_SIZE_X/vidSizeX-VID_MAX_SIZE_X/2;
      y1 = y1*VID_MAX_SIZE_Y/vidSizeY-VID_MAX_SIZE_Y/2;
      x2 = x2*VID_MAX_SIZE_X/vidSizeX-VID_MAX_SIZE_X/2;
      y2 = y2*VID_MAX_SIZE_Y/vidSizeY-VID_MAX_SIZE_Y/2;
      knife.MoveTo( x1+(x2-x1)*l/edge_time, y1+(y2-y1)*l/edge_time, 0 );
      drawLine( bw_org,
                vidScaleX(x1)+vidSizeX/2,vidScaleY(y1)+vidSizeY/2,
                vidScaleX(knife.dx)+vidSizeX/2,
                vidScaleY(knife.dy)+vidSizeY/2, 255 );
    } while( prevn!=n );
    knife.RotateTo( knife.dx*cosSteps/4/VID_MAX_SIZE_X,
                    knife.dy*cosSteps/4/VID_MAX_SIZE_X, 0 );
    knife.SetLightTo( vidScaleX(knife.dx),vidScaleY(knife.dy), 1, 0 );
    knife.Draw(zbuffer,color,bw);
/*
    for( i=0; i<title.Edges.Count; i++ ) {
      PEdge e = (PEdge)title.Edges.At(i);
      drawLine( bw_org, e->A->X>>16,e->A->Y>>16,
                       e->B->X>>16,e->B->Y>>16, 255 );
    }
*/
//    sign.ShowTB( -(time-start)*(sign.sizeX-vidSizeX)/(secs*miscTimerRes-start),
//                 (vidSizeY-sign.sizeY)/2, 255, bw );
//    SmoothPage( bw, bw );
//    sign.Show( 0,0, color );
    vidDitherPage(color,bw,vpage,dither->data);
    vidFlipPage(&vpage,vpage1,vpage2);
  } while( time<secs*miscTimerRes );

  secs=_secs-SPIDER_SECS;
  start=miscTimer();
//  knife.MoveAbs( 0,0,knife.minz);
//  knife.MoveTo( knife.dx,knife.dy,-knife.minz );
  int x1=knife.dx,y1=knife.dy,z1=knife.dz,
      rx1=knife.rx,ry1=knife.ry,rz1=knife.rz;

  while( time<secs*miscTimerRes) {
    memsetw( zbuffer, MIN_Z, vidPageSize );
    SmoothPage( bw_org, bw );
    vidCopyPage(color,colorpic.data);
    int i;
    for( i=0; i<drops.Count; i++ ) {
      drop* d = (drop*)drops.At(i);
      int x = d->x + (time-d->time)*d->step/miscTimerRes*vidSizeX/VID_MAX_SIZE_X,
          y = d->y + sqr((time-d->time)/miscTimerRes)*vidSizeY/10;
      if( x<0 || x>=vidSizeX || y<0 || y>=vidSizeY ) {
        drops.Delete(d); delete d; d=0;
      }
      if(d) {
        droppic.ShowAdd( x-droppic.sizeX/2, y-droppic.sizeY/2, bw );
        color[y*vidBytesPerLine+x]=255;
      }
    }
    drops.Pack();
    knife.SetLightTo( knife.dx,knife.dy, 1, 0 );
    knife.dx = x1-(VID_MAX_SIZE_X/2+x1)*(time-start)/(secs*miscTimerRes-start);
    knife.dy = y1-(-y1)*(time-start)/(secs*miscTimerRes-start);
    knife.dz = z1+MAX_Z*(time-start)/(secs*miscTimerRes-start);
    knife.rx = rx1-(-rx1)*(time-start)/(secs*miscTimerRes-start);
    knife.ry = ry1-(cosSteps/2-ry1)*(time-start)/(secs*miscTimerRes-start);
    knife.rz = rz1-(-rz1)*(time-start)/(secs*miscTimerRes-start);
//    double scale = 1+5*(time-start)/(secs*miscTimerRes-start);
//    knife.ScaleTo( scale, scale, scale );
    knife.Draw(zbuffer,color,bw);
    vidDitherPage(color,bw,vpage,dither->data);
    vidFlipPage(&vpage,vpage1,vpage2);
    time=miscTimer();
  };

  secs=_secs;
  start=miscTimer();
//  knife.MoveTo( knife.dx,knife.dy,-knife.minz );
  x1=spider.dx,y1=spider.dy,z1=spider.dz,
  rx1=spider.rx,ry1=spider.ry,rz1=spider.rz;

  while( time<secs*miscTimerRes) {
    memsetw( zbuffer, MIN_Z, vidPageSize );
    SmoothPage( bw_org, bw_org );
    SmoothPage( bw_org, bw );
    vidCopyPage(color,colorpic.data);
    if( spider.dz > MIN_Z+spider.minz ) {
      if( abs(lx) >= VID_MAX_SIZE_X/5 ) lxs = -lxs;
      if( abs(ly) >= VID_MAX_SIZE_Y/5 ) lys = -lys;
      lx += lxs; ly += lys;
      spider.SetLightTo( lx,ly, 1, 0 );
    }
//    spider.SetLightTo( lx,ly, 1, 0 );
//    spider.dx = x1-(VID_MAX_SIZE_X/2+x1)*(time-start)/(secs*miscTimerRes-start);
//    spider.dy = y1-(-y1)*(time-start)/(secs*miscTimerRes-start);
    if( time-start < (secs*miscTimerRes-start)/2 ) {
      spider.dz = -MAX_Z-spider.maxz+4*MAX_Z*(time-start)/(secs*miscTimerRes-start);
      for( int i=0; i<256; i++ ) {
        int add = MAX_RGB/2*(double)(spider.dz+spider.maxz+MAX_Z)/MAX_Z/2;
        if( dither->palette[i].red+add > MAX_RGB ) pal[i].red = MAX_RGB;
        else pal[i].red = dither->palette[i].red + add;
        if( dither->palette[i].green+add/2 > MAX_RGB ) pal[i].green = MAX_RGB;
        else pal[i].green = dither->palette[i].green + add/2;
        pal[i].blue = dither->palette[i].blue;
      }
      vidSetPalette( pal );
    }
    else {
      spider.dz = 3*MAX_Z-spider.maxz-4*MAX_Z*(time-start)/(secs*miscTimerRes-start);
      for( int i=0; i<256; i++ ) {
        int add = MAX_RGB/2-MAX_RGB/2*(double)(spider.dz+spider.maxz+MAX_Z)/MAX_Z/2;
        if( pal[i].red-add < 0 ) tmp_pal[i].red = 0;
        else tmp_pal[i].red = pal[i].red - add;
        if( pal[i].green-add < 0 ) tmp_pal[i].green = 0;
        else tmp_pal[i].green = pal[i].green - add;
        if( pal[i].blue-add < 0 ) tmp_pal[i].blue= 0;
        else tmp_pal[i].blue = pal[i].blue - add;
      }
      vidSetPalette( tmp_pal );
    }
//    printf( "spider.dz=%d\n", spider.dz );
    spider.rx = rx1+(cosSteps*1.75-rx1)*(time-start)/(secs*miscTimerRes-start);
    spider.ry = ry1-(cosSteps/4-ry1)*sin((time-start)/(secs*miscTimerRes-start)*2*M_PI);
//    spider.rz = rz1-(-rz1)*(time-start)/(secs*miscTimerRes-start);
//    double scale = 1+5*(time-start)/(secs*miscTimerRes-start);
//    knife.ScaleTo( 200, 200, 200);
    spider.Draw(zbuffer,color,bw);
    vidDitherPage(color,bw,vpage,dither->data);
    vidFlipPage(&vpage,vpage1,vpage2);
    time=miscTimer();
  };
  memcpy( pal, tmp_pal, sizeof(pal) );
}
