/*
 *
 *   HElliZER: the first portable demo in the world
 *
 *   Copyright (C) 1996  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@dixon.volgacom.samara.su>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include <math.h>
#include "misc.h"
#include "image.h"
#include "video.h"
#include "smooth.h"
#include "3d.h"
#include "parts.h"

#define TREE_TIME (miscTimerRes*5)
#define PHASE_TIME (miscTimerRes/4)
#define BIRD_TIME (miscTimerRes*6)
#define FIG_TIME  (miscTimerRes*7)
#define FADE_TIME (miscTimerRes*5)

struct tree {
  int x,y,time,dx;
  Image* image;
};

struct bird {
  int x,time;
};

int compare_tree( const void* t1, const void* t2 )
{
  if( ((tree*)t1)->time > ((tree*)t2)->time ) return -1;
  if( ((tree*)t1)->time < ((tree*)t2)->time ) return 1;
  return 0;
}

void partTrees( uint secs )
{
  Image forest( "forest1.raw", STRETCH_SCREEN ),
        dither( "dither1.raw" ),
        tree1( "tree1.raw", STRETCH ),
        tree2( "tree2.raw", STRETCH ),
        tree3( "tree3.raw", STRETCH ),
        texture("gold.raw");
  FacedObject figure(NO_SHADOW|PERSPECT);
  figure.ImportASC( "pentagrm.asc", 0, VID_MAX_SIZE_Y*0.8, &texture,
                    MAP_YZ|MAP_SCALE);
  figure.Prepare();

#define N_BIRD (sizeof(birds)/sizeof(birds[0]))

  TPoly2D* birds[] = {
/*
                       new TPoly2D("hawkx0.dxf"),
                       new TPoly2D("hawkx1.dxf"),
                       new TPoly2D("hawkx2.dxf"),
                       new TPoly2D("hawkx3.dxf")
*/
                       new TPoly2D("bird1.dxf"),
                       new TPoly2D("bird2.dxf"),
                     };
//  figure.RotateTo( cosSteps/4, 0, 0 );
  int i;
  PAGE bw2 = vidAllocPage( true );
  TCollection treecol, birdcol;
  vidClearPage(bw,128); vidClearPage(bw2,128);
  int start = miscTimer(), time=start, treetime=time,
      birdtime=time, prevtime = time;
  bool pal_set = false;
  do {
    prevtime = time;
    time = miscTimer();
    if( time > secs*miscTimerRes ) time = secs*miscTimerRes;

    if( !pal_set ) {
      if( time-start > FADE_TIME ) {
        vidSetPalette( dither.palette );
        memcpy( pal, dither.palette, sizeof(pal) );
        pal_set = true;
      }
      else {
        for( int i=0; i<256; i++ ) {
          pal[i].red = dither.palette[i].red*(time-start)/(FADE_TIME);
          pal[i].green = dither.palette[i].green*(time-start)/(FADE_TIME);
          pal[i].blue = dither.palette[i].blue*(time-start)/(FADE_TIME);
        }
        vidSetPalette( pal );
      }
    }

    while( time > birdtime ) {
      bird* t = new bird;
      t->x=vidSizeX/2-rand()%(vidSizeX);
      t->time=time;
      birdcol.Insert(t);
      birdtime += miscTimerRes/5;
    }

    while( time > treetime ) {
      tree* t = new tree;
      switch( rand()%3 ) {
        case 0: t->image = &tree1; break;
        case 1: t->image = &tree2; break;
        case 2: t->image = &tree3; break;
      }
      do {
        t->x=(vidSizeX+t->image->sizeX)/2-rand()%(vidSizeX+t->image->sizeX);
      } while( abs(t->x) < vidSizeX/10 );
      t->dx = t->x/4;
      t->y=(vidSizeY+t->image->sizeY)/20-rand()%(vidSizeY+t->image->sizeY)/10;
      t->time=time;
      treecol.Insert(t);
      treetime += miscTimerRes/5;
    }
    vidCopyPage( color, forest.data );

    for( i=0; i<birdcol.Count; i++ ) {
      bird* t = (bird*)birdcol.At(i);
      if( time-t->time >= TREE_TIME ) {
        birdcol.Delete(t);
        delete t; t=0;
      }
      if( t ) {
        double scale=(4.1-4*(time-t->time)/TREE_TIME);
        int n = (t->time-time)/PHASE_TIME;
//	printf( "%d\n", birds[0] );
	TPoly2D p( *birds[0] );
        p.MorphTo( birds[n%N_BIRD], birds[(n+1)%N_BIRD],
                   (time-t->time)%int(PHASE_TIME), PHASE_TIME );
//        int x = (t->x+cos(time/miscTimerRes*M_PI)*vidSizeX/10)/scale;
        int x = t->x/scale;
        p.Scale( vidSizeX/2, vidSizeY/2, 1/scale/2, 1/scale/2 );
        p.Move( x, -vidSizeY/3/scale );
        p.Draw( fillLine,250,bw );
      }
    }
    birdcol.Pack();

    treecol.Sort( &compare_tree );
    int i;
    for( i=0; i<treecol.Count; i++ ) {
      tree* t = (tree*)treecol.At(i);
      if( time-t->time >= TREE_TIME ) {
        treecol.Delete(t);
        delete t; t=0;
      }
      if( t ) {
        double scale=(8.1-8*(time-t->time)/TREE_TIME);
        int w = t->image->sizeX / scale,
            h = t->image->sizeY / scale,
            x = vidSizeX/2+
            (t->x+cos(time/miscTimerRes*M_PI)*vidSizeX/10+t->dx)/scale-w/2,
            y = vidSizeY/2+
            (t->y+sin(time/miscTimerRes*M_PI*2)*vidSizeY/30)/scale-h*3/4;
        t->image->ShowRTC( x, y, w, h, 255-255*(time-t->time)/TREE_TIME, bw );
//        t->image->ShowRT( x, y, w, h, color );
      }
    }
    treecol.Pack();
    SmoothPage( bw, bw2 );

//    AlignToPage( bw, bw_org, 10 );
//    SmoothPageVNorm( bw, bw );
//    SmoothPageNorm( bw, bw );
    memsetw( zbuffer, MIN_Z, vidPageSize );

    if( (time-start) > secs*miscTimerRes-start-FIG_TIME ) {
      int current = time-start-(secs*miscTimerRes-start-FIG_TIME);
      figure.RotateTo( cosSteps/4*current/FIG_TIME,
                       cosSteps*2*current/FIG_TIME, figure.rz );
      double scale=1/(25*(1+FIG_TIME-current)/FIG_TIME);
      if( scale > 10 ) {
        scale = 10;
      }
      figure.ScaleTo( scale, scale, scale/2 );
      figure.Draw( zbuffer, color, bw2 );

      RGB tmp_pal[256];
      for( int i=0; i<256; i++ ) {
	tmp_pal[i].red = pal[i].red+MAX_RGB*scale;
	if( tmp_pal[i].red > MAX_RGB ) tmp_pal[i].red = MAX_RGB;
	tmp_pal[i].green = pal[i].green;
	tmp_pal[i].blue = pal[i].blue;
      }
      vidSetPalette( tmp_pal );

    }
    vidDitherPage( color, bw2, vpage, dither.data );
    AlignPage( bw, (time-prevtime)/miscTimerRes*100, 128 );
    vidFlipPage(&vpage,vpage1,vpage2);
//    printf( "time=%d, end_time=%d\n", time, int(secs*miscTimerRes) );
  } while( time != secs*miscTimerRes );
  vidFreePage(bw2);
  treecol.FreeAll();
  for( i=0; i<256; i++ ) {
    pal[i].red = MAX_RGB;
    pal[i].green = 0;
    pal[i].blue = 0;
  }
  vidSetPalette( pal );
}


