/*****************************************************
 *          Color utilities.
 *
 *                       Skal96
 *****************************************************/

#ifndef _DRV_COL_H_
#define _DRV_COL_H_

#include "main.h"

/*****************************************************/

typedef struct {

   SHORT Timer, Start, Size, Speed; 
   COLOR_ENTRY Pal[256];
   COLOR_ENTRY Dst_Pal[256];
   SHORT Col_Fix8[256*3*2];
   MEM_ZONE *Drv;

} COLOR_FADER;

extern COLOR_FADER *Drv_Setup_Fader(
   COLOR_FADER *CF, MEM_ZONE *Drv, INT Start, INT Size, INT Speed );
extern SHORT Drv_Prepare_Fade_To_Color( COLOR_FADER *CF, PIXEL R, PIXEL G, PIXEL B );
extern SHORT Drv_Do_Fade_To( COLOR_FADER *CF );

#define DRV_DO_FADE_TO(CF)        if ((CF)->Timer) Drv_Do_Fade_To( (CF) )

/*****************************************************/

extern void Drv_RGB_To_CMap_Entry( COLOR_ENTRY *CMap, PIXEL *Ptr, INT Nb ) ;

extern void Drv_Fill_Pal( COLOR_ENTRY *Pal, INT I, PIXEL r, PIXEL g, PIXEL b );
extern void Drv_Copy_Pal( COLOR_ENTRY *Src, COLOR_ENTRY *Dst, INT );
extern void Drv_Black_Pal( COLOR_ENTRY *Pal, INT I );

extern COLOR_ENTRY *Drv_New_Colormap( INT Size );

/*****************************************************/

extern void Drv_Build_Ramp( COLOR_ENTRY *Pal, INT Start, INT End,
	PIXEL r1, PIXEL g1, PIXEL b1, PIXEL r2, PIXEL g2, PIXEL b2 );

extern void Drv_Build_RGB_Cube( COLOR_ENTRY *, FORMAT );

extern INT Drv_Best_Match_RGB( PIXEL R, PIXEL G, PIXEL B, COLOR_ENTRY *C, INT n );

/*****************************************************/


#endif   /* _DRV_COL_H_ */
