/***********************************************
 *              Main header                    *
 * Skal 96                                     *
 ***********************************************/ 

#ifndef _MAIN_H_
#define _MAIN_H_

#define DEBUG_VIDEO  4

#define EXTERN	
#define INLINE    inline

#ifndef FALSE
#define FALSE     0
#endif
#ifndef TRUE
#define TRUE      1
#endif
#ifndef NULL
#define NULL		0
#endif

typedef void               VOID;
typedef char               BYTE;
typedef char              *STRING;
typedef unsigned char      PIXEL;
typedef short int          SHORT;
typedef unsigned long      UINT;
typedef long               INT;
typedef unsigned short int USHORT;
typedef long long int      LINT;

typedef PIXEL COLOR_ENTRY[4];

#define BLUE_F           0
#define GREEN_F          1
#define RED_F            2
#define ALPHA_F          3
#define INDEX_F          3
#define COL_BITS_FIX     8
#define POS_PACKED         0x00000000

      /* I/O standard and custom */

#include "mem_map.h"
#include "msg.h"
#include "mem.h"
#include "cvrt_col.h"
#include "driver.h"
#include "drv_col.h"

/***************************************************************/
/***************** Target-specific #defines ... ****************/
/***************************************************************/

      /**************** UNIX *******************/

#ifdef UNIX

#define CLOCKS_PER_SEC 1000000
#define _Clock(T)  (T)=0

#define memmove(a,b,c)     bcopy((b),(a),(c))
#define BZero(P,l)   bzero( (P),(l) )
#define MemCopy(D,S,l) memcpy( (D), (S), (l) )
#define F_MemCopy(D,S,l,L) memcpy( (D), (S), (l) )

#define SEEK_SET  0
#define SEEK_CUR  1
#define SEEK_END  2

extern char *sys_errlist[];
#define strerror(e)  (sys_errlist[ (e) ])

#ifndef RAND_MAX
#define RAND_MAX (DBL)( ((long long int)1<<32)-1 )
#endif

#endif

      /**************** LINUX *******************/

#ifdef LNX

#define memmove(a,b,c)     bcopy((b),(a),(c))

#endif

      /**************** DOS || LINUX *******************/

#if defined( LNX ) || defined( DOS )

#define _Clock(T)                \
      asm( "\t.byte 0x0F\n"      \
           "\t.byte 0x31\n"      \
           "\tmovl %%eax,%0\n"   \
           : "=g" ( (T) )        \
           :                     \
           : "eax", "edx" )

#define BZero(P,l)          \
asm( "\tmovl %0,%%edi\n"    \
     "\txorl %%eax,%%eax\n" \
     "\tmovl %1,%%ecx\n"    \
     "\tcld\n"              \
     "\trep\n"              \
     "\tstosl\n"            \
     :                      \
     : "g" (P), "g" ((l)/4) \
     : "ecx", "edi", "eax" )

#define MemCopy(D,S,l)               \
asm( "\tmovl %0,%%edi\n"             \
     "\tmovl %1,%%esi\n"             \
     "\tmovl %2,%%ecx\n"             \
     "\tcld\n"                       \
     "\trep\n"                       \
     "\tmovsl\n"                     \
     :                               \
     : "g" (D), "g" (S), "g" ((l)/4) \
     : "ecx", "edi", "esi" )

   /* 20% faster using FPU. Size must be 16 multiple. 
      Dst must not be in the cache. Dst and Src must be 8-aligned */
#define F_MemCopy(D,S,l,Lbl)         \
asm( "\tmovl %0,%%edi\n"             \
     "\tmovl %1,%%esi\n"             \
     "\tmovl %2,%%ecx\n"             \
     "\tmovl $16,%%eax\n"            \
     Lbl "_1:\n"                     \
     "\tfildll (%%esi)\n"            \
     "\tfildll 8(%%esi)\n"           \
    "\tfxch\n"                       \
     "\taddl %%eax,%%esi\n"          \
     "\tfistpll (%%edi)\n"           \
     "\tfistpll 8(%%edi)\n"          \
     "\taddl %%eax,%%edi\n"          \
     "\tdecl %%ecx\n"                \
     "\tjg " Lbl "_1\n"             \
     :                               \
     : "g" (D), "g" (S), "g" ((l)/16) \
     : "eax", "ecx", "edi", "esi" )

#endif

/***************************************************************/

#endif /* _MAIN_H_ */

