/***********************************************
 *    colors masks utilities                   *
 * Skal 96                                     *
 ***********************************************/

#include "main.h"

/*******************************************************************/

EXTERN UINT Bit_Masks[] =
   { 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF };

static INT Max_Masks = 0, Nb_Masks;
static RGB_MASK **Masks = NULL;
static USHORT User_Defined_Mask = 0x0000;

/*******************************************************************/

EXTERN void (*_Convert_Tab_[])( CMAPPER *, PIXEL *, PIXEL *, INT ) =
{
   RGB8_To_RGB8, RGB8_To_RGB16, RGB8_To_RGB24, RGB8_To_RGB32,
   RGB16_To_RGB8, RGB16_To_RGB16, RGB16_To_RGB24, RGB16_To_RGB32,
   RGB24_To_RGB8, RGB24_To_RGB16, NULL, RGB24_To_RGB32,
   RGB32_To_RGB8, RGB32_To_RGB16, RGB32_To_RGB24, NULL
};

static void *Indexer_Tab[4] =
{
   NULL, CMap8_To_RGB16, CMap8_To_RGB24, CMap8_To_RGB32
};

static void *Ditherer_Tab[4] =
{
   RGB8_To_CMap8, RGB16_To_CMap8, RGB24_To_CMap8, RGB32_To_CMap8
};

/*******************************************************************/

EXTERN FORMAT Compute_Format_Depth( FORMAT Format )
{
   INT D, i;
   D = 0;

   if ( (Format&0x0000F000)!=0 ) return( Format ); /* already computed */
   if ( Format == 0xFFFFFFFF ) return( Format );
   if ( (Format&0xFFF) == 0x000 ) return( (Format&0xFFFF0FFF) | 0x1000 );
   for( i=0; i<12; i+=4 ) D += (Format>>i)&0x0F;
   D = (D+7)/8;
   return( Format | D<<12 );
}


EXTERN RGB_MASK *New_Masks( FORMAT In, FORMAT Out )
{
   RGB_MASK *New, **Tab;
   INT i;
   INT In_Depth, Out_Depth;

   if ( In == 0xFFFF )
   {
      In = 0xFFFF0000 | User_Defined_Mask;
      User_Defined_Mask++;
   }

   for( i=0; i<Max_Masks; ++i )
   {
      if ( Masks[i]==NULL ) continue;
      if ( Masks[i]->In!=In || Masks[i]->Out!=Out ) continue;
      New = Masks[i];
      Masks[i]->Users++;
      return( New );
   }

   New = New_Object( 1, RGB_MASK );
   if ( New==NULL ) return( NULL );
   Nb_Masks++;
   New->Type = RGB_MASK_TYPE;
   New->In = In;
   New->Out = Out;
   New->Users = 1;
   In_Depth = Format_Depth( In );
   Out_Depth = Format_Depth( Out );
   if ( (In_Depth>0) && (In!=Out) )
   {
      New->Col_Convert = _Convert_Tab_[ Out_Depth+4*In_Depth-5 ];
      Build_RGB_Convertion_Mask( In, Out, New->Masks );
   }
   else New->Col_Convert = NULL;    

   for( i=0; i<Max_Masks; ++i )
       if ( Masks[i] == NULL )
         return( Masks[i] = New );

   i = Max_Masks + 8;
   Tab = (RGB_MASK **)My_Realloc( Masks, i*sizeof( RGB_MASK * ) );
   if ( Tab==NULL ) {
      Nb_Masks--;
      M_Free( New );
      return( NULL );
   }
   Masks = Tab;
   Masks[Max_Masks] = New;
   Max_Masks = i;
   for( i=Nb_Masks; i<Max_Masks; ++i ) Masks[i] = NULL;

   return( New );
}

EXTERN void Dispose_Mask( RGB_MASK *Mask )
{
   INT i;

   if ( Mask == NULL ) return;
   if ( Mask->Type != RGB_MASK_TYPE )
   {
      M_Free( Mask );
      return;
   }

   for( i=0; i<Max_Masks; ++i )
      if ( Masks[i] == Mask ) goto Ok;
   Exit_Upon_Error( "Dispose_mask() failed" );

Ok:
   if (--Masks[i]->Users ) return;
   M_Free( Masks[i] );
   Nb_Masks--;
   if ( !(Nb_Masks&0x08) ) Clean_Up_Masks( );
}

EXTERN void Clean_Up_Masks( )
{
   INT i, j;
   RGB_MASK **Tab;

   if ( Max_Masks == 0 ) return;
   if ( Nb_Masks == 0 )
   {
      M_Free( Masks );
      Masks = NULL;
      Max_Masks = 0;
      return;
   }

   Tab = New_Object( Nb_Masks, RGB_MASK * );
   if ( Tab == NULL ) return;
   j = 0;
   for( i=0; i<Max_Masks; ++i )
   {
      if ( Masks[i]==NULL ) continue;
      Tab[j++] = Masks[i];
   }
   Max_Masks = Nb_Masks;
   M_Free( Masks );
   Masks = Tab;   
}

/*******************************************************************/

EXTERN UINT Packed_Field_Pos( FORMAT Format )
{
   UINT F_Pos;

   F_Pos = Format_F_Pos(Format);
   if ( F_Pos != POS_PACKED ) return( F_Pos );
   if ( (Format&0x0FFF) == 0x000 ) return( F_Pos );  /* RGB_CMAP */

   F_Pos = 0x000;  /* no gap between color bits */

   return( F_Pos<<16 );    /* no FMT_REVERSED_BIT... */
}

EXTERN void Format_Mask_And_Shift( FORMAT Format, UINT Mask[], UINT Shift[] )
{
      /* decode Format into usable masks and shifts...*/

   INT i;
   UINT Field_Pos;
   INT Reversed, Total_Bits; 

   Field_Pos = Format_F_Pos( Format );
   if ( Field_Pos == POS_PACKED ) Field_Pos = Packed_Field_Pos( Format )>>16;

   Reversed = Format & FMT_REVERSED_BIT;
   Total_Bits = 0;

   i = ( Format & 0x000F ); Mask[ BLUE_F ] = Bit_Masks[ i ];
   i += ( Field_Pos & 0x000F ); Shift[ BLUE_F ] = i;
   Total_Bits += i;

   i = ( Format & 0x00F0 )>>4; Mask[ GREEN_F ] = Bit_Masks[ i ];
   i += ( Field_Pos & 0x00F0 )>>8; Shift[ GREEN_F ] = i + Total_Bits;
   Total_Bits += i;

   i = ( Format & 0x0F00 )>>8; Mask[ RED_F ] = Bit_Masks[ i ];
   i += ( Field_Pos & 0x0F00 )>>16; Shift[ RED_F ] = i + Total_Bits;
   Total_Bits += i;   

/*
   i = ( Format & 0xF000 )>>12; Mask[ ALPHA_F ] = Bit_Masks[ i ];
   i += ( Field_Pos & 0xF000 )>>24; Shift[ ALPHA_F ] = i;
*/
      /* TODO: Fix that! */
   Mask[ ALPHA_F ] = 0x00;
   Shift[ ALPHA_F ] = 0;;

   if ( Reversed )
   {
      Shift[BLUE_F] = Total_Bits-Shift[BLUE_F];
      Shift[GREEN_F] = Total_Bits-Shift[GREEN_F];
      Shift[RED_F] = Total_Bits-Shift[RED_F];
   }
}

EXTERN void Build_RGB_Convertion_Mask( FORMAT In, FORMAT Out, UINT *Tab )
{
   UINT C, i, In_Depth, Out_Depth;
   UINT In_Mask[4], In_Shift[4];
   UINT Out_Mask[4], Out_Shift[4];
   UINT Shift_R, Shift_G1, Shift_G2, Shift_B;

   bzero( Tab, 256*4 );

   In_Depth = Format_Depth( In );
   Out_Depth = Format_Depth( Out );

   Format_Mask_And_Shift( In, In_Mask, In_Shift );
   Format_Mask_And_Shift( Out, Out_Mask, Out_Shift );

      /* RGB colors are mapped with four planes of 32bits final color:
       * Tab[i] for Red bits.
       * Tab[256+i] for upper green bits.
       * Tab[512+i] for lower green bits (if needed)
       * Tab[768+i] for blue bits.
       * This could be split or re-ordered to minimize cache misses
       * while converting...
       */

   if ( In_Depth == 1 )
   {
      Shift_R = Shift_G1 = Shift_B = 8;
      Shift_G2 = 0;
   }
   else if ( In_Depth == 2 )
   {
      Shift_R = Shift_G1 = 16;
      Shift_G2 = 8;
      Shift_B = 8;
   }
   else if ( In_Depth == 3 || In_Depth == 4 )
   {
      Shift_R = 24;
      Shift_G1 = 16;
      Shift_G2 = 0;
      Shift_B = 8;
   }
   /* else ... */

   for( i=0; i<256; ++i )
   {
      C = (i<<Shift_R)>>In_Shift[RED_F];
      Tab[i] = ( ( C & Out_Mask[RED_F] )<<Out_Shift[RED_F] )>>COL_BITS_FIX;

      C = (i<<Shift_G1)>>In_Shift[GREEN_F];
      Tab[256+i] = ( ( C & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F] )>>COL_BITS_FIX;

      if ( Shift_G2 )
      {
         C = (i<<Shift_G2)>>In_Shift[GREEN_F];
         Tab[512+i] = ( ( C & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F] )>>COL_BITS_FIX;
      }
      else Tab[512+i] = 0;

      C = (i<<Shift_B)>>In_Shift[BLUE_F];
      Tab[768+i] = ( ( C & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F] )>>COL_BITS_FIX;
   }
}

/*******************************************************************/

EXTERN void Drv_Store_Formatted_CMap(
   UINT *Dst, COLOR_ENTRY *CMap, INT Nb, FORMAT Format )
{
   UINT Out_Mask[4], Out_Shift[4];
   INT i;

   Format_Mask_And_Shift( Format, Out_Mask, Out_Shift );

   for( i=0; i<Nb; ++i )
   {
      UINT Col;
      Col  = ( CMap[i][RED_F] & Out_Mask[RED_F] )<<Out_Shift[RED_F];
      Col |= ( CMap[i][GREEN_F] & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F];
      Col |= ( CMap[i][BLUE_F] & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F];
      Dst[ CMap[i][INDEX_F] ] = Col>>COL_BITS_FIX;
   }
}

EXTERN void Drv_Store_CMap( COLOR_ENTRY *Dst, COLOR_ENTRY *Src, INT Nb )
{
   for( Nb--; Nb>=0; Nb-- )
   {
      INT j;
      j = Src[Nb][INDEX_F];
      Dst[j][RED_F] = Src[Nb][RED_F];
      Dst[j][GREEN_F] = Src[Nb][GREEN_F];
      Dst[j][BLUE_F] = Src[Nb][BLUE_F];
      Dst[j][INDEX_F] = j;
   }
}

EXTERN void Drv_Match_CMaps( COLOR_ENTRY *Src, COLOR_ENTRY *Dst, INT Nb )
{
   for( Nb--; Nb>=0; Nb-- )
   {
      PIXEL R, G, B;
      INT j;
      R = Src[Nb][RED_F];
      G = Src[Nb][GREEN_F];
      B = Src[Nb][BLUE_F];
      j = Drv_Best_Match_RGB( R, G, B, Dst, 256 );
      Src[Nb][INDEX_F] = j;
   }
}

/*******************************************************************/

EXTERN COLOR_CMAP *New_Color_Matcher( )
{
   COLOR_CMAP *Mask;

   Mask = New_Object( 1, COLOR_CMAP );
   if ( Mask==NULL ) return( NULL );
   Mem_Clear( Mask );
   Mask->Type = COLOR_CMAP_TYPE;
   Mask->Col_Convert = NULL;
   Mask->Stamp = 0;
   Mask->Dst_Stamp = NULL;
   return( Mask );
}

EXTERN COLOR_INDEXER *New_Color_Indexer( FORMAT Out )
{
   COLOR_INDEXER *Mask;

   Mask = New_Object( 1, COLOR_INDEXER );
   if ( Mask==NULL ) return( NULL );
   Mem_Clear( Mask );
   Mask->Type = INDEXER_TYPE;
   Mask->Col_Convert = Indexer_Tab[Format_Depth(Out)-1];
   Mask->Out = Out;
   Mask->Stamp = 0;
   return( Mask );
}

EXTERN COLOR_DITHERER *New_Color_Ditherer( MEM_ZONE *Src )
{
   INT i;
   COLOR_DITHERER *Mask;
   COLOR_ENTRY *Mask_Src;
   UINT *Fmt;
   RGB_MASK Dummy;

   Mask = New_Object( 1, COLOR_DITHERER );
   if ( Mask==NULL ) return( NULL );
   Mem_Clear( Mask );
   Mask->Type = DITHERER_TYPE;
   Mask->Col_Convert = Ditherer_Tab[MEM_Quantum(Src)-1];
   Mask->Stamp = 0;
   Mask->Dst_Stamp = NULL;

   Fmt = (UINT *)&Dummy.Masks;
   Build_RGB_Convertion_Mask( MEM_Format(Src), FMT_332, Fmt );

   Mask_Src = (COLOR_ENTRY *)Mask->Cols;
   for( i=0; i<256; ++i )
   {
      Mask->Cols[i][0] = Fmt[i] & 0xFF;
      Mask->Cols[i][1] = Fmt[i+256] & 0xFF;
      Mask->Cols[i][2] = Fmt[i+512] & 0xFF;
      Mask->Cols[i][3] = Fmt[i+768] & 0xFF;
      Mask->Match[i][RED_F] = (i&0xe0);
      Mask->Match[i][GREEN_F] = (i&0x1C)<<3;
      Mask->Match[i][BLUE_F] = (i&0x03)<<6;
      Mask->Match[i][INDEX_F] = i;  /* To be best-matched later */
   }
   return( Mask );
}

/*******************************************************************/

EXTERN MEM_ZONE *Drv_Install_Converter( MEM_ZONE *M )
{
   UINT *Dst_Stamp;
   if ( M->Dst == NULL ) return( NULL );

   if ( (M->Dst->CMapper.Dummy!=NULL) && (M->Dst->CMapper.Dummy->Type!=RGB_MASK_TYPE) )
      Dst_Stamp = &M->Dst->CMapper.Dummy->Stamp;   /* Warning !!! Beware of the union fields !! */
   else Dst_Stamp = NULL;

   if ( Format_Depth( MEM_Format( M ) ) == 1 )
   {
      Install_Index_To_Any( (MEM_ZONE *)M, MEM_Format( M->Dst ), Dst_Stamp );
   }
   else Install_RGB_To_Any( (MEM_ZONE *)M, MEM_Format( M->Dst ), Dst_Stamp );

   return( M );
}

EXTERN MEM_ZONE *Install_Index_To_Any( MEM_ZONE *M, FORMAT Dst, UINT *Dst_Stamp )
{
   COLOR_ENTRY Col_Tab[256];

   if ( Dst==0xFFFFFFFF )  /* only CMap storing ( display ) */
   {         
      M->CMapper.Matcher = New_Color_Matcher( );
      if ( M->CMapper.Matcher == NULL ) return( NULL );
      M->CMapper.Matcher->Dst_Stamp = Dst_Stamp;
   }
   else if ( (Dst&0x1FFF) == FMT_CMAP )
   {
            /* Index to Index */
      M->CMapper.Matcher = New_Color_Matcher( );
      if ( M->CMapper.Matcher == NULL ) return( NULL );
      M->CMapper.Matcher->Dst_Stamp = Dst_Stamp;
   }
   else
   {        /* Index => RGB */
      M->CMapper.Indexer = New_Color_Indexer( Dst );
      if ( M->CMapper.Indexer==NULL ) return( NULL );
   }
   M->Type |= MEM_OWNS_CMAPPER;

   return( M );
}

EXTERN MEM_ZONE *Install_RGB_To_Any( MEM_ZONE *M, FORMAT Fmt_Dst, UINT *Dst_Stamp )
{
   COLOR_ENTRY Col_Tab[256];

   if ( (Fmt_Dst&0x1FFF) == FMT_CMAP )
   {
      Out_Message( "Warning: target format is FMT_CMAP. Maybe you meant FMT_332 !!" );
      M->CMapper.Ditherer = New_Color_Ditherer( M );      
      if ( M->CMapper.Ditherer == NULL ) return( NULL );
      M->CMapper.Ditherer->Dst_Stamp = Dst_Stamp;
   }
   else if ( Fmt_Dst!=0xFFFFFFFF )
   {
      M->CMapper.Mask = New_Masks( MEM_Format(M), Fmt_Dst );
      if ( M->CMapper.Mask == NULL ) return( NULL );
      if ( Format_Depth( Fmt_Dst )==1 && (M->Type & MEM_IS_DISPLAY ) )
      {
            /* ~FMT_332 */
         Drv_Build_RGB_Cube( Col_Tab, Fmt_Dst );
         (*((MEM_ZONE_DRIVER *)M)->Driver->Change_Colors)( (MEM_ZONE_DRIVER *)M, 256, Col_Tab );
      }
   }
   M->Type |= MEM_OWNS_CMAPPER;

   return( M );
}

EXTERN void Clear_CMapper( MEM_ZONE *M )
{
   if ( M->CMapper.Dummy == NULL ) goto Ok;
   if ( M->Type & MEM_OWNS_CMAPPER )
   {
      if ( M->CMapper.Dummy->Type == RGB_MASK_TYPE )
         Dispose_Mask( M->CMapper.Mask );
      else { M_Free( M->CMapper.Dummy ); };
   }
   else M->CMapper.Dummy = NULL;
Ok:
   M->Type &= ~MEM_OWNS_CMAPPER;
}

/*******************************************************************/

