/***************************************************************************
****************************************************************************
****************************************************************************
*
* Centurion - By Jason Nunn - Sept 96
* FREEWARE. Authorship Reserved 1996
*
* Xwindows Demo (C++)  i haven't written a C++ in a very loong time
*
* Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia
*
* ==================================================================
*  Real 2 SuperReal 3D mapper
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <X11/Xlib.h>

#define COLOUR_ARRAY 8
#define COLOUR_NO    2

struct tvector
{
  double x;
  double y;
  double z;
};

struct tfacet_ll
{
  int          no_points;
  unsigned int colour;
  tvector      *src_list;
  tvector      mean;
  tvector      normal_mean;
  unsigned int dp_colour;
  XPoint       *prj_list;
  tfacet_ll    *next;
};

struct tsort_facet
{
  tfacet_ll *node;
  int       Z_average;
};

class t3d
{
public:
  long          scale;
  long          x_pos;
  long          y_pos;
  int           no_facets;
  tfacet_ll     facet_ll_root;
  tvector       vangles;
  tvector       n_lightsource;
  tsort_facet   *sort_facet;
  tvector       vrotated;
  unsigned long *colours[COLOUR_NO];

  tvector normalise(tvector *V);
  inline double dotproduct(tvector *a,tvector *b);
  void t3d::rotate(tvector *S);
  void t3d::project(XPoint *D);
  void t3d::set_lightsource(double x,double y,double z);
  void t3d::calc_normals(void);
  t3d(void);
  void clear_ll(tfacet_ll *entry);
  void delloc_facet_ll(tfacet_ll *entry);
  int load(char *filename);
  ~t3d(void);
  unsigned short calc_colour(void);
  void map(void);
  void draw(void);
private:
};
