/***************************************************************************
****************************************************************************
****************************************************************************
*
* Centurion - By Jason Nunn - Sept 96
* FREEWARE. Authorship Reserved 1996
*
* Xwindows Demo (C++)  i haven't written a C++ in a very loong time
*
* Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia
*
* ==================================================================
*  Real 2 SuperReal 3D mapper
*
*	Z
*	|
*	|
*	|
*	|
*	|______ X
*       /
*      /
*     /
*    Y
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <math.h>
#include "cent_3d.h"

extern Display     *display;
extern Pixmap      render_screen;
extern GC          gc_3d;

/***************************************************************************
*
***************************************************************************/
tvector t3d::normalise(tvector *V)
{
  tvector T;
  register double l =
    sqrt((V->x * V->x) + (V->y * V->y) + (V->z * V->z));
  T.x = V->x / l;
  T.y = V->y / l;
  T.z = V->z / l;

  return T;
}

inline double t3d::dotproduct(tvector *a,tvector *b)
{
  return (a->x * b->x) + (a->y * b->y) + (a->z * b->z);
}

void t3d::rotate(tvector *S)
{
  register double Xt,Yt,Zt;

  Yt = (S->y * cos(vangles.x)) - (S->z * sin(vangles.x));
  Zt = (S->y * sin(vangles.x)) + (S->z * cos(vangles.x));
  Xt = (S->x * cos(vangles.y)) - (Zt * sin(vangles.y));
  vrotated.z = (S->x * sin(vangles.y)) + (Zt * cos(vangles.y));
  vrotated.x = (Xt * cos(vangles.z)) - (Yt * sin(vangles.z));
  vrotated.y = (Xt * sin(vangles.z)) + (Yt * cos(vangles.z));
}

void t3d::project(XPoint *D)
{
  register double fx,fy,fz;

  fx = vrotated.x + vpoint.x;
  fy = vrotated.y + vpoint.y;
  fz = vrotated.z + vpoint.z;
  if(fy != 0)
  {
    D->x = (short)(((fx * 256) / fy) + x_pos);
    D->y = (short)(((fz * 256) / fy) + y_pos);
  }
  else
  {
    D->x = (short)(fx + x_pos);
    D->y = (short)(fz + y_pos);
  }
}

void t3d::set_lightsource(double x,double y,double z)
{
  tvector ls;

  ls.x = x;
  ls.y = y;
  ls.z = z;
  n_lightsource = normalise(&ls);
}

void t3d::calc_normals(void)
{
  tfacet_ll *curr_facet = &facet_ll_root;
  register int x;

  for(x = 0;x < no_facets;x++)
  {
    register int p;

    curr_facet->mean.x = 0;
    curr_facet->mean.y = 0;
    curr_facet->mean.z = 0;
    curr_facet->normal_mean.x = 0;
    curr_facet->normal_mean.y = 0;
    curr_facet->normal_mean.z = 0;
    for(p = 0;p < curr_facet->no_points;p++)
    {
      tvector t;

      curr_facet->mean.x =+ (curr_facet->src_list + p)->x;
      curr_facet->mean.y =+ (curr_facet->src_list + p)->y;
      curr_facet->mean.z =+ (curr_facet->src_list + p)->z;
      t = normalise((curr_facet->src_list + p));
      curr_facet->normal_mean.x += t.x;
      curr_facet->normal_mean.y += t.y;
      curr_facet->normal_mean.z += t.z;
    }
    curr_facet->mean.x /= curr_facet->no_points;
    curr_facet->mean.y /= curr_facet->no_points;
    curr_facet->mean.z /= curr_facet->no_points;
    curr_facet->normal_mean.x /= curr_facet->no_points;
    curr_facet->normal_mean.y /= curr_facet->no_points;
    curr_facet->normal_mean.z /= curr_facet->no_points;

    curr_facet = curr_facet->next;
  }
  set_lightsource(0,-100,0);
}

/***************************************************************************
*
***************************************************************************/
t3d::t3d(void)
{
/* do SFA*/
}

void t3d::clear_ll(tfacet_ll *entry)
{
  entry->no_points = 0;
  entry->src_list = NULL;
  entry->prj_list = NULL;
  entry->next = NULL;
}

void t3d::delloc_facet_ll(tfacet_ll *entry)
{
  if(entry->src_list != NULL) free(entry->src_list);
  if(entry->prj_list != NULL) free(entry->prj_list);
  if(entry->next != NULL) delloc_facet_ll(entry->next);
  if(entry != &facet_ll_root) free(entry);
}

int t3d::load(char *filename)
{
  fstream *fo;
  tfacet_ll *curr_facet = &facet_ll_root;
  char *err_mess1 = "Error: Allocating memory (t3d::t3d)\n";

  x_pos = 0;
  y_pos = 0;
  no_facets = 0;
  clear_ll(curr_facet);
  vangles.x = 0;
  vangles.y = 0;
  vangles.z = 0;
  vpoint.x = 0;
  vpoint.y = 0;
  vpoint.z = 0;
  if((fo = new fstream(filename,_IO_INPUT,0664)) == NULL)
  {
    cout << "Error: Couldn't open " << filename << ".\n";
    return -1;
  }
  while(!fo->eof())
  {
    char Str[80];
    register int p;

    *fo >> Str;
    if(!strcmp(Str,"dot"))
      curr_facet->no_points = 1;
    else
      if(!strcmp(Str,"rec"))
        curr_facet->no_points = 4;
      else
        break;
    if((curr_facet->src_list =
      (tvector *)malloc(sizeof(tvector) * curr_facet->no_points)) == NULL)
    {
      cout << err_mess1;
      delloc_facet_ll(&facet_ll_root);
      return 0;
    }
    if((curr_facet->prj_list =
      (XPoint *)malloc(sizeof(XPoint) * curr_facet->no_points)) == NULL)
    {
      cout << err_mess1;
      delloc_facet_ll(&facet_ll_root);
      return 0;
    }
    *fo >> curr_facet->colour;
    for(p = 0;p < curr_facet->no_points;p++)
    {
      *fo >> (curr_facet->src_list + p)->x
          >> (curr_facet->src_list + p)->y
          >> (curr_facet->src_list + p)->z;
    }
    no_facets++;
    if((curr_facet->next = (tfacet_ll *)malloc(sizeof(tfacet_ll))) == NULL)
    {
      cout << err_mess1;
      delloc_facet_ll(&facet_ll_root);
      return 0;
    }
    curr_facet = curr_facet->next;
    clear_ll(curr_facet);
  }
  fo->close();
  delete fo;

  if((sort_facet = (tsort_facet *)malloc(sizeof(tsort_facet) * no_facets))
    == NULL)
  {
    cout << err_mess1;
    delloc_facet_ll(&facet_ll_root);
    return 0;
  }
  calc_normals();
  return 1;
}

t3d::~t3d(void)
{
  delloc_facet_ll(&facet_ll_root);
  free(sort_facet);
}

/***************************************************************************
*
***************************************************************************/
unsigned short t3d::calc_colour(void)
{
  register double dp = dotproduct(&vrotated,&n_lightsource) * COLOUR_ARRAY;
  if(dp < 0) dp = 0;
  if(dp > (COLOUR_ARRAY - 1)) dp = (COLOUR_ARRAY - 1);
  return (unsigned int)dp;
}

int compar(const void *entry1,const void *entry2)
{
  return ((tsort_facet *)entry2)->Z_average -
         ((tsort_facet *)entry1)->Z_average;
}

void t3d::map(void)
{
  tfacet_ll *curr_facet = &facet_ll_root;
  register int x;

  for(x = 0;x < no_facets;x++)
  {
    register int p;

    rotate(&(curr_facet->mean));
    (sort_facet + x)->Z_average = (int)vrotated.y << 3;
    if(vrotated.y > (vpoint.y + 5))
    {
      (sort_facet + x)->node = curr_facet;
      for(p = 0;p < curr_facet->no_points;p++)
      {
        rotate((curr_facet->src_list + p));
        project((curr_facet->prj_list + p));
      }
      rotate(&(curr_facet->normal_mean));
      curr_facet->dp_colour = calc_colour();
    }
    else
      (sort_facet + x)->node = NULL;
    curr_facet = curr_facet->next;
  }
  qsort(sort_facet,no_facets,sizeof(tsort_facet),compar);
}

void t3d::draw(void)
{
  register int x;

  for(x = 0;x < no_facets;x++)
  {
    tfacet_ll *curr_facet = (sort_facet + x)->node;
    if(curr_facet != NULL)
    {
      XSetForeground(display,gc_3d,
        *(colours[curr_facet->colour] + curr_facet->dp_colour));
      switch(curr_facet->no_points)
      {
        case 1:
          XDrawPoint(display,render_screen,gc_3d,
            curr_facet->prj_list->x,curr_facet->prj_list->y);
          break;
        case 4:
          XFillPolygon(display,render_screen,gc_3d,
            curr_facet->prj_list,curr_facet->no_points,
            Convex,CoordModeOrigin);
          break;
      }
    }
  }
}
