/***************************************************************************
****************************************************************************
****************************************************************************
*
* Centurion - By Jason Nunn - Sept 96
* FREEWARE. Authorship Reserved 1996
*
* A simple 3D editor (C++)
*
* Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia
*
* ==================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <curses.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <sys/types.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "cent_3d.h"

#define UPDATE_DELAY 100000

char        *host = NULL;
Display     *display;
Window      window,root,parent;
int         depth,screen,visibility;
GC          gc_general,gc_3d;
Pixmap      render_screen;

int window_width  = 400;
int window_height = 300;
int window_x_pos  = 100;
int window_y_pos  = 100;

int end_editor = 0;
int ch;
int menu_option = 0;

double skew_inc = 0.05;
long scale_inc = 1;
char in_str[80];

unsigned long colour1[COLOUR_ARRAY];
unsigned long colour2[COLOUR_ARRAY];
t3d *o3d;

/***************************************************************************
*
***************************************************************************/
void display_topbar(void)
{
  clear();
  move(0,0);
  attron(A_REVERSE);
  addstr(" Centurion Demo Editor (Warning: This editor is a HACK)"
         "           by Jason Nunn ");
}

void update_screen(void)
{
  attroff(A_REVERSE);
  move(0,0);
  refresh();
}

void hl_bar(char option,char x)
{
  if(option == x)
    attron(A_REVERSE);
  else
    attroff(A_REVERSE);
}

void clear_area(char y1,char x1,char y2,char x2)
{
  register char a;
  for(y1 = y1;y1 <= y2;y1++)
    for(a = x1;a <= x2;a++)
    {
      move(y1,a);
      addch(' ');
    }
}

void get_str(void)
{
  move(23,2);
  addstr("enter: ");
  update_screen();
  echo();
  move(23,9);
  getstr(in_str);
  noecho();
  clear_area(23,2,23,20);
  update_screen();
}

/***************************************************************************
*
***************************************************************************/
void ramp_colour(
  unsigned short r1,unsigned short g1,unsigned short b1,
  unsigned short r2,unsigned short g2,unsigned short b2,
  unsigned long *base)
{
  register int x;
  XColor       C;
  double       rs,gs,bs;
  Colormap     DefaultCMap;

  DefaultCMap = DefaultColormap(display,screen);
  rs = (r2 - r1) / COLOUR_ARRAY;
  gs = (g2 - g1) / COLOUR_ARRAY;
  bs = (b2 - b1) / COLOUR_ARRAY;
  C.flags = DoRed | DoGreen | DoBlue;
  for(x = 0;x < COLOUR_ARRAY;x++)
  {
    C.red = r1 + (unsigned short)(x * rs);
    C.green = g1 + (unsigned short)(x * gs);
    C.blue = b1 + (unsigned short)(x * bs);
    XAllocColor(display,DefaultCMap,&C);
    *(base + x) = C.pixel;
  }
}

/***************************************************************************
*
***************************************************************************/
int x_init(void)
{
  char         *wname = "Centurion Editor";
  XWMHints     xwmhints;
  XVisualInfo  visual_info;

  if((host = (char *)getenv("DISPLAY")) == NULL)
  {
    printf("Error: No environment variable DISPLAY\n");
    return -1;
  }
  if((display = XOpenDisplay(host)) == NULL) 
  {
    printf("Error: Could not connect to Xserver.\n");
    return -1;
  }
  screen = DefaultScreen(display);
  root = parent = RootWindow(display,screen);
  depth = DefaultDepth(display,screen);
  if(!XMatchVisualInfo(display,screen, 
    DefaultDepth(display,screen),PseudoColor,&visual_info))
    if(!XMatchVisualInfo(display,screen, 
      DefaultDepth(display,screen),DirectColor,&visual_info))
      if(!XMatchVisualInfo(display,screen, 
        DefaultDepth(display,screen),TrueColor,&visual_info))
        {
          printf("Error: Colour display not found.\n");
          return -1;
        }
  window = XCreateSimpleWindow(
    display,root,
    window_x_pos,window_y_pos,
    window_width,window_height,
    1,0,0);
  XSelectInput(display,window,
               ButtonPressMask | KeyPressMask | ExposureMask |
               VisibilityChangeMask | FocusChangeMask);
  XChangeProperty(
    display,window,XA_WM_NAME,XA_STRING,8,
    PropModeReplace,(unsigned char *)wname,strlen(wname));
  xwmhints.initial_state = NormalState;
  xwmhints.flags = IconPixmapHint | StateHint;
  XSetWMHints(display,window,&xwmhints);
  render_screen =
    XCreatePixmap(display,window,window_width,window_height,depth);
  gc_3d = XCreateGC(display,window,0,NULL);
  gc_general = XCreateGC(display,window,0,NULL);
  XFillRectangle(display,render_screen,gc_general,
    0,0,window_width,window_height);

  return 1;
}

/***************************************************************************
*
***************************************************************************/
int load_stuff(void)
{
  o3d = new t3d;
  if(o3d == NULL) return 0;
  if(!o3d->load("./data/space.3d")) return 0;
  o3d->x_pos = window_width >> 1;
  o3d->y_pos = window_height >> 1;
  o3d->colours[0] = (unsigned long *)&colour1;
  o3d->colours[1] = (unsigned long *)&colour2;

/*set 3d colours*/
  ramp_colour(0x7000,0,0,
              0xf000,0,0,
              (unsigned long *)&colour1);
  ramp_colour(0,0x7000,0,
              0,0xf000,0,
              (unsigned long *)&colour2);

  return 1;
}

void Xreaper(void)
{
  if(o3d != NULL) delete o3d;
  XFreeGC(display,gc_3d);
  XFreeGC(display,gc_general);
  XCloseDisplay(display);
}

/***************************************************************************
*
***************************************************************************/
void paint_all(void)
{
  XFillRectangle(display,render_screen,gc_general,
    0,0,window_width,window_height);
  o3d->map();
  o3d->draw();
  XCopyArea(display,render_screen,window,gc_general,0,0,
    window_width,window_height,0,0);
}

/***************************************************************************
*
***************************************************************************/
void check_event(void)
{
  XEvent event;

  while(XPending(display))
  {
    XNextEvent(display,&event);
    switch(event.type) 
    {
      case ButtonPress:
      case KeyPress:
        break;
      case ReparentNotify:
        if(event.xreparent.window != window) break;
        XSelectInput(display,event.xreparent.parent,StructureNotifyMask);
        XSelectInput(display,parent,0);
        parent = event.xreparent.parent;
        break;
      default:
        break;
    }
  }
}

/***************************************************************************
*
***************************************************************************/
void main_menu(void)
{
  hl_bar(menu_option,0);
  move(3,2);
  addstr("     FILE      ");
  hl_bar(menu_option,1);
  move(4,2);
  addstr("     QUIT      ");
  hl_bar(menu_option,2);
  move(5,2);
  sprintf(in_str," SHEW %f",skew_inc);
  addstr(in_str);
  hl_bar(menu_option,3);
  move(6,2);
  sprintf(in_str," SCLE %d",(int)scale_inc);
  addstr(in_str);
}

void main_loop(void)
{
  display_topbar();
  main_menu();
  update_screen();
  paint_all();

  while(!end_editor)
  {
    float tmp;

    ch = getch();
    switch(ch)
    {
      case KEY_UP:
        if(menu_option > 0) menu_option--;
        main_menu();
        update_screen();
        break;
      case KEY_DOWN:
        if(menu_option < 3) menu_option++;
        main_menu();
        update_screen();
        break;
      case KEY_LEFT:
        break;
      case KEY_RIGHT:
        break;
      case 10:
        switch(menu_option)
        {
          case 0:
            break;
          case 1:
            end_editor = 1;
            break;
          case 2:
            get_str();
            sscanf(in_str,"%f",&tmp);
            skew_inc = (double)tmp;
            main_menu();
            update_screen();
            break;
          case 3:
            get_str();
            sscanf(in_str,"%d",(int *)&scale_inc);
            main_menu();
            update_screen();
            break;
        }
        break;
      case 'i':
        (o3d->vangles.x) -= skew_inc;
        paint_all();
        break;
      case 'm':
        (o3d->vangles.x) += skew_inc;
        paint_all();
        break;
      case 'j':
        (o3d->vangles.z) += skew_inc;
        paint_all();
        break;
      case 'k':
        (o3d->vangles.z) -= skew_inc;
        paint_all();
        break;
      case 'u':
        (o3d->vangles.y) -= skew_inc;
        paint_all();
        break;
      case 'o':
        (o3d->vangles.y) += skew_inc;
        paint_all();
        break;
      case '-':
//        (o3d->vpoint.x) -= (o3d->vangles.x) * scale_inc;
//        (o3d->vpoint.y) -= (o3d->vangles.y) * scale_inc;
//        (o3d->vpoint.z) -= (o3d->vangles.z) * scale_inc;
        paint_all();
        break;
      case '=':
//        (o3d->vpoint.x) += (o3d->vangles.x) * scale_inc;
//        (o3d->vpoint.y) += (o3d->vangles.y) * scale_inc;
//        (o3d->vpoint.z) += (o3d->vangles.z) * scale_inc;
        paint_all();
        break;
    }
  }
}

/***************************************************************************
*
***************************************************************************/
int main(void)
{
  printf("Welcome to the Centurion Editor, Xwindows Demo - By Jason Nunn - (A)1996\n");
  if(x_init())
  {
    printf("Loading Data..\n");
    if(!load_stuff())
    {
      printf("Error: Loading Data. Aborting Editor.\n");
      Xreaper();
      return -1;
    }
    XMapWindow(display,window);
    XSync(display,0);

    initscr();
    cbreak();
    noecho();
    keypad(stdscr,TRUE);
    main_loop();
    clear();
    refresh();
    resetterm();
    echo();
    endwin();
    Xreaper();
  }

  return 1;
}
