/***************************************************************************
****************************************************************************
****************************************************************************
*
* Centurion - By Jason Nunn - Sept 96
* FREEWARE. Authorship Reserved 1996
*
* Xwindows Demo (C++)  i haven't written a C++ in a very loong time
*
* Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia
*
* ==================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <math.h>
#include <sys/types.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>
#include "icon_bm.h"
#include "3d.h"

#define UPDATE_DELAY 100000
#define REALTIME_DELAY 50000
#define SCROLL_FONT "-adobe-new century schoolbook-bold-i-normal-*-24-*-100-100-p-154-*-*"

char        *host = NULL;
Display     *display;
Window      window,root,parent;
int         depth,screen,visibility;
GC          gc_general,gc_bltblt,gc_3d,gc_font;
Pixmap      render_screen;
XFontStruct *scroll_font = NULL;

int window_width  = 400;
int window_height = 300;
int window_x_pos  = 100;
int window_y_pos  = 100;

typedef struct
{
  Pixmap       pixmap;
  Pixmap       mask;
  unsigned int width;
  unsigned int height;
} tbm;

int          end_demo = 0;
tbm          bm_cent_logo;
tbm          bm_jsno_b;
tbm          bm_jsno_y;
tbm          bm_jsno_j;
tbm          bm_jsno_s;
tbm          bm_jsno_n;
tbm          bm_jsno_o;

char *scroll_text =
  "Greetings. Welcome to my little demo in Xwindows programming for"
  " Linux/Unix. I did it to learn X11/Xlib. Very easy in C++ compared"
  " with the old style 386 protected mode assembly code. No sound tho "
  ";(..Hellos go to Snowman,Trixter,Pallbearer,DickyDick,The REW...";
int scroll_text_x = 700;

unsigned long colour1[COLOUR_ARRAY];
unsigned long colour2[COLOUR_ARRAY];

t3d *o3d;

/***************************************************************************
*
***************************************************************************/
void ramp_colour(
  unsigned short r1,unsigned short g1,unsigned short b1,
  unsigned short r2,unsigned short g2,unsigned short b2,
  unsigned long *base)
{
  register int x;
  XColor       C;
  double       rs,gs,bs;
  Colormap     DefaultCMap;

  DefaultCMap = DefaultColormap(display,screen);
  rs = (r2 - r1) / COLOUR_ARRAY;
  gs = (g2 - g1) / COLOUR_ARRAY;
  bs = (b2 - b1) / COLOUR_ARRAY;
  C.flags = DoRed | DoGreen | DoBlue;
  for(x = 0;x < COLOUR_ARRAY;x++)
  {
    C.red = r1 + (unsigned short)(x * rs);
    C.green = g1 + (unsigned short)(x * gs);
    C.blue = b1 + (unsigned short)(x * bs);
    XAllocColor(display,DefaultCMap,&C);
    *(base + x) = C.pixel;
  }
}

/***************************************************************************
*
***************************************************************************/
int x_init(void)
{
  char         *wname = "Centurion";
  Pixmap       iconPixmap;
  XWMHints     xwmhints;
  XVisualInfo  visual_info;
  XGCValues    gcv;

  if((host = (char *)getenv("DISPLAY")) == NULL)
  {
    cout << "Error: No environment variable DISPLAY\n";
    return -1;
  }
  if((display = XOpenDisplay(host)) == NULL) 
  {
    cout << "Error: Could not connect to Xserver.\n";
    return -1;
  }
  screen = DefaultScreen(display);
  root = parent = RootWindow(display,screen);
  depth = DefaultDepth(display,screen);
  if(!XMatchVisualInfo(display,screen, 
    DefaultDepth(display,screen),PseudoColor,&visual_info))
    if(!XMatchVisualInfo(display,screen, 
      DefaultDepth(display,screen),DirectColor,&visual_info))
      if(!XMatchVisualInfo(display,screen, 
        DefaultDepth(display,screen),TrueColor,&visual_info))
        {
          cout << "Error: Colour display not found.\n";
          return -1;
        }
  window = XCreateSimpleWindow(
    display,root,
    window_x_pos,window_y_pos,
    window_width,window_height,
    1,0,0);
  XSelectInput(display,window,
               ButtonPressMask | KeyPressMask | ExposureMask |
               VisibilityChangeMask | FocusChangeMask);
  XChangeProperty(
    display,window,XA_WM_NAME,XA_STRING,8,
    PropModeReplace,(unsigned char *)wname,strlen(wname));
  iconPixmap = XCreateBitmapFromData(display,window,
    (char *)icon_bm_bits,icon_bm_width,icon_bm_height);
  xwmhints.icon_pixmap = iconPixmap;
  xwmhints.initial_state = NormalState;
  xwmhints.flags = IconPixmapHint | StateHint;
  XSetWMHints(display,window,&xwmhints);
  render_screen =
    XCreatePixmap(display,window,window_width,window_height,depth);
  gc_general = XCreateGC(display,window,0,NULL);
  gcv.function = GXcopy;
  gcv.fill_style = FillTiled;
  gcv.graphics_exposures = False;
  gc_bltblt = XCreateGC(display,window,
    GCFunction | GCFillStyle | GCGraphicsExposures,&gcv);
  gc_3d = XCreateGC(display,window,0,NULL);
  gc_font = XCreateGC(display,window,0,NULL);

  XFillRectangle(display,render_screen,gc_general,
    0,0,window_width,window_height);
  if(!(scroll_font = XLoadQueryFont(display,SCROLL_FONT)))
  {
    cout << "Cannot open the scroll font. Using default."; 
    scroll_font = XLoadQueryFont(display,"fixed");
  }
  XSetBackground(display,gc_bltblt,None);
  XSetForeground(display,gc_bltblt,None);
  XSetBackground(display,gc_3d,BlackPixel(display,screen));
  XSetForeground(display,gc_3d,WhitePixel(display,screen));
  XSetBackground(display,gc_font,None);
  XSetForeground(display,gc_font,WhitePixel(display,screen));
  XSetFont(display,gc_font,scroll_font->fid);

  return 1;
}

/***************************************************************************
*
***************************************************************************/
int loadxpm(char *filename,tbm *bm)
{
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
  int val;

  XGetWindowAttributes(display,root,&root_attr); 
  xpm_attributes.colormap = root_attr.colormap;
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels | XpmColormap;
  if((val = XpmReadFileToPixmap(display,root,filename,
                                &bm->pixmap,&bm->mask,
                                &xpm_attributes)) != XpmSuccess)
  {
    if(val == XpmOpenFailed)    
      cout << "Couldn't open pixmap file " << filename << "\n";
    else if(val == XpmColorFailed)
      cout << "Couldn't allocated required colours\n";
    else if(val == XpmFileInvalid)
      cout << "Invalid Format for an Xpm File\n";
    else if(val == XpmColorError)
      cout << "Invalid Color specified in Xpm File\n";
    else if(val == XpmNoMemory)
      cout << "Insufficient Memory\n";
    return 0;
  }
  bm->width = xpm_attributes.width;
  bm->height = xpm_attributes.height;
  return 1;
}

void drawxpm(tbm *bm,unsigned int x,unsigned int y)
{
  XSetClipOrigin(display,gc_bltblt,x,y); 
  XSetClipMask(display,gc_bltblt,bm->mask);   
  XCopyArea(display,bm->pixmap,render_screen,gc_bltblt,
    0,0,bm->width,bm->height,x,y);
}

/***************************************************************************
*
***************************************************************************/
int load_stuff(void)
{
  if(!loadxpm("./pixmaps/cent.xpm",&bm_cent_logo)) return 0;
  if(!loadxpm("./pixmaps/jsno_b.xpm",&bm_jsno_b)) return 0;
  if(!loadxpm("./pixmaps/jsno_y.xpm",&bm_jsno_y)) return 0;
  if(!loadxpm("./pixmaps/jsno_j.xpm",&bm_jsno_j)) return 0;
  if(!loadxpm("./pixmaps/jsno_s.xpm",&bm_jsno_s)) return 0;
  if(!loadxpm("./pixmaps/jsno_n.xpm",&bm_jsno_n)) return 0;
  if(!loadxpm("./pixmaps/jsno_o.xpm",&bm_jsno_o)) return 0;

  o3d = new t3d;
  if(o3d == NULL) return 0;
  if(!o3d->load("./3d/space.3d")) return 0;
  o3d->x_pos = window_width >> 1;
  o3d->y_pos = window_height >> 1;
  o3d->scale = 8000;
  o3d->colours[0] = (unsigned long *)&colour1;
  o3d->colours[1] = (unsigned long *)&colour2;

/*set 3d colours*/
  ramp_colour(0x7000,0,0,
              0xf000,0,0,
              (unsigned long *)&colour1);
  ramp_colour(0,0x7000,0,
              0,0xf000,0,
              (unsigned long *)&colour2);

  return 1;
}

void Xreaper(void)
{
  if(bm_cent_logo.pixmap) XFreePixmap(display,bm_cent_logo.pixmap);
  if(bm_jsno_b.pixmap) XFreePixmap(display,bm_jsno_b.pixmap);
  if(bm_jsno_y.pixmap) XFreePixmap(display,bm_jsno_y.pixmap);
  if(bm_jsno_j.pixmap) XFreePixmap(display,bm_jsno_j.pixmap);
  if(bm_jsno_s.pixmap) XFreePixmap(display,bm_jsno_s.pixmap);
  if(bm_jsno_n.pixmap) XFreePixmap(display,bm_jsno_n.pixmap);
  if(bm_jsno_o.pixmap) XFreePixmap(display,bm_jsno_o.pixmap);

  if(bm_cent_logo.mask) XFreePixmap(display,bm_cent_logo.mask);
  if(bm_jsno_b.mask) XFreePixmap(display,bm_jsno_b.mask);
  if(bm_jsno_y.mask) XFreePixmap(display,bm_jsno_y.mask);
  if(bm_jsno_j.mask) XFreePixmap(display,bm_jsno_j.mask);
  if(bm_jsno_s.mask) XFreePixmap(display,bm_jsno_s.mask);
  if(bm_jsno_n.mask) XFreePixmap(display,bm_jsno_n.mask);
  if(bm_jsno_o.mask) XFreePixmap(display,bm_jsno_o.mask);

  if(o3d != NULL) delete o3d;
  XFreeGC(display,gc_general);
  XFreeGC(display,gc_bltblt);
  XFreeGC(display,gc_3d);
  XFreeGC(display,gc_font);

  if(scroll_font) XFreeFont(display,scroll_font);
  XCloseDisplay(display);
}

/***************************************************************************
*
***************************************************************************/
void check_event(void)
{
  XEvent event;

  while(XPending(display))
  {
    XNextEvent(display,&event);
    switch(event.type) 
    {
      case ButtonPress:
      case KeyPress:
        end_demo = 1;
        break;
      case ReparentNotify:
        if(event.xreparent.window != window) break;
        XSelectInput(display,event.xreparent.parent,StructureNotifyMask);
        XSelectInput(display,parent,0);
        parent = event.xreparent.parent;
        break;
      default:
        break;
    }
  }
}

/***************************************************************************
*
***************************************************************************/
double o3d_bg_x = 0,o3d_bg_z = 0;

inline void o3d_demo1_bg(void)
{
  o3d_bg_x += 0.05;
  o3d_bg_z -= 0.05;
}

inline void o3d_demo1_fg(void)
{
  (o3d->vangles.x) = o3d_bg_x;
  (o3d->vangles.z) = o3d_bg_z;
  o3d->map();
  o3d->draw();
}

/***************************************************************************
*
***************************************************************************/
double logo_x = -320,
       logo_xd = 5,
       name_x = 270,
       name_xd = 0.5,
       name_wa = 0;
#define NAME_Y_BUF_MASK 63
unsigned int name_y_buf[NAME_Y_BUF_MASK + 1];
int name_y_buf_ptr = 0,amp = 60,amp_dest = 10,amp_c_c = 0,spd_c_c = 0;
double spd = 0.5,spd_dest = 0.2;

void intro_1_bg(void)
{
  o3d_demo1_bg();

  logo_x += logo_xd;
  if(logo_x > 0)
  {
    logo_xd -= 0.3;
    if(logo_xd < 0) logo_xd = 0;
  }
  name_x -= name_xd;
  if(name_x < -80)
  {
    name_xd -= 0.01;
    if(name_xd < 0) name_xd = 0;
  }
  name_y_buf[name_y_buf_ptr] = (unsigned int)(sin(name_wa) * amp);
  name_y_buf_ptr++;
  name_y_buf_ptr &= NAME_Y_BUF_MASK;
  name_wa += spd;

  if(!(amp_c_c++ & 63))
  {
    switch(random() & 7)
    {
      case 1:
        amp_dest = 60;
        break;
      case 2:
        amp_dest = 10;
        break;
      default:
        amp_dest = 30;
    }
  }
  if(amp > amp_dest) amp--;
  if(amp < amp_dest) amp++;

  if(!(spd_c_c++ & 31))
  {
    switch(random() & 7)
    {
      case 1:
        spd_dest = 0.3;
        break;
      case 2:
        spd_dest = 0.1;
        break;
      default:
        spd_dest = 0.2;
    }
  }
  if(spd > spd_dest) spd -= 0.01;
  if(spd < spd_dest) spd += 0.01;

  scroll_text_x--;
}

void intro_1_fg(void)
{
  while(!end_demo)
  {
    unsigned int x = name_y_buf_ptr - 1;

    check_event();

    XFillRectangle(display,render_screen,gc_general,
      0,0,window_width,window_height);

    o3d_demo1_fg();

    drawxpm(&bm_cent_logo,(unsigned int)logo_x,10);
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_b,162 + (unsigned int)name_x,216 - 80 + name_y_buf[x]);
#define SNBP 6;
    x -= SNBP;
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_y,204 + (unsigned int)name_x,235 - 80 + name_y_buf[x]);
    x -= SNBP;
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_j,270 + (unsigned int)name_x,215 - 80 + name_y_buf[x]);
    x -= SNBP;
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_s,309 + (unsigned int)name_x,233 - 80 + name_y_buf[x]);
    x -= SNBP;
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_n,349 + (unsigned int)name_x,233 - 80 + name_y_buf[x]);
    x -= SNBP;
    x &= NAME_Y_BUF_MASK;
    drawxpm(&bm_jsno_o,393 + (unsigned int)name_x,233 - 80 + name_y_buf[x]);

    XDrawImageString(display,render_screen,gc_font,scroll_text_x,293,
      scroll_text,strlen(scroll_text));

    XCopyArea(display,render_screen,window,gc_general,0,0,
      window_width,window_height,0,0);
    usleep(UPDATE_DELAY);
  }
}

/***************************************************************************
*
***************************************************************************/
void bg_calc(int sig)
{
  signal(sig,&bg_calc);
  intro_1_bg();
}

/***************************************************************************
*
***************************************************************************/
int main(void)
{
  struct itimerval oldtimer,timer;

  cout << "Welcome to Centurion, Xwindows Demo - By Jason Nunn - (A)1996\n";
  if(x_init())
  {
    cout << "Loading Data..\n";
    if(!load_stuff())
    {
      cout << "Error: Loading Data. Aborting Demo.\n";
      Xreaper();
      return -1;
    }
    XMapWindow(display,window);
    XSync(display,0);
    signal(SIGALRM,&bg_calc);
    timer.it_value.tv_sec = 0;
    timer.it_interval.tv_sec = 0;
    timer.it_value.tv_usec = REALTIME_DELAY;
    timer.it_interval.tv_usec = REALTIME_DELAY;
    setitimer(ITIMER_REAL,&timer,&oldtimer);
    cout << "Running demo.\n";
    intro_1_fg();
    setitimer(ITIMER_REAL,&oldtimer,&timer);
    Xreaper();
  }
  return 1;
}
