;-----------------------------;
; source code of GOA 4k intro ;
;  (c) 1998 Exploder/Extreme  ;
;-----------------------------;

	ORG	#6500
A?_MAP		EQU #C000	;LEN=#1300 UB1
T_TXR		EQU #C000	;LEN=#1000 UB1
C?_TXR		EQU #E000	;LEN=#2000 UB2
H?_MAP		EQU #C000	;LEN=#4000 UB3 UB4 UB5

USE_BANK_1	EQU #11
USE_BANK_2	EQU #11
USE_BANK_3	EQU #13
USE_BANK_4	EQU #14
USE_BANK_5	EQU #17

	DI 
	LD	(EXIT+1),SP
	CALL	INSTALL
	CALL	M_INS
	CALL	A?_INSTALL
	CALL	C?_INSTALL
	CALL	H?_INSTALL
	CALL	I?_INSTALL
	EI 
	CALL	K?_INSTALL
;--
	CALL	G_INSTALL		;CREDIT
;--
	CALL	A_INSTALL		;RAYZ		;3
	CALL	M_WAIT
	LD	BC,#0104
	LD	HL,A_
	CALL	Y_
	CALL	T_INS
;--
	CALL	B_INSTALL		;TURN		;2
	CALL	M_WAIT
	LD	BC,#013A
	LD	HL,B_
	CALL	Y_
;--
	CALL	H_INSTALL		;STRETCH 1	;3
	CALL	M_WAIT
	LD	BC,#00CD
	LD	HL,K_
	CALL	Y_
;--
	CALL	D_INSTALL		;VOXEL		;4
	CALL	M_WAIT
	LD	BC,#0099
	LD	HL,D_
	CALL	Y_
;--
	CALL	F_INSTALL		;ROTATE		;4
	CALL	M_WAIT
	LD	BC,#009D
	LD	HL,F_
	CALL	Y_
;--
	CALL	J_INSTALL		;PLAZMA		;4
	CALL	M_WAIT
	LD	BC,#009D
	LD	HL,J_
	CALL	Y_
;--
	CALL	H_INSTALL		;STRETCH 2	;3
	CALL	M_WAIT
	LD	BC,#00C1
	LD	HL,H_
	CALL	Y_
;--
	CALL	C_INSTALL		;BUMP		;3
	CALL	M_WAIT
	LD	BC,#00D2
	LD	HL,C_
	CALL	Y_
;--
	CALL	E_INSTALL		;SCALING	;2
	CALL	M_WAIT
	LD	BC,#013A
	LD	HL,E_
	CALL	Y_
;--
	CALL	H_INSTALL		;TUNNEL		;3
	CALL	M_WAIT
	LD	BC,#00D3
	LD	HL,I_
	CALL	Y_
;--
	LD	BC,#0020
	LD	HL,L_
	CALL	Y_
;-------
EXIT:	LD	SP,#3131
	DI 
	CALL	OOUT10
	LD	HL,M_OUT_T
	LD	BC,#000D
	SUB	A
	CALL	FILL
	CALL	M_INS
	LD	IY,#5C3A
	LD	A,#3F
	LD	I,A
	IM	1
	LD	HL,#2758
	EXX 
	RET 
;-------------------------------L------------------------------;
L_:CALL	HHALT
	LD	HL,H_TPOS+1
	INC	(HL)
	INC	L
	LD	A,(HL)
	INC	A
	AND	#07
	ADD	A,#08
	LD	(HL),A
	LD	HL,H_MPOS+1
	INC	(HL)
	INC	L
	LD	A,(HL)
	AND	#07
	ADD	A,#08
	LD	(HL),A
	JP	H_MAIN
;-------------------------------K------------------------------;
K_:	LD	A,USE_BANK_5
	LD	DE,#01FF
	LD	HL,K_SIN_0
	LD	BC,K_SIN_1
	JP	H_P00
;-------
K_SIN_0	DEFW	  #6880
	DEFW	  #0000
	DEFW	  #0010
K_SIN_1	DEFW	  #7380
	DEFW	  #0000
	DEFW	  #000C
;-------------------------------;
K?_INSTALL:
	LD	A,#2C
	LD	LY,#00
	CALL	Z_MAIN
	LD	DE,#8000
	LD	H,#C0-#20
	LD	B,T_SIN/#100
K_I10	LD	L,#00
K_I11	LD	A,(HL)
	LD	C,A
	SRL	A
	SRL	A
	AND	#3F
	LD	(DE),A
	INC	L
	INC	E
	LD	A,(BC)
	SRL	A
	SRL	A
	LD	LX,A
	LD	A,(HL)
	SUB	D
	ADD	A,LX
	AND	#3F
	LD	(DE),A
	INC	L
	INC	E
	JR	NZ,K_I11
	INC	H
	INC	D
	BIT	6,D
	JR	Z,K_I10
	LD	A,USE_BANK_5
	JP	H_I20
;-------------------------------J------------------------------;
J_C2P_T		EQU #80
J_REND_LN	EQU #C000	;COD=#0400
J_TEXTURE	EQU #8000	;TXR=#4000
J_B_SCR		EQU #80C0	;BUF=#2600	#40 x #26
J_SRL_T		EQU #C400	;TAB=#0100
;---------------
J_:	EI 
	HALT 
;-------
	CALL	J_POSA
;-------
J_TY1	LD	B,#00
J_TY2	LD	H,#00
J_TY3	LD	D,#00
	EXX 
J_TY4	LD	H,#00
	LD	D,J_B_SCR/#100
	LD	B,J_SRL_T/#100
	LD	LX,#26
J_C01	LD	E,J_B_SCR
	RES	6,H
	SET	7,H
J_TX4	LD	L,#00
	EXX 
	RES	6,B
	RES	6,H
	RES	6,D
	SET	7,B
	SET	7,H
	SET	7,D
J_TX1	LD	C,#00
J_TX2	LD	L,#00
J_TX3	LD	E,#00
	CALL	J_REND_LN
	INC	B
	INC	H
	INC	D
	EXX 
	INC	H
	INC	D
	DEC	LX
	JR	NZ,J_C01
	JP	C2P_
;-------
J_POSA:
	LD	C,#0C
J_PS01	LD	HL,T_SIN
	INC	L
	INC	L
	INC	L
	INC	L
	LD	(J_PS01+1),HL
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TX1+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TX2+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TX3+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TX4+1),A
;-
J_PS02	LD	HL,T_SIN+#20
	INC	L
	INC	L
	LD	(J_PS02+1),HL
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TY1+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TY2+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TY3+1),A
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(J_TY4+1),A
;--
J_PS03	LD	A,#00
	INC	A
	LD	(J_PS03+1),A
	AND	#0F
	LD	HL,J_COLL
	ADD	A,L
	LD	L,A
	LD	DE,J_SRL_T
	LD	BC,#0020
	LDIR 
	RET 
;-------------------------------;
J_INSTALL:
;---------
	LD	DE,J_REND_LN
	LD	HL,J_IT1
	LD	BC,#400F
	CALL	MOVES
	LD	(HL),#C9
;-----------
	LD	LX,#00
	CALL	B_I00
;-------
	LD	LX,J_C2P_T
	LD	DE,J_B_SCR
	LD	BC,#0100
	CALL	C2P_INS
	JP	C2P_IAD
;-------
J_IT1	LD	A,(BC)
	INC	C
	ADD	A,(HL)
	INC	L
	EX	DE,HL
	ADD	A,(HL)
	INC	L
	EXX 
	ADD	A,(HL)
	INC	L
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	INC	E
	EXX 
J_COLL	DEFB	  #80,#81,#82,#83,#84,#85,#86,#87
	DEFB	  #87,#86,#85,#84,#83,#82,#81,#80
	DEFB	  #80,#81,#82,#83,#84,#85,#86,#87
	DEFB	  #87,#86,#85,#84,#83,#82,#81,#80
	DEFB	  #80,#81,#82,#83,#84,#85,#86,#87
	DEFB	  #87,#86,#85,#84,#83,#82,#81,#80
	DEFB	  #80,#81,#82,#83,#84,#85,#86,#87
	DEFB	  #87,#86,#85,#84,#83,#82,#81,#80
;-------------------------------I------------------------------;
I_:	LD	A,USE_BANK_4
	LD	DE,#FFFE
	LD	HL,I_SIN_0
	LD	BC,I_SIN_1
	JP	H_P00
;--
I_SIN_0	DEFW	  #6880
	DEFW	  #0000
	DEFW	  #0018
I_SIN_1	DEFW	  #7380
	DEFW	  #0000
	DEFW	  #0014
;-------------------------------;
I?_INSTALL:
	LD	A,#6F
	LD	HL,I?_IT
	CALL	Z_MAIN
	LD	DE,#8000
	LD	H,#C0-#20
I_I10	LD	L,#00
I_I11	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(DE),A
	INC	L
	INC	E
	LD	A,(HL)
	LD	(DE),A
	INC	L
	INC	E
	JR	NZ,I_I11
	INC	H
	INC	D
	BIT	6,D
	JR	Z,I_I10
	LD	A,USE_BANK_4
	JP	H_I20
I?_IT:	DEFB	  #14,#1C,#24,#2B,#31,#36,#3B,#00
	DEFB	  #04,#08,#0B,#0E,#11,#13,#15,#16
	DEFB	  #17,#18,#19,#1A,#1B,#1B,#1C,#1D
	DEFB	  #1D,#1E,#1E,#1F,#1F,#20,#20,#21
	DEFB	  #21,#21,#22,#22,#22,#23,#23,#23
	DEFB	  #24,#24,#24,#25,#25,#25,#26,#26
	DEFB	  #26,#26,#27,#27,#27,#27,#28,#28
	DEFB	  #28,#28,#28,#29,#29,#29,#29,#29
;-------------------------------H------------------------------;
H_C2P_T		EQU #80
H_REND_LN	EQU #7E00	;COD=#0200
H_TEXTURE	EQU #8000	;TXR=#4000
H_B_SCR		EQU #80C0	;BUF=#2600	#40 x #26
;---------------
H_:	LD	A,USE_BANK_3
	LD	DE,#0102
	LD	HL,H_SIN_0
	LD	BC,H_SIN_1
H_P00:
   CALL	HHALT
	PUSH	BC
	CALL	OOUT
	LD	A,(H_TPOS+1)
	ADD	A,D
	AND	#3F
	LD	(H_TPOS+1),A
	LD	A,(H_TPOS+2)
	ADD	A,E
	AND	#3F
	OR	#80
	LD	(H_TPOS+2),A
	CALL	SIN
	SUB	#60
	ADD	A,A
	LD	(H_MPOS+1),A
	POP	HL
	CALL	SIN
	ADD	A,#60-#13
	LD	(H_MPOS+2),A
;-------
H_MAIN:
	LD	D,H_B_SCR/#100
	EXX 
H_MPOS	LD	HL,C_MAP+#40+#2000-#1300
	CALL	H_REND
;-
   CALL	HHALT
;-
	CALL	H_REND
	JP	C2P_
;-------
H_REND:	LD	(H_SP+1),SP
	LD	B,#13
H_C01	LD	SP,HL
	INC	H
	EXX 
H_TPOS	LD	BC,#8000
	LD	E,H_B_SCR
	JP	H_REND_LN
H_RET	INC	D
	EXX 
	DJNZ	H_C01
H_SP	LD	SP,#3131
	RET 
;-------
H_SIN_0	DEFW	  #6880
	DEFW	  #0000
	DEFW	  #0010
H_SIN_1	DEFW	  #7380
	DEFW	  #0000
	DEFW	  #0010
;-------------------------------;
H_INSTALL:
;---------
	LD	DE,H_REND_LN
	LD	HL,H_IT1
	LD	BC,#4007
	CALL	MOVES
	LD	DE,H_RET
	CALL	EXIT_1
;-----------
	LD	LX,H_C2P_T
	CALL	B_I00
;-------
	LD	LX,H_C2P_T
	LD	DE,H_B_SCR
	LD	BC,#0100
	CALL	C2P_INS
	JP	C2P_IAD
;-------
H_IT1	POP	HL		;10
	ADD	HL,BC		;11
	RES	6,H		;8
	LD	A,(HL)		;7
	LD	(DE),A		;7
	INC	E		;7	;47
;-------------------------------;
H?_INSTALL:
	LD	A,#2C
	LD	LY,#00
	CALL	Z_MAIN
	LD	DE,#8000
	LD	H,#C0-#20
H_I10	LD	L,#00
H_I11	LD	A,(HL)
	SRL	A
	SRL	A
	ADD	A,D
	AND	#3F
	LD	(DE),A
	INC	L
	INC	E
	LD	A,(HL)
	LD	(DE),A
	INC	L
	INC	E
	JR	NZ,H_I11
	INC	H
	INC	D
	BIT	6,D
	JR	Z,H_I10
	LD	A,USE_BANK_3
H_I20	CALL	OOUT
	JP	B_I30
;-------------------------------G------------------------------;
G_C2P_T		EQU #80
G_REND_LN	EQU #8800	;COD=#0400
G_SRL_T		EQU #8C00	;TAB=#0100
G_B_SCR		EQU #DA00	;BUF=#2600	#40 x #26
;---------------
G_:	LD	A,#47
	CALL	FILATTR
;-
	LD	IY,G_TEXT
	LD	DE,G_B_SCR+#300+#05
	LD	HL,#0212
	LD	A,#03
	CALL	G_C00
	LD	DE,G_B_SCR+#300+#07
	LD	HL,#0018
	LD	A,#02
	CALL	G_C00
	LD	DE,G_B_SCR+#100+#07
	LD	HL,#0018
	LD	A,#02
	CALL	G_C00
	LD	DE,G_B_SCR+#300+#05
	LD	HL,#0212
	LD	A,#03
	JP	G_C00
;-------
G_BLUR:	LD	H,G_B_SCR/#100+1
	LD	C,#24
G_C22	LD	L,G_B_SCR
	LD	B,#3E
	LD	A,(HL)
G_C21	INC	L		;4
	DEC	H		;4
	ADD	A,(HL)		;7
	INC	H		;4
	INC	H		;4
	ADD	A,(HL)		;7
	DEC	H		;4
	INC	L		;4
	ADD	A,(HL)		;7
	DEC	L		;4
	SRL	A		;8
	SRL	A		;8
	ADD	A,G_C2P_T	;7
	LD	(HL),A		;7	;74
	DJNZ	G_C21
	INC	H
	DEC	C
	JR	NZ,G_C22
	RET 
;-------
G_C00	LD	HX,A
	LD	A,H
	LD	(G_D01+1),A
	LD	A,L
	LD	(G_D02+1),A
	LD	A,G_C2P_T+#00
	LD	H,G_B_SCR/#100
G_C05	LD	L,G_B_SCR
	LD	B,#40
G_C04	LD	(HL),A
	INC	L
	DJNZ	G_C04
	INC	H
	JR	NZ,G_C05
;----
	PUSH	DE
G_C03	LD	L,(IY+0)
	INC	IY
	LD	H,#00
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	A,H
	ADD	A,#3C
	LD	H,A
	PUSH	DE
	LD	LX,#08
G_C02	LD	A,(HL)
	RRCA 
	OR	(HL)
	LD	C,A
	PUSH	DE
	LD	B,#08
G_C01	RLC	C
	LD	A,G_C2P_T+#00
	JR	NC,$+2+2
	LD	A,G_C2P_T+#08
	LD	(DE),A
	INC	E
	LD	(DE),A
	INC	E
G_D01	JR	$+2+2
	LD	(DE),A
	INC	E
	DJNZ	G_C01
	POP	DE
	INC	D
	INC	D
	INC	D
	INC	D
	INC	L
	DEC	LX
	JR	NZ,G_C02
	POP	DE
	LD	A,E
G_D02	ADD	A,#14
	LD	E,A
	DEC	HX
	JR	NZ,G_C03
;----
	POP	HL
	LD	HX,#08
G_C12	LD	E,L
	LD	D,H
	INC	D
	LD	LX,#03
G_C11	PUSH	DE
	PUSH	HL
	LD	BC,#0040
	LDIR 
	POP	HL
	POP	DE
	INC	D
	DEC	LX
	JR	NZ,G_C11
	INC	H
	INC	H
	INC	H
	INC	H
	DEC	HX
	JR	NZ,G_C12
;-----------
	CALL	G_BLUR
	CALL	M_WAIT
	CALL	C2P_
	EI 
	LD	B,#44
	HALT 
	DJNZ	$-1
	LD	LX,#08
G_C31	HALT 
	HALT 
	CALL	G_BLUR
	CALL	C2P_
	EI 
	DEC	LX
	JR	NZ,G_C31
	RET 
;---------------
G_INSTALL:
;-------
	CALL	OOUT10
;--
	SUB	A
	LD	(C2P_SPR),A
	LD	LX,G_C2P_T
	LD	DE,G_B_SCR
	LD	BC,#0100
	CALL	C2P_INS
	LD	HL,C2P_SPR1
	CALL	C2P_MOV
;-
	LD	B,#10
	HALT 
	DJNZ	$-1
	JP	G_
;-------
G_TEXT	DEFB	  "GOA"
	DEFB	  "4K"
	DEFB	  "by"
	DEFB	  "XTM"
;-------------------------------F------------------------------;
F_C2P_T		EQU #80
F_TEXTURE	EQU #C000	;TXR=#4000
F_REND_LN	EQU #8800	;COD=#0200
F_B_SCR		EQU #9000	;BUF=#0980	#40 x #26
F_T_POS		EQU #A000	;BUF=#0130
;---------------
F_:	EI 
	HALT 
;-------
	CALL	F_POSA
	CALL	F_POSA
	CALL	F_POSA
;----
	LD	BC,F_B_SCR
F_X22	LD	DE,#1111
	EXX 
F_X12	LD	DE,#1111
	LD	LY,#26
F_X11	LD	HL,#2121
	INC	DE
	INC	DE
	EXX 
F_X21	LD	HL,#2121
	DEC	DE
	DEC	DE
	CALL	F_REND_LN
	EXX 
	LD	BC,#0008
	ADD	IX,BC
;--
	PUSH	DE
	LD	DE,(F_X22+1)
	LD	HL,(F_X11+1)
	ADD	HL,DE
	LD	(F_X11+1),HL

	LD	DE,(F_X12+1)
	LD	HL,(F_X21+1)
	OR	A
	SBC	HL,DE
	LD	(F_X21+1),HL
	POP	DE
;--
	DEC	LY
	JR	NZ,F_X11
	JP	C2P_
;-------
F_POSA:
	LD	HL,F_SIN_3
	CALL	SIN
	CALL	F_SUB80
;-
	PUSH	HL
	LD	HL,F_SIN_1
	CALL	SIN
	CALL	F_SUB80
	POP	BC
	ADD	HL,BC
	LD	(F_X12+1),HL
;---
	LD	HL,F_SIN_2
	CALL	SIN
	CALL	F_SUB80
	LD	(F_X22+1),HL
;-------
	LD	HL,F_SIN_4
	CALL	SIN
	LD	(F_X11+1),HL
;---
	LD	HL,F_SIN_5
	CALL	SIN
	LD	(F_X21+1),HL
	RET 
F_SUB80	LD	L,H
	LD	H,#00
	LD	BC,#FF80
	ADD	HL,BC
	RET 
;-------
F_SIN_1	DEFW	  #1080
	DEFW	  #0000
	DEFW	  #0020
F_SIN_2	DEFW	  #1000	       ; #8160
	DEFW	  #0000	       ; #0540
	DEFW	  #0030
F_SIN_3	DEFW	  #3380
	DEFW	  #0000
	DEFW	  #0007
F_SIN_4	DEFW	  #5080
	DEFW	  #0000
	DEFW	  #0002
F_SIN_5	DEFW	  #4080
	DEFW	  #0000
	DEFW	  #0002
;-------------------------------;
F_INSTALL:
;-------
	LD	A,#14
	LD	(BLUR_ON+1),A
	LD	LX,F_C2P_T
	CALL	B_I00
	CALL	B_I30
;-------
	LD	DE,F_REND_LN
	LD	HL,F_IT1
	LD	BC,#400C
	CALL	MOVES
	LD	(HL),#C9
	DEC	HL
	LD	(HL),#03
;-------
	LD	LX,#50
	CALL	F_POSA
	DEC	LX
	JR	NZ,$-2-3
;-------
	LD	A,#88
	LD	(C2P_SPR),A
	LD	LX,F_C2P_T
	LD	DE,F_B_SCR
	LD	BC,#0040
	CALL	C2P_INS
	JP	C2P_IAD
;-------
F_IT1	LD	A,H		;4
	ADD	HL,DE		;11
	EXX			;4
	OR	#C0		;7
	LD	B,A		;4
	LD	C,H		;4
	ADD	HL,DE		;11
	LD	A,(BC)		;7
	EXX			;4
	LD	(BC),A		;7
	INC	C		;4	;67
;-------------------------------E------------------------------;
E_C2P_T		EQU #C0
E_TEXTURE	EQU #8000	;TXR=#4000
E_REND_LN	EQU #C800	;COD=#0200
E_B_SCR		EQU #D000	;BUF=#0980	#40 x #26
E_POSYKIZ	EQU #E000	;POS=#2000
;---------------
E_:CALL	HHALT
;-------
E_POS1	LD	A,#FF
	INC	A
	INC	A
	AND	#1F
	LD	(E_POS1+1),A
	CP	#01
	JR	NZ,E_C01
	EXA
	LD	A,(E_PTXR2+1)
	ADD	A,#28
	LD	(E_PTXR2+1),A
	LD	(E_PTXR3+1),A
	ADD	A,#28
	LD	(E_PTXR1+1),A
	EXA
E_C01
	LD	C,A
	ADD	A,E_POSYKIZ/#100
	LD	HX,A
	LD	LX,#00
;----
E_PTXR1	LD	A,#28	    ;POS TXR2
	LD	(E1_D14+2),A
	LD	A,C
E_PTXR2	ADD	A,#00	    ;POS TXR1
	LD	(E1_D01+2),A
	LD	(E1_D11+2),A
	LD	A,C
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	E,A
	LD	D,#00
	LD	HL,#0100
	OR	A
	SBC	HL,DE
	LD	(E1_D02+1),HL
	LD	(E1_D12+1),HL
	LD	(E1_D18+1),HL
	PUSH	HL
	LD	L,C
	SRL	L
	LD	H,#00
	ADD	HL,HL
	LD	DE,E_DIV_T
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(E1_D15+1),DE
;--
	POP	DE
	LD	B,C
	LD	HL,#2000
	ADD	HL,DE
	DJNZ	$-1
	LD	A,H
E_PTXR3	ADD	A,#00	    ;POS TXR1
	LD	H,A
	LD	(E1_D17+1),HL
;--
	LD	A,C
	CP	#14
	JR	C,$+2+2
	LD	A,#13
	LD	LY,A
	LD	A,#13
	SUB	LY
	LD	HY,A
;--
	LD	HL,E_REND_LN+#E0-#07
	LD	B,C
	INC	B
	LD	DE,#0007
	ADD	HL,DE
	DJNZ	$-1
	LD	(E1_D13+1),HL
	LD	(E1_D19+1),HL
;--
	LD	HL,E_REND_LN+#1C0+#0E
	LD	B,C
	INC	B
	LD	DE,0-#0E
	ADD	HL,DE
	DJNZ	$-1
	LD	(E1_D16+1),HL
;-------
	LD	HL,E_B_SCR
	EXX 
	LD	A,HY
	OR	A
	JR	Z,E1_C1
E1_D01	LD	HL,#0000
E1_D02	LD	DE,#1111
	LD	B,(IX+#00)
	CALL	E_REND_LN
	INC	LX
	DEC	HY
	JR	NZ,E1_D01
;-
E1_C1	LD	A,LY
	OR	A
	JP	Z,C2P_
E1_D11	LD	HL,#0000
E1_D12	LD	DE,#1111
	LD	B,(IX+#00)
E1_D13	CALL	#CDCD
E1_D14	LD	HL,#0000
E1_D15	LD	DE,#1111
	LD	B,(IX+#30)
E1_D16	CALL	#CDCD
E1_D17	LD	HL,#2121
E1_D18	LD	DE,#1111
	LD	B,(IX+#00)
E1_D19	CALL	#CDCD
	INC	LX
	DEC	LY
	JR	NZ,E1_D11
	JP	C2P_
;-------------------------------;
E_INSTALL:
;-------
	LD	A,#14
	LD	(BLUR_ON+1),A
;-
	LD	DE,E_REND_LN
	LD	HL,E_IT1
	LD	BC,#4007
	CALL	MOVES
	LD	(HL),#C9
	DEC	L
	DEC	L
	LD	(HL),#23
;-------
	LD	BC,E_POSYKIZ+#0130+#12
	LD	IY,E_DIV_T
	LD	IX,#1002
E_I22	LD	E,(IY+#00)
	LD	D,(IY+#01)
	INC	IY
	INC	IY
	PUSH	IX
	PUSH	BC
	LD	HL,#8000
E_I21	LD	A,H
	LD	(BC),A
	INC	C
	ADD	HL,DE
	DEC	LX
	JR	NZ,E_I21
	POP	BC
	DEC	C
	DEC	C
	INC	B
	INC	B
	POP	IX
	INC	LX
	INC	LX
	DEC	HX
	JR	NZ,E_I22
;---
	LD	D,E_POSYKIZ/#100+1
	LD	BC,#00F8
	LD	HL,#8100
	LD	HX,#10
E_I42	PUSH	HL
	DUP   #20-#13
	ADD	HL,BC
	EDUP 
	LD	LX,#13
	LD	E,E_POSYKIZ
E_I41	LD	A,H
	LD	(DE),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JR	NZ,E_I41
	POP	HL
	INC	H
	LD	A,C
	SUB	#08
	LD	C,A
	INC	D
	INC	D
	DEC	HX
	JR	NZ,E_I42
;-------
	LD	LX,E_C2P_T
	CALL	B_I00
;-------
	LD	LX,E_C2P_T
	LD	DE,E_B_SCR
	LD	BC,#0040
	CALL	C2P_INS
;-
	LD	DE,E_B_SCR+#480
	LD	BC,#FFC0
	LD	HL,C2P_TPOS1+#13+#13+#13+#13
	LD	A,#13
	CALL	C2P_I20
;-
	JP	C2P_IAD
;-------
E_IT1	LD	C,H		;4
	LD	A,(BC)		;7
	ADD	HL,DE		;11
	EXX			;4
	LD	(HL),A		;7
	INC	L		;4
	EXX			;4	;41
;-------
E_DIV_T:DEFW	  #3FFF,#0CCC,#071C,#04EC
	DEFW	  #03C3,#030C,#028F,#0234
	DEFW	  #01F0,#01BA,#018F,#016C
	DEFW	  #014E,#0135,#011F,#010C
;-------------------------------D------------------------------;
D_C2P_T		EQU #C0
D_VOXELZ	EQU #8000	;BUF=#4000
D_MAKE_LN	EQU #D000	;COD=#0800
D_B_SCR		EQU #D800	;BUF=#2600 #00-#40 - SCR BUFF
D_VOLMZ		EQU #D840	;TAB=#2600 #40-#A0 - TAB VOLUMZ
D_BRIGHTZ	EQU #DAE0	;TAB=#2600 #A0-#00 - TAB BRIGHTZ
;---------------
D_:	EI 
	HALT 
;-------
	LD	HL,D_SIN_1
	CALL	SIN
	LD	(D_POS_X+1),HL
;--
	LD	HL,D_POS_Y+1
	DEC	(HL)
;-------
	LD	DE,D_C2P_T*#100+D_C2P_T
	LD	H,D_B_SCR/#100
	LD	B,#09
	LD	(D_CL_1+1),SP
D_CL_2	LD	L,#40
	LD	SP,HL
	DUP   #20
	PUSH	DE
	EDUP 
	INC	H
	DJNZ	D_CL_2
D_CL_1	LD	SP,#3131
;-----------
D_POS_X	LD	HL,#2121
	LD	(D_D11+1),HL
	LD	HL,#0106
	LD	(D_D12+1),HL
;----
	LD	BC,#00A0
	LD	H,D_VOLMZ/#100+#24
	EXX 
D_POS_Y	LD	D,#00
	LD	LX,#16
D_C01	SET	7,D
	RES	6,D
	EXX 
	LD	E,#00
	DEC	H
	INC	B
	INC	B
	DEC	C
	DEC	C
	EXX 
D_D11	LD	HL,#2121
	LD	BC,#00C0
	ADD	HL,BC
	LD	(D_D11+1),HL
D_D12	LD	BC,#0101
	DEC	BC
	DEC	C
	DEC	C
	DEC	C
	DEC	C
	DEC	C
	LD	(D_D12+1),BC
	CALL	D_MAKE_LN
	INC	D
	DEC	LX
	JR	NZ,D_C01
	JP	C2P_
;-------
D_SIN_1	DEFW	  #6880
	DEFW	  #0000
	DEFW	  #0010
;-----------------------;
D_INSTALL:
;-------
	CALL	OOUT10
;--
	LD	DE,D_MAKE_LN
	LD	HL,D_IT1
	LD	BC,#400D+10+2
	CALL	MOVES
	LD	(HL),#C9
;-------
	LD	HX,D_VOLMZ/#100
	LD	HL,D_B_SCR-#0000
	LD	DE,#0100
	LD	C,#26
D_I22	PUSH	HL
	LD	LX,D_VOLMZ
	LD	B,#60
D_I21	LD	A,H
	CP	D_VOLMZ/#100+#26
	JR	C,$+2+1
	SUB	A
	CP	D_VOLMZ/#100
	JR	NC,$+2+1
	SUB	A
	LD	(IX+0),A
	INC	LX
	ADD	HL,DE
	DJNZ	D_I21
	INC	HX
	LD	HL,#FFFB	;COMPRESS
	ADD	HL,DE
	EX	DE,HL
	POP	HL
	DEC	C
	JR	NZ,D_I22
;-------
	LD	D,D_BRIGHTZ/#100
	LD	A,#26
D_I31	LD	E,D_BRIGHTZ
	LD	HL,D_IT2
	LD	BC,#0020
	LDIR 
	DEC	A
	JR	NZ,D_I31
	LD	(BLUR_ON+1),A
;-------
	LD	LX,#00
	CALL	B_I00
;-------
	LD	HL,D_VOXELZ
	PUSH	HL
	LD	DE,D_VOXELZ+#4000
	LD	BC,#0100
	LDIR 
	POP	HL
D_I52	LD	L,#00
D_I51	LD	A,(HL)
	INC	H
	ADD	A,(HL)
	INC	L
	ADD	A,(HL)
	DEC	H
	ADD	A,(HL)
	DEC	L
	ADD	A,D_VOLMZ
	LD	(HL),A
	INC	L
	BIT	6,L
	JR	Z,D_I51
	LD	E,L
	LD	D,H
	LD	BC,#00C0
	LD	L,B
	LDIR 
	INC	H
	BIT	6,H
	JR	Z,D_I52
;-------
	SUB	A
	LD	(C2P_SPR),A
	LD	LX,D_C2P_T
	LD	DE,D_B_SCR
	LD	BC,#0100
	CALL	C2P_INS
	JP	C2P_IAD
;-------
D_IT1	ADD	HL,BC		;11
	LD	E,H		;4
	LD	A,(DE)		;7
	EXX			;4
	ADD	A,B		;8
	LD	L,A		;4
	LD	D,(HL)		;7
	ADD	A,C		;4
	LD	L,A		;4
	LD	A,(HL)		;7
	DUP   #06
	LD	(DE),A		;7
	INC	D		;4
	EDUP 
	LD	(DE),A		;7
	INC	E		;4	;54
	EXX 
;-------
D_IT2	DEFB	  #C7,#C7,#C7,#C7
	DEFB	  #C6,#C6,#C6,#C6
	DEFB	  #C5,#C5,#C5,#C5
	DEFB	  #C4,#C4,#C4,#C4
	DEFB	  #C4,#C3,#C3,#C3
	DEFB	  #C3,#C3,#C2,#C2
	DEFB	  #C2,#C2,#C2,#C1
	DEFB	  #C1,#C1,#C1,#C1
;-------------------------------C------------------------------;
C_C2P_T		EQU #B0
C_TXR		EQU #8000	;TXR=#4000	#80 x #40
C_B_SCR		EQU #80C0	;BUF=#2600	#40 x #26
C_MAP		EQU #C000	;MAP=#4000
C_REND_LN	EQU #7E00	;COD=#0200
;---------------
C_:CALL	HHALT
	CALL	C_POSA
;-------
	LD	D,C_B_SCR/#100
	EXX 
C_MPOS	LD	HL,C_MAP
	CALL	C_REND
;-
   CALL	HHALT
;-
	CALL	C_REND
	JP	C2P_
;-------
C_REND:	LD	(C_SP+1),SP
	LD	B,#13
C_C01	SET	6,H
	SET	7,H
	LD	SP,HL
	INC	H
	EXX 
C_LPOS	LD	BC,#0000
	LD	E,C_B_SCR
	JP	C_REND_LN
C_RET	INC	D
	LD	HL,C_LPOS+2
	INC	(HL)
	EXX 
	DJNZ	C_C01
C_SP	LD	SP,#3131
	RET 
;-------
C_POSA:
C_SIN_3	LD	HL,T_SIN
	INC	L
	INC	L
	INC	L
	INC	L
	LD	(C_SIN_3+1),HL
	LD	A,(HL)
	CPL 
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	ADD	A,#80-4+#20-#13
	LD	(C_LPOS+2),A
;-
	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(C_MPOS+2),A
;---
C_SIN_2	LD	HL,T_SIN+#20
	INC	L
	INC	L
	LD	(C_SIN_2+1),HL
	LD	A,(HL)
	CPL 
	SRL	A
	SRL	A
	SRL	A
	ADD	A,#10
	LD	B,A
;-
	LD	A,(HL)
	SRL	A
	AND	#3F
	LD	C,A
	ADD	A,A
	LD	(C_MPOS+1),A
	LD	A,B
	SUB	C
	LD	(C_LPOS+1),A
	RET 
;-------------------------------;
C_INSTALL:
;-------
	LD	DE,C_REND_LN
	LD	HL,C_IT1
	LD	BC,#4005
	CALL	MOVES
	LD	DE,C_RET
	CALL	EXIT_1
;-----------
	LD	LX,#00
	CALL	B_I00
	LD	HL,#8000
	LD	BC,#2300	;28
C_I51	LD	A,(HL)
	AND	#02
	LD	(HL),B
	JR	NZ,$+2+1
	LD	(HL),C
	INC	HL
	BIT	6,H
	JR	Z,C_I51
	LD	BC,#1000
	CALL	B_I31
;-
	LD	LX,#02
C_I63	LD	H,#81
	LD	C,#50
C_I62	LD	L,#40
	LD	B,#50
	LD	A,(HL)
C_I61	INC	L
	DEC	H
	ADD	A,(HL)
	INC	H
	INC	H
	ADD	A,(HL)
	DEC	H
	INC	L
	ADD	A,(HL)
	DEC	L
	SRL	A
	SRL	A
	LD	(HL),A
	DJNZ	C_I61
	INC	H
	DEC	C
	JR	NZ,C_I62
	DEC	LX
	JR	NZ,C_I63
;-
	LD	A,#50
	LD	H,#81
C_I64	LD	D,H
	LD	L,#48
	LD	E,#88
	LD	BC,#0050
	LDIR 
	INC	H
	DEC	A
	JR	NZ,C_I64
	LD	(BLUR_ON+1),A
;-------
	LD	D,C_MAP/#100+#3F
	LD	H,#80+#47
C_I22	LD	E,C_MAP
	LD	L,#48
	LD	B,#00
C_I21	LD	C,(HL)
	INC	L
	LD	A,(HL)
	DEC	L
	SUB	C
	ADD	A,B
	LD	(DE),A
	INC	E
	INC	H
	LD	A,(HL)
	DEC	H
	SUB	C
	LD	(DE),A
	INC	E
	INC	L
	INC	B
	BIT	7,B
	JR	Z,C_I21
	DEC	H
	DEC	D
	BIT	6,D
	JR	NZ,C_I22
;------------
	LD	A,USE_BANK_2
	CALL	OOUT
	LD	HL,C?_TXR
	LD	D,C_TXR/#100
C_I41	LD	BC,#0080
	LD	E,C_TXR
	LDIR 
	INC	D
	BIT	6,D
	JR	Z,C_I41
	CALL	OOUT10
;-------
	LD	LX,C_C2P_T
	LD	DE,C_B_SCR
	LD	BC,#0100
	CALL	C2P_INS
	JP	C2P_IAD
;-------
C_IT1	POP	HL		;10
	ADD	HL,BC		;11
	LD	A,(HL)		;7
	LD	(DE),A		;7
	INC	E		;7	;39
;-------------------------------;
C?_INSTALL:
	LD	A,#6F
	LD	HL,C?_IT
	CALL	Z_MAIN
	LD	DE,#8000
	LD	H,#C0-#20
	LD	C,#40
C_II1	LD	B,#80
	LD	L,#01
C_II0	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	L
	INC	L
	DJNZ	C_II0
	INC	H
	DEC	C
	JR	NZ,C_II1
	LD	A,USE_BANK_2
	CALL	OOUT
	LD	HL,#8000
	LD	DE,C?_TXR
	LD	BC,#2000
	LDIR 
	RET 
C?_IT	DEFB	  #B7,#B7,#B7,#B7,#B7,#B6,#B6,#B6
	DEFB	  #B6,#B5,#B5,#B4,#B4,#B3,#B3,#B2
	DEFB	  #B2,#B2,#B1,#B1,#B1,#B0,#B0
	DEFB	  #B0,#B0,#B1,#B1,#B1,#B2,#B2,#B2
	DEFB	  #B3,#B3,#B4,#B4,#B5,#B5,#B5,#B6
	DEFB	  #B6,#B6,#B7,#B7,#B7,#B7,#B6,#B6
	DEFB	  #B6,#B5,#B5,#B5,#B4,#B4,#B3,#B3
	DEFB	  #B2,#B2,#B2,#B1,#B1,#B1,#B0,#B0,#B0
;-------------------------------B------------------------------;
B_C2P_T		EQU #83
B_B_SCR		EQU #B820	;BUF=#2600	#40 x #26
B_TXR_BUF	EQU #8000	;TXR=#7000
B_H_INC		EQU #8100	;COD=#0200
B_REND_LN	EQU #8000	;COD=#0C00
;---------------
B_:CALL	HHALT
	CALL	B_POSA
;-------
	LD	A,(B_R1_D4+1)
	LD	B,A
	LD	C,#00
	LD	HL,#0000
	LD	DE,#2500
	CALL	B_H_INC
;-----------
B_R1_D1	LD	A,#90
B_R1_D3	LD	HL,#1000
B_R1_D4	LD	DE,#0140
	OR	A
	LD	B,#20
	SBC	HL,DE
	DJNZ	$-2

	PUSH	HL
	LD	HL,0
	OR	A
	LD	B,#13
	SBC	HL,DE
	DJNZ	$-2
	SUB	H
	LD	B,A
	POP	HL

	DEC	D

	LD	A,B
	LD	(B_R_D1+2),A
	LD	A,H
	LD	(B_R_D1+1),A
	EXX 
	LD	LX,#26
	LD	D,B_B_SCR/#100
	LD	A,B_B_SCR
B_UNTY1	OR	#00
	LD	HX,A
B_R_D1	LD	HL,#0000
	LD	E,HX
;--
	CALL	B_REND_LN
;--
	INC	D
	EXX 
	INC	B
	LD	A,B
	LD	(B_R_D1+2),A
	ADD	HL,DE
	LD	A,H
	LD	(B_R_D1+1),A
	EXX 
	DEC	LX
	JP	NZ,B_R_D1
	JP	C2P_
;---------------
B_POSA:
	LD	HL,B_SIN_0
	CALL	SIN
	SRL	A
	SRL	A
	SRL	A
	ADD	A,#32+3
	LD	(B_R1_D3+2),A
;-------
	LD	HL,B_SIN_1
	CALL	SIN
	SRL	A
	SRL	A
	SRL	A
	ADD	A,#80+#0A+#10
	LD	(B_R1_D1+1),A
;-------
	LD	HL,B_SIN_2
	CALL	SIN
	SUB	#10
	LD	(B_R1_D4+1),A
;-------
	LD	A,(C2P_1+1)
	LD	(B_UNTY1+1),A
	LD	C,A
	LD	A,(B_R1_D3+2)
	OR	C
	XOR	#80
	LD	(B_R1_D3+2),A
	LD	A,C
	OR	A
	LD	HL,#0000
	JR	NZ,$+2+3
	LD	HL,#FDCB
	LD	(B_ADD1+1),HL
	RET 
;-------
B_SIN_0	DEFW	  #5080
	DEFW	  #0000
	DEFW	  #0300
B_SIN_1	DEFW	  #5080
	DEFW	  #0000
	DEFW	  #0200
B_SIN_2	DEFW	  #4080
	DEFW	  #0000
	DEFW	  #0180
;-------------------------------;
B_INSTALL:
;-------
	LD	LX,B_C2P_T
	CALL	B_I00
;-
	CALL	B_I30
;-------
	LD	DE,B_REND_LN
	LD	HL,B_IT1
	LD	BC,#4003
	CALL	MOVES
	LD	(HL),#C9
;-------
	LD	HL,B_H_INC
	LD	DE,B_REND_LN+#02
	LD	B,#40-1
B_I22	LD	(HL),#09	;ADD	HL,BC
	INC	HL
	LD	(HL),#7B	;LD	A,E
	INC	HL
	LD	(HL),#30	;JR	C,$+2+1
	INC	HL
	LD	(HL),#01
	INC	HL
	LD	(HL),#7A	;LD	A,D
	INC	HL
	LD	(HL),#32	;LD	(#0000),A
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	DE
	INC	DE
	INC	DE
	DJNZ	B_I22
	LD	(HL),#C9
;-------
	LD	LX,B_C2P_T
	LD	DE,B_B_SCR
	LD	BC,#0100
	JP	C2P_INS
;-----------
B_I00	LD	A,USE_BANK_1
	CALL	OOUT
	LD	D,B_TXR_BUF/#100
	LD	HL,T_TXR
B_I02	LD	E,#00
	LD	B,#40
B_I01	LD	A,(HL)
	ADD	A,LX
	LD	(DE),A
	INC	HL
	INC	E
	DJNZ	B_I01
	INC	D
	BIT	6,D
	JR	Z,B_I02
;-
B_I32	LD	H,B_TXR_BUF/#100
	LD	D,H
B_I11	LD	BC,#00C0
	LD	L,B
	LD	E,#40
	LDIR 
	INC	H
	BIT	6,H
	JR	Z,B_I11
	JP	OOUT10
;--
B_I30	LD	BC,#4000
B_I31	LD	HL,B_TXR_BUF
	LD	DE,B_TXR_BUF+#4000
	LDIR 
	RET 
;-------
B_IT1	LDI 
	NOP 
;-------------------------------T------------------------------;
T_INS:	EI 
	LD	A,#C3
	LD	(T_RET),A
;-
	LD	A,#50
	CALL	T_CALL2
	SUB	A
	LD	(A_PRAY1+1),A
	LD	(A_PRAY2+1),A
	LD	(A_PRAY3+1),A
	LD	(A_PRAY4+1),A

	LD	H,T_SIN/#100
	LD	DE,A_RAYZ
	LD	C,#03
	CALL	A_I51
	CALL	A_I51
	LD	C,#05
	CALL	A_I51
	CALL	A_I51
;-------
	CALL	T_CALL
	EI 
	LD	HL,A_B_SCR+#0C0+#10
	LD	DE,A_B_SCR
	LD	LX,#20
T_C02	LD	BC,#20
	PUSH	BC
	LDIR 
	POP	BC
	ADD	HL,BC
	PUSH	HL
	LD	H,D
	LD	L,E
	DEC	L
	LD	B,#20
T_C01	LD	A,(HL)
	SUB	A_C2P_T
	LD	(HL),A
	LD	(DE),A
	INC	DE
	DEC	L
	DJNZ	T_C01
	POP	HL
	DEC	LX
	JR	NZ,T_C02
	LD	HL,A_B_SCR+#7FF
	LD	DE,A_B_SCR+#800
	LD	BC,#40*#20
T_C03	LD	A,(HL)
	LD	(DE),A
	DEC	HL
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,T_C03
	LD	A,USE_BANK_1
	CALL	OOUT
	LD	HL,A_B_SCR
	LD	DE,T_TXR
	LD	BC,#1000
	LDIR 
	JP	OOUT10
;-------------------------------A------------------------------;
A_C2P_T		EQU #89
A_B_SCR		EQU #8000	;BUF=#0980
A_REND_LN	EQU #9100	;COD=#0180
A_RAY_DAT	EQU #9300	;BUF=#0100
A_RAYZ		EQU #9400	;TAB=#0400
A_SRL_TAB	EQU #9800	;TAB=#0100
A_GEN_RAYZ	EQU #9900	;COD=#0F00
A_GEN_LIGH	EQU #A800	;COD=#0480
A_MAP		EQU #AD00	;MAP=#1300
A_LIGH_VOL	EQU #C000	;TAB=#2600
A_VOLZ		EQU #F000	;TAB=#1000
;---------------
A_:CALL	HHALT
	CALL	A_POSA_2
;--
	CALL	A_POSA_1
;-------
T_CALL	LD	DE,A_RAY_DAT
	LD	B,A_SRL_TAB/#100
A_PRAY1	LD	HL,A_RAYZ+#000
	EXX 
A_PRAY2	LD	BC,A_RAYZ+#100
A_PRAY3	LD	HL,A_RAYZ+#200
A_PRAY4	LD	DE,A_RAYZ+#300
	CALL	A_GEN_RAYZ
;-------
A_P_LIG	LD	HL,#2121
	LD	(A_GENL1+1),SP
	LD	SP,HL
	JP	A_GEN_LIGH
A_GENL1	LD	SP,#3131
;--
	LD	LX,#0D
	LD	HL,A_MAP
	LD	BC,A_B_SCR
	CALL	A_REND_M
;--
   CALL	HHALT
	CALL	A_POSA_2
;--
	LD	LX,#19
	LD	HL,A_MAP+#0680
	LD	BC,A_B_SCR+#0340
T_RET	CALL	A_REND_M
;-------
	CALL	A_POSA_2
	JP	C2P_
;---------------
A_REND_M:
	LD	(A_R_03+1),SP
	LD	SP,HL
	LD	H,A_RAY_DAT/#100
A_R_02	JP	A_REND_LN
A_R_01	INC	BC
	DEC	LX
	JR	NZ,A_R_02
A_R_03	LD	SP,#3131
	RET 
;---------------
A_POSA_1:
	LD	HL,A_SIN_1
	CALL	SIN
	LD	(A_PRAY1+1),A
	LD	HL,A_SIN_2
	CALL	SIN
	LD	(A_PRAY2+1),A
	LD	HL,A_SIN_3
	CALL	SIN
	LD	(A_PRAY3+1),A
A_SIN_4	LD	HL,T_SIN
	INC	L
	INC	L
	INC	L
	LD	(A_SIN_4+1),HL
	LD	A,(HL)
	SRL	A
	LD	(A_PRAY4+1),A
	RET 
;-------
A_POSA_2:
A_SIN_6	LD	A,#A1
	DEC	A
	JR	NZ,$+2+1
	INC	A
	LD	(A_SIN_6+1),A
	DEC	A
	JR	Z,A_SIN_5
A_SIN_7	LD	A,#00
	INC	A
	BIT	6,A
	JR	Z,$+2+1
	DEC	A
	LD	(A_SIN_7+1),A
	SRL	A
	ADD	A,#27
	JR	T_CALL2
A_SIN_5	LD	A,0
	INC	A
	CP	40
	JR	NZ,$+2+1
	SUB	A
	LD	(A_SIN_5+1),A
	LD	E,A
	LD	D,#00
	LD	HL,A_T_MUZYKI
	ADD	HL,DE
	LD	A,(HL)
	ADD	A,#38
T_CALL2	LD	L,A
	LD	H,#00
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,A_VOLZ
	ADD	HL,DE
	LD	(A_P_LIG+1),HL
	RET 
;---------------
A_T_MUZYKI:
	DEFB	  #0F,#0F,#0F,#0E,#0E
	DEFB	  #0D,#0D,#0C,#0B,#0A
	DEFB	  #0A,#08,#07,#05,#04
	DEFB	  #03,#02,#01,#00,#00
	DEFB	  #00,#02,#03,#04,#05
	DEFB	  #07,#08,#09,#0A,#0A
	DEFB	  #0B,#0C,#0D,#0D,#0E
	DEFB	  #0E,#0F,#0F,#0F,#0F
;-------
A_SIN_1	DEFW	  #5080
	DEFW	  #0000
	DEFW	  #0030
A_SIN_2	DEFW	  #4080
	DEFW	  #0000
	DEFW	  #0018
A_SIN_3	DEFW	  #5880
	DEFW	  #0000
	DEFW	  #0038
;-------------------------------;
A_INSTALL:
	LD	A,USE_BANK_1
	CALL	OOUT
	LD	HL,A?_MAP
	LD	DE,A_MAP
	LD	BC,#1300
	LDIR 
	CALL	OOUT10
;-------
	LD	DE,A_REND_LN
	LD	HL,A_IT1
	LD	BC,#4006
	CALL	MOVES
	DEC	HL
	LD	DE,A_R_01
	CALL	EXIT_1
;-------
	LD	DE,A_GEN_RAYZ
	LD	HL,A_IT2
	LD	BC,#000F
	CALL	MOVES
	DEC	HL
	DEC	HL
	LD	(HL),#C9
;-------
	LD	HL,A_GEN_LIGH
	LD	DE,A_LIGH_VOL
	LD	C,#26
A_I32	LD	B,#08
A_I31	LD	(HL),#E1
	INC	HL
	LD	(HL),#22
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	E
	DJNZ	A_I31
	LD	E,#00
	INC	D
	DEC	C
	JR	NZ,A_I32
	LD	DE,A_GENL1
	CALL	EXIT_1
;-------
	LD	HL,A_SRL_TAB
A_I41	LD	A,L
	RRCA 
	RRCA 
	RRCA 
	RRCA 
	AND	#0F
	LD	(HL),A
	INC	L
	JR	NZ,A_I41
;-------
	LD	H,T_SIN/#100
	LD	DE,A_RAYZ
	LD	C,#09
	CALL	A_I51
	LD	C,#06
	CALL	A_I51
	LD	C,#08
	CALL	A_I51
	LD	C,#05
	CALL	A_I51
;-------
	LD	HL,A_VOLZ
	LD	D,#B0
	LD	C,#00
A_I72	LD	E,D
	LD	B,#10
A_I71	LD	A,E
	CP	#80
	JR	C,$+2+2
	LD	A,#7F
	CP	#70
	JR	NC,$+2+2
	LD	A,#70
	SUB	#70
	SRL	A
	ADD	A,A_C2P_T
	LD	(HL),A
	DEC	E
	INC	HL
	DJNZ	A_I71
A_I73	LD	A,#80
	ADD	A,#80
	LD	(A_I73+1),A
	JR	NZ,$+2+1
	DEC	D
	DEC	C
	JR	NZ,A_I72
;-------
	LD	LX,#28
	CALL	A_POSA_1
	DEC	LX
	JR	NZ,$-2-3
;-------
	LD	A,#88
	LD	(C2P_SPR),A
	LD	LX,A_C2P_T
	LD	DE,A_B_SCR
	LD	BC,#0040
	CALL	C2P_INS
	JP	C2P_IAD
;-------
A_I51	LD	A,(HL)
	SRL	A
	SRL	A
	LD	(DE),A
	LD	A,L
	ADD	A,C
	LD	L,A
	INC	E
	JR	NZ,A_I51
	INC	D
	RET 
;-------
A_IT1	POP	DE		;10
	LD	L,E		;4
	LD	E,(HL)		;7
	LD	A,(DE)		;7
	LD	(BC),A		;7
	INC	C		;4	;39
;-------
A_IT2	LD	A,(BC)	;7
	INC	C	;4
	ADD	A,(HL)	;7
	INC	L	;4
	EX	DE,HL	;4
	ADD	A,(HL)	;7
	INC	L	;4
	EXX		;4
	ADD	A,(HL)	;7
	INC	L	;4
	LD	C,A	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	EXX		;4	;78
;-------------------------------;
A?_INSTALL:
	LD	A,#2C
	LD	LY,#C0
	CALL	Z_MAIN
	LD	DE,#8000
	LD	H,#C0-#13
A_I10	LD	L,#80-#40
	LD	BC,#0080
	LDIR 
	INC	H
	DEC	A
	JR	NZ,A_I10
	LD	A,USE_BANK_1
	CALL	OOUT
	LD	HL,#8000
	LD	DE,A?_MAP
	LD	BC,#1300
	LDIR 
	RET 
;-------------------------------Z------------------------------;
Z_MAIN	LD	(Z_T00+1),HL
	LD	(Z_X00+1),A
	CALL	OOUT10
	LD	HL,#0000
	LD	(T_V_D1+1),HL
	LD	HL,#4000
	LD	(T_V_D2+1),HL
	LD	HL,#8000
	LD	BC,#7FFF
	LD	A,C
	CALL	FILL
;---
	LD	B,#3F
Z_I02	PUSH	BC
Z_T00	LD	HL,#2121
	LD	A,(HL)
	INC	HL
	LD	(Z_T00+1),HL
Z_X00	LD	LY,A		;#6F LD	 ;#2C INC
;--
	LD	BC,#8000
T_V_D1	LD	DE,#0000
	INC	E
	INC	E
	INC	E
	INC	DE
	LD	(T_V_D1+1),DE
T_V_D2	LD	HL,#4000
	DEC	H
	LD	(T_V_D2+1),HL
T_V_C1	LD	A,H
	LD	(BC),A
	ADD	HL,DE
	INC	C
	BIT	7,C
	JP	Z,T_V_C1
;---
	LD	BC,T_SIN
	LD	IX,T_SIN+#40
Z_I01	LD	H,#80
	LD	A,(BC)
	LD	L,A
	SRL	L
	LD	E,(HL)
	LD	L,(IX+0)
	SRL	L
	LD	D,(HL)
	SLA	E
	SET	7,D
;-
	LD	A,C
	LD	(DE),A
	INC	E
	LD	A,LY
	LD	(DE),A
;-
	INC	LX
	INC	C
	JR	NZ,Z_I01
	POP	BC
	DJNZ	Z_I02
;-------
	LD	LX,#02
Z_I22	LD	HL,#8100
Z_I20	INC	L
	LD	A,(HL)
	CP	#FF
	JR	NZ,Z_I21
	INC	H
	LD	D,(HL)
	DEC	L
	LD	E,(HL)
	DEC	H
	LD	(HL),E
	INC	L
	LD	(HL),D
Z_I21	INC	HL
	BIT	7,H
	JR	NZ,Z_I20
	DEC	LX
	JR	NZ,Z_I22
	RET 
;--------------------------------------------------------------;
V_BLANK:DI
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
	CALL	M_MAIN
;-
	LD	A,#7F
	IN	A,(#FE)
	BIT	0,A
	JP	Z,EXIT
;-
	POP	AF
	POP	BC
	POP	DE
	POP	HL
	EI 
	RET 
;-------
M_MAIN:
M_C01	LD	A,#7F
	INC	A
	CP	#05
	JR	C,$+2+1
	SUB	A
	LD	(M_C01+1),A
	JR	NZ,M_C02
M_C03	LD	A,#0F
	INC	A
	LD	(M_C03+1),A
	CP	#10
	JR	C,M_C04
	SUB	A
	LD	(M_C03+1),A
M_C05	LD	HL,M_PDAT
	LD	A,(HL)
	INC	HL
	LD	(M_C05+1),HL
	LD	L,A
	LD	H,#00
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,M_PATS
	ADD	HL,DE
	LD	(M_C06+1),HL
	JR	M_C07
M_C04	LD	L,A
	LD	H,#00
M_C06	LD	DE,#1111
	ADD	HL,DE
M_C07	LD	A,(HL)
	ADD	A,A
	ADD	A,A
	LD	L,A
	ADD	A,A
	ADD	A,A
	ADD	A,L
	LD	L,A
	LD	H,#00
	LD	DE,M_SMPL0
	ADD	HL,DE
	JR	$+2+3
M_C02	LD	HL,#2121
	LD	A,(HL)
	INC	HL
	LD	(M_OUT_T+#09),A
	LD	A,(HL)
	INC	HL
	LD	(M_OUT_T+#03),A
	LD	A,(HL)
	INC	HL
	LD	(M_OUT_T+#02),A
	LD	A,(HL)
	AND	#0F
	LD	(M_OUT_T+#06),A
	LD	A,(HL)
	AND	#F0
	RRCA 
	RRCA 
	RRCA 
	OR	#28
	LD	(M_OUT_T+#07),A
	INC	HL
	LD	(M_C02+1),HL
	LD	HL,M_OUT_T+#09
	LD	A,#09
	JP	M_OOUTI
;-------
M_SMPL0	DEFB	  #00,#00,#00,#90 ;nop	  0-0
	DEFB	  #00,#00,#00,#90
	DEFB	  #00,#00,#00,#90
	DEFB	  #00,#00,#00,#90
	DEFB	  #00,#00,#00,#90
	DEFB	  #0E,#02,#6F,#0F ;bum	  2-1
	DEFB	  #0F,#02,#EF,#80
	DEFB	  #0D,#04,#EF,#80
	DEFB	  #0C,#06,#EF,#80
	DEFB	  #0B,#08,#EF,#80
	DEFB	  #0F,#01,#6F,#04 ;bumpss 6-2
	DEFB	  #0E,#01,#EF,#05
	DEFB	  #0D,#02,#6F,#05
	DEFB	  #0C,#02,#EF,#04
	DEFB	  #0B,#03,#6F,#02
	DEFB	  #0D,#00,#09,#00 ;pss	  8-3
	DEFB	  #0A,#00,#00,#10
	DEFB	  #06,#00,#00,#10
	DEFB	  #00,#00,#00,#10
	DEFB	  #00,#00,#00,#10
	DEFB	  #0F,#01,#E9,#04 ;psssss C-4
	DEFB	  #0F,#02,#1B,#02
	DEFB	  #0F,#02,#4D,#02
	DEFB	  #0E,#02,#7F,#01
	DEFB	  #0C,#00,#00,#12
	DEFB	  #0C,#00,#00,#12 ;psssss C-5 add
	DEFB	  #0C,#00,#00,#12
	DEFB	  #0C,#00,#00,#12
	DEFB	  #0C,#00,#00,#12
	DEFB	  #0B,#00,#00,#12
;-------
M_INS:	LD	HL,M_OUT_T+#0D
	LD	A,#0D
M_OOUTI	LD	C,#FD
	LD	DE,#FFBF
	LD	B,D
	OUT	(C),A
	LD	B,E
	OUTD 
	DEC	A
	JP	P,$-1-2-1-2-1
	RET 
M_OUT_T	DEFB	  #04,#08,#00,#00,#05,#08
	DEFB	  #00,#2A
	DEFB	  #1F,#00,#1F
	DEFB	  #40,#00,#0A
M_WAIT:	LD	A,(M_C03+1)
	OR	A
	RET	Z
	JR	M_WAIT
;-------
M_PDAT	DEFB	  #7,#8
	DEFB	  #5,#6,#5,#6,#5,#6,#5,#6	  ;credit
	DEFB	  #4,#4
	DEFB	  #0,#0,#0,#0,#0,#0,#0,#3	  ;rayz
	DEFB	  #1,#2,#1,#2,#1,#2,#1,#3	  ;turn
	DEFB	  #D,#E,#D,#E,#D,#E,#D,#F	  ;stretch1
	DEFB	  #10,#11,#10,#12,#10,#11,#10,#13 ;voxel
	DEFB	  #A,#B,#A,#B,#A,#B,#A,#C	  ;rotate
	DEFB	  #0,#0,#0,#0,#0,#0,#0,#3	  ;plazma
	DEFB	  #10,#11,#10,#12,#10,#11,#10,#13 ;stretch2
	DEFB	  #A,#B,#A,#B,#A,#B,#A,#C	  ;bump
	DEFB	  #1,#2,#1,#2,#1,#2,#1,#3	  ;scaling
	DEFB	  #D,#E,#D,#E,#D,#E,#D,#F	  ;tunnel
	DEFB	  #9,#9
M_PATS	DEFB	  1,3,1,3,4,5,5,2,3,2,1,3,4,5,1,3	  ;0

	DEFB	  1,3,1,3,4,5,3,4,1,3,1,3,4,3,1,3	  ;1
	DEFB	  1,3,1,3,4,5,3,4,3,2,1,3,4,3,1,3	  ;2
	DEFB	  1,3,1,3,4,5,1,4,5,1,4,5,4,5,4,5	  ;3

	DEFB	  1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0	  ;4

	DEFB	  4,5,3,0,0,0,3,0,0,0,3,0,0,0,3,0	  ;5
	DEFB	  0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,3	  ;6
	DEFB	  0,0,3,0,0,0,0,0,0,0,3,0,0,0,0,0	  ;7
	DEFB	  0,0,3,0,0,0,3,0,0,0,3,0,3,0,3,3	  ;8
	DEFB	  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5	  ;9
;-
	DEFB	  1,0,1,3,2,0,1,2,1,3,1,0,4,5,2,2	  ;A
	DEFB	  1,0,1,3,4,5,1,2,1,2,1,0,4,5,1,0	  ;B
	DEFB	  1,0,1,3,4,5,1,0,1,0,3,3,3,3,3,3	  ;C
;-
	DEFB	  1,3,1,3,4,5,1,2,3,2,1,3,4,5,1,3	  ;D
	DEFB	  1,3,1,3,4,5,1,2,3,2,1,3,4,5,1,2	  ;E
	DEFB	  1,3,1,3,4,5,1,2,3,2,1,3,2,2,2,2	  ;F
;-
	DEFB	  1,0,3,3,3,0,1,0,2,0,1,0,3,0,1,0	  ;10
	DEFB	  1,0,2,0,1,0,3,0,2,0,1,0,3,0,3,0	  ;11
	DEFB	  1,0,2,0,1,0,3,0,2,0,1,0,2,0,2,0	  ;12
	DEFB	  1,0,2,0,1,0,3,0,2,0,0,0,0,0,0,0	  ;13
;-------
CL_T_COLL:
	DEFB	  #4D	  ;rayz
	DEFB	  #46	  ;turn
	DEFB	  #4B	  ;stretch1
	DEFB	  #44	  ;voxel
	DEFB	  #4C	  ;rotare
	DEFB	  #56	  ;plazma
	DEFB	  #44	  ;stretch2
	DEFB	  #4F	  ;bump
	DEFB	  #46	  ;scaling
	DEFB	  #55	  ;tunnel
	DEFB	  #07
;--------------------------------------------------------------;
C2P_TPOS1	EQU #6000
C2P_SPR1	EQU #60C0
C2P_TPOS2	EQU #6100
C2P_SPR2	EQU #61C0
;-------
C2P_:
C2P_1	LD	A,#00
	ADD	A,#80
	LD	(C2P_1+1),A
B_ADD1	LD	HL,#0000
	JR	NZ,$+2+2
BLUR_ON	LD	H,#14
	LD	(C2P_AD1),HL
   CALL	HHALT
	JR	NZ,C2P_C00
	LD	HL,C2P_TPOS2
	CALL	C2P_LNZ
	LD	HL,C2P_SPR1
	CALL	C2P_MOV
	LD	HL,C2P_TPOS1
	JR	C2P_LNZ
C2P_C00:LD	HL,C2P_TPOS1
	CALL	C2P_LNZ
	LD	HL,C2P_SPR2
	CALL	C2P_MOV
	LD	HL,C2P_TPOS2
;-------
C2P_LNZ:LD	(C2P_SP1+1),HL
	LD	(C2P_SP2+1),SP
	LD	A,#26
C2P_SP1	LD	SP,#3131
	POP	HL
	POP	DE
	LD	(C2P_SP1+1),SP
C2P_AD1	NOP 
	NOP 
	LD	SP,HL
	DUP   #20
	POP	HL
	LDI 
	EDUP 
	DEC	A
	JP	NZ,C2P_SP1
C2P_SP2	LD	SP,#3131
	RET 
C2P_MOV:LD	(C2P_SP3+1),SP
	LD	SP,HL
C2P_MOVE DEFS	  #80
C2P_SP3	LD	SP,#3131
	RET 
;-------
C2P_INS	EXX 
	LD	HL,C2P_MOVE
	LD	D,LX
	LD	C,#08
C2P_I02	LD	E,LX
	LD	B,#04
C2P_I01	LD	(HL),#E1
	INC	HL
	LD	(HL),#22
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	E
	DJNZ	C2P_I01
	INC	D
	DEC	C
	JR	NZ,C2P_I02
	EXX 
	LD	HL,C2P_TPOS1
	LD	A,#26
	CALL	C2P_I20
;--
	LD	DE,C2P_SPR1
	LD	HL,C2P_SPR
	LD	B,H
	LD	C,L
	CALL	C2P_I32
	LD	DE,C2P_SPR2
	LD	B,H
	LD	C,L
C2P_I32	LD	HX,#08
C2P_I31	LD	LX,#08
	LD	A,(HL)
	INC	HL
	AND	#0F
	LD	LY,A
	PUSH	BC
C2P_I30	LD	A,(BC)
	INC	BC
	AND	#F0
	OR	LY
	LD	(DE),A
	INC	E
	DEC	LX
	JR	NZ,C2P_I30
	POP	BC
	DEC	HX
	JR	NZ,C2P_I31
	RET 
C2P_IAD	HALT 
	LD	A,(C2P_1+1)
	OR	A
	LD	HL,C2P_SPR1
	JR	Z,$+2+3
	LD	HL,C2P_SPR2
	JP	C2P_MOV
C2P_SPR:DEFB	  #88,#88,#AA,#AA,#EE,#EE,#FF,#FF
	DEFB	  #00,#22,#22,#AA,#AA,#BB,#BB,#FF
;-------
C2P_I20:LD	(HL),E
	INC	L
	LD	(HL),D
	INC	H
	LD	(HL),D
	DEC	L
	LD	(HL),E
	DEC	H
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	INC	L
	INC	L
	INC	L
	INC	L
	DEC	A
	JR	NZ,C2P_I20
	RET 
;--------------------------------------------------------------;
INSTALL:
;-------
	LD	HL,T_SIN+#7F
	LD	DE,T_SIN+#81
	LD	A,(HL)
	LD	(DE),A
	DEC	L
	INC	E
	JR	NZ,$-2-2
;-------
	LD	HL,#6200
	LD	A,#63
	LD	(HL),A
	INC	L
	JR	NZ,$-2
	INC	H
	LD	(HL),A
	LD	A,#C3
	LD	(#6363),A
	LD	HL,V_BLANK
	LD	(#6364),HL
	LD	A,#62
	LD	I,A
	IM	2
;-------
	LD	HL,C2P_TPOS1
	LD	DE,#4040
	LD	B,#13
C2P_I10	INC	L
	INC	L
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	INC	L
	INC	L
	LD	(HL),E
	INC	L
	LD	A,D
	ADD	A,#04
	LD	(HL),A
	INC	L
	LD	A,E
	ADD	A,#20
	LD	E,A
	JR	NC,$+2+4
	LD	A,D
	ADD	A,#08
	LD	D,A
	DJNZ	C2P_I10
	LD	HL,C2P_TPOS1
	LD	DE,C2P_TPOS2
	LD	B,#26
C2P_I11	INC	L
	INC	L
	INC	E
	INC	E
	LD	A,(HL)
	LD	(DE),A
	INC	L
	INC	E
	LD	A,(HL)
	ADD	A,#02
	LD	(DE),A
	INC	L
	INC	E
	DJNZ	C2P_I11
;-------

;-------
	SUB	A
	OUT	(#FE),A
	CALL	CL_SCR
	JP	M_INS
;-------
EXIT_1:	LD	(HL),#C3
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	RET 
EXIT_2:	LD	(HL),#DD
	INC	HL
	LD	(HL),#E9
	RET 
OOUT10:	LD	A,#10
OOUT:	LD	BC,#7FFD
	OUT	(C),A
	RET 
HHALT:	EI 
	HALT 
	DI 
	RET 
FILL:	LD	D,H
	LD	E,L
	INC	DE
	LD	(HL),A
	LDIR 
	RET 
MOVES:	LD	A,B
	LD	B,#00
	PUSH	HL
	PUSH	BC
	LDIR 
	POP	BC
	POP	HL
	DEC	A
	JR	NZ,$-1-1-1-2-1-1
	EX	DE,HL
	RET 
SIN:	LD	(SIN_SP1+1),SP
	DI 
	LD	SP,HL
	POP	BC
	POP	HL
	POP	DE
	PUSH	DE
	BIT	7,B
	JR	Z,$+2+3+3+1
	LD	A,E
	CPL 
	LD	E,A
	LD	A,D
	CPL 
	LD	D,A
	INC	DE
	ADD	HL,DE
	PUSH	HL
	ADD	HL,BC
	PUSH	HL
	LD	A,H
SIN_SP1	LD	SP,#3131
	EI 
	RET 
;-------
Y_:	EXX 
CL_TC1	LD	HL,CL_T_COLL
	LD	A,(HL)
	INC	HL
	LD	(CL_TC1+1),HL
	CALL	FILATTR
	EXX 
;-
	LD	(Y_CD+1),HL
Y_C1	PUSH	BC
Y_CD	CALL	#CDCD
	POP	BC
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,Y_C1
;-------
	EI 
CL_SCR:	LD	HL,#5AFF
	LD	DE,#5AFE
	LD	BC,#1B00
	LD	(HL),C
	LDDR 
	RET 
FILATTR	LD	HL,#5840
	LD	BC,#025F
	JP	FILL
;-------
	ORG	#6400
T_SIN	DEFB	  #FF,#FF,#FF,#FF,#FE,#FE,#FE,#FD
	DEFB	  #FD,#FC,#FB,#FA,#FA,#F9,#F8,#F6
	DEFB	  #F5,#F4,#F3,#F1,#F0,#EE,#ED,#EB
	DEFB	  #EA,#E8,#E6,#E4,#E2,#E0,#DE,#DC
	DEFB	  #DA,#D7,#D5,#D3,#D0,#CE,#CB,#C9
	DEFB	  #C6,#C4,#C1,#BE,#BC,#B9,#B6,#B3
	DEFB	  #B0,#AD,#AA,#A7,#A5,#A2,#9E,#9B
	DEFB	  #98,#95,#92,#8F,#8C,#89,#86,#83
	DEFB	  #80,#7C,#79,#76,#73,#70,#6D,#6A
	DEFB	  #67,#64,#61,#5D,#5A,#58,#55,#52
	DEFB	  #4F,#4C,#49,#46,#43,#41,#3E,#3B
	DEFB	  #39,#36,#34,#31,#2F,#2C,#2A,#28
	DEFB	  #25,#23,#21,#1F,#1D,#1B,#19,#17
	DEFB	  #15,#14,#12,#11,#0F,#0E,#0C,#0B
	DEFB	  #0A,#09,#07,#06,#05,#05,#04,#03
	DEFB	  #02,#02,#01,#01,#01,#00,#00,#00
;-------
	ORG	#6500
