/* ball.h - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BALL_H
#define _BALL_H

#include "crap_image.h"

typedef struct ScreenCoord {
  int x,y;
} ScreenCoord;

typedef struct WorldCoord {
  float x,y,z;
} WorldCoord;

typedef struct ViewCoord {
  float x,y,z;
} ViewCoord;

typedef struct {
  int n_coords;
  ViewCoord* view_coords;
  ScreenCoord* screen_coords;
  WorldCoord* world_coords;
  Palette palette;
  Image background_image;

  float ball_x_pos, ball_y_pos;
} Ball_data;

Ball_data* create_fx_ball ( Image* dest, int n_coords );
void fx_ball ( Image* dest, Ball_data* data, int ball_visible, int distort_ball );

#endif /* _BALL_H */

