/* crap_font.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "crap_image.h"
#include "crap_png.h"
#include "crap_video.h"
#include "crap_font.h"
#include "crap_file.h"

Prop_font*
crap_blockfont_load ( Image* source_image, int block_count,     
		      int block_width, int block_height,
		      int horiz_blocks, int vert_blocks, 
		      int chars, int* block_encoding, 
		      uint8* map_string )  
{
  Prop_font* pfont;
  int i;
  int bx, by;
  int x, y;
  Image* block_images;
  int block_nr;
  uint8 c;
  
  pfont = (Prop_font*) malloc ( sizeof(Prop_font) );
  block_images = (Image*) malloc ( sizeof(Image) * block_count );

  /* create blocks */
  for ( i = 0; i < block_count; i++ )
    {
      crap_image_subimage ( source_image, &block_images[i],
			    (block_width+1) * i, 0, block_width, block_height );
    }
  
  /* this really ought to be an occasion to check for memory requirements ;-) */
  pfont->image = crap_image_create ( block_width * horiz_blocks * chars, block_height * vert_blocks );
  
  for ( i = 0; i < chars; i++ )
    {
      c = *map_string++;

      for ( by = 0; by < vert_blocks; by++ )
	for ( bx = 0; bx < horiz_blocks; bx++ )
	  {
	    block_nr = *block_encoding++;
	    x = i * block_width * horiz_blocks  +  bx * block_width;
	    y = by * block_height;
	    
	    crap_image_blit ( pfont->image, x, y, &block_images[block_nr] );
	  }
      pfont->char_offset_map[c] = i * block_width * horiz_blocks;
      pfont->char_width_map[c] = horiz_blocks * block_width;
    }

  pfont->char_height = vert_blocks * block_height;
  pfont->char_max_width = horiz_blocks * block_width;

  return pfont;
}

void crap_pfont_blit_character ( Prop_font* pfont, uint8* dest_buf, int dest_stride, uint8 character )
{
  int y;
  uint8* src_buf;
  int width;
  int src_stride;
  
  src_buf = &pfont->image->buffer[ pfont->char_offset_map[ character ] ];
    
  width = pfont->char_width_map[ character ];
  src_stride = pfont->image->width;

  for (y = 0; y < pfont->char_height; y++)
    {
      memcpy ( dest_buf, src_buf, width );
      src_buf += src_stride;
      dest_buf += dest_stride;
    }
}

void crap_pfont_string ( Prop_font* pfont, Image* image, int x, int y, uint8* string )
{
  uint8* dest_buffer;
  int stride = image->width;
  uint8 c;
  int char_width;

  if (( y < 0 ) || ( y > image->height - pfont->char_height ))
    return;

  dest_buffer = image->buffer + y*image->width;
  while ( (c = *string++) )
    {
      char_width = pfont->char_width_map [ c ] + 1;
      
      if (( x >= 0 ) && ( x <= image->width - char_width ))
	{
	  crap_pfont_blit_character ( pfont, dest_buffer + x, stride, c );
	}
      x += char_width;
    }
}

int
crap_pfont_string_width ( Prop_font* pfont, uint8* string )
{
  uint8 c;
  int width;

  width = 0;
  while ( (c = *string++) )
    {
      width += ( pfont->char_width_map [ c ] + 1 );
    }

  return width;
}

int
crap_pfont_get_height ( Prop_font* pfont )
{
  return pfont->char_height;
}

int
crap_pfont_get_max_width ( Prop_font* pfont )
{
  return pfont->char_max_width;
}

