/* crap_font.h - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _CRAP_FONT_H
#define _CRAP_FONT_H

#include "crap_image.h"

/* proportional font */
typedef struct {
  int char_height;
  int char_width_map[256];
  int char_offset_map[256];
  int char_max_width;
  Image* image;
} Prop_font;

Prop_font*
crap_blockfont_load ( Image* source_image, /* image holding the
                                              buildingblocks */
		      int block_count,     /* ..of which there are
                                              block_count in number */
		      int block_width,
		      int block_height,    /* ..with these sizes each */
		      
		      int horiz_blocks,
		      int vert_blocks,     /* a character consist of
                                              this much blocks */
		      int chars,           /* amount of chars */
		      int* block_encoding, /* list of encodings */
		      uint8* map_string ); /* ABCDEFG.. */
     
void crap_pfont_string ( Prop_font* pfont, Image* image, int x, int y, uint8* string );

int crap_pfont_string_width ( Prop_font* pfont, uint8* string );
int crap_pfont_get_height ( Prop_font* pfont );
int crap_pfont_get_max_width ( Prop_font* pfont );

#endif /* _CRAP_FONT_H */
