/* crap_image.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "crap_image.h"
#include "crap_png.h"
#include "crap_video.h"

Image* crap_image_create ( uint32 width, uint32 height )
{
  Image* i;
  i = (Image*) malloc ( sizeof(Image) );

  i->width = width;
  i->height = height;
  i->stride = width;

  if ( width * height > 0 )
    i->buffer = (uint8*) malloc ( sizeof(uint8) * width * height );
  else
    i->buffer = NULL;

  return i;
}

/* memory leak? */
void
crap_image_copy ( Image* dest, Image* src )
{
  dest->width = src->width;
  dest->height = src->height;
  dest->stride = src->width;
  
  if ( dest->width * dest->height > 0 )
    dest->buffer = (uint8*) malloc ( sizeof(uint8) * dest->width * dest->height );
  else
    dest->buffer = NULL;

  crap_image_blit ( dest, 0, 0, src );
}
     
void
crap_image_destroy ( Image* image )
{
  if ( image )
    {
      if ( image->buffer )
	free ( image->buffer );
      free ( image );
    }
}

void
crap_image_fill ( Image* image, uint8 color )
{
  int i;
  uint8* buf = image->buffer;
  
  for ( i = 0; i < image->height; i++ )
    {
      memset ( buf, color, image->width );
      buf += image->stride;
    }
}

void
crap_image_rect_fill ( Image* image, uint8 color, int x0, int y0, int w, int h )
{
  int y;
  uint8* buf = image->buffer;

  if (( y0 > image->height ) || ( x0 > image->width ) || ( w <= 0 ) || ( h <= 0 ))
    return;

  if ( y0 + h > image->height )
    h = image->height - y0;
  if ( x0 + w > image->width )
    w = image->width - x0;
  
  buf += x0 + y0 * image->stride;

  for ( y = 0; y < h; y++ )
    {
      memset ( buf, color, w );
      buf += image->stride;
    }
}

/* the child subimage will be set up to be a window in the root image */
void
crap_image_subimage ( Image* root, Image* subimage, int x, int y, int w, int h )
{
  subimage->buffer = root->buffer + y * root->stride + x;
  
  subimage->width = w;
  subimage->height = h;
  subimage->stride = root->stride;
}

void
crap_image_load ( Image* image, char* filename )
{
  Palette palette;
  crap_png_load ( image, &palette, filename );
}

void crap_image_blit ( Image* dest, int x, int y, Image* src )
{
  void *src_buffer = src->buffer;
  void *dest_buffer = dest->buffer;
  int src_stride;
  int dest_stride;
  int width;
  int height;
  int i;

  dest_stride = dest->stride;
  src_stride = src->stride;
  width = src->width;
  height = src->height;

  if (( x < -src->width ) || ( y < -src->height )
      || ( x > dest->width ) || ( y > dest->height ))
    return;
  
  if ( x < 0 )
    {
      src_buffer += (-x);
      width -= (-x);
      x = 0;
    }
  else if ( x + src->width > dest->width )
    {
      width -= (x + src->width - dest->width);
    }
  
  if ( y < 0)
    {
      src_buffer += (-y)*src->width;
      height -= (-y);
      y = 0;
    }
  else if ( y + src->height > dest->height )
    {
      height -= (y + src->height - dest->height);
    }

  dest_buffer += y * dest->stride + x;

  for ( i = 0; i < height; i++ )
    {
      memcpy ( dest_buffer, src_buffer, width );
      src_buffer += src_stride;
      dest_buffer += dest_stride;
    }
}

void crap_setpalette ( Palette* p, int from, int n_colors )
{
  int i;
  uint8 palette[768];
  uint8* palptr = palette;
  
  for ( i = 0; i < n_colors; i++ )
    {
      *palptr++ = (uint8) p->color[i].r;
      *palptr++ = (uint8) p->color[i].g;
      *palptr++ = (uint8) p->color[i].b;
    }
  crap_video_setcolors ( from, n_colors, palette );
}
