/* crap_image.h - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _CRAP_IMAGE
#define _CRAP_IMAGE

#include "crap_types.h"

typedef struct {
  int x, y;
  int width, height;
} Rectangle;

typedef struct {
  uint32 r;
  uint32 g;
  uint32 b;
} Color;

typedef struct {
  int width,height;
  uint32 stride;
  uint8* buffer;
} Image;

typedef struct {
  Color* color;
} Palette;

Image* crap_image_create ( uint32 width, uint32 height );
void crap_image_destroy ( Image* image );

void crap_image_rect_fill ( Image* image, uint8 color, int x0, int y0, int w, int h );
void crap_image_fill ( Image* image, uint8 color );
void crap_image_load ( Image* image, char* filename );

void crap_image_copy ( Image* dest, Image* src );

void crap_setpalette ( Palette* palette, int from, int n_colors );
void crap_image_subimage ( Image* root, Image* subimage, int x, int y, int w, int h );

void crap_image_blit ( Image* dest, int x, int y, Image* src );

#endif /* _CRAP_IMAGE_H */
