/* crap_video.h - 
   Copyright (C) 2000 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of crapstation, a collection of demobuilder tools.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __CRAP_VIDEO_H
#define __CRAP_VIDEO_H

#include "crap_image.h"

#define CRAP_KEY_NONE 0
#define CRAP_KEY_ESCAPE 1

int crap_video_init( uint32 width, uint32 height );
void crap_video_done();

Image* crap_video_root_image();

int crap_video_get_width();
int crap_video_get_height();
int crap_video_get_bpp();

void crap_video_blit ( Image* root_image );
void crap_video_blit_from_partial_image ( Image* i );
void crap_video_waitretrace();

void crap_video_bar ( uint8* buffer, int x0, int y0, int w, int h, uint8 color );
void crap_video_setcolor ( uint8 color, uint8 r, uint8 g, uint8 b );
void crap_video_setcolors ( uint8 color, int length, uint8* palette );
void crap_video_fade ( float amount, uint8 color, int length, uint8* palette );

int crap_video_keypress();
int crap_video_getkey();

void crap_video_set_directbuffering ( int bool );

void crap_video_timerbar( int color );

#endif /* __CRAP_VIDEO_H */
