/* credits.c - stock penguin animation
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "credits.h"
#include "crap_video.h"
#include "crap_mod.h"
#include "crap_font.h"
#include "crap_png.h"

#define MAJOR_AVOOZL  1
#define MAJOR_SMOKE   2
#define MAJOR_FLOPPI  3

Image credits_image;
Palette credits_palette;

Image subimage_codegfxmusic;
Image subimage_avoozl;
Image subimage_smoke;
Image subimage_floppi;

int max_height, max_width; /* maximal image size */

Credits_data* create_fx_credits ( Image* dest )
{
  Credits_data* data;
  
  data = (Credits_data*) malloc ( sizeof(Credits_data) );
  data->first_step = 1;

  crap_png_load ( &credits_image, &credits_palette, "credits.png" );
  crap_image_subimage ( &credits_image, &subimage_codegfxmusic, 0, 80, 106, 24 );
  crap_image_subimage ( &credits_image, &subimage_avoozl, 80, 0, 80, 60 );
  crap_image_subimage ( &credits_image, &subimage_smoke, 160, 0, 80, 60 );
  crap_image_subimage ( &credits_image, &subimage_floppi, 240, 0, 80, 60 );

  max_width = 80;
  max_height = 60;
  
  return data;
}

void fx_credits ( Image* dest, Credits_data* data )
{
  int fader, major;
  static int col = 0;
  static int majorcol = 0;
  int c;
  int mod_row;
  int i;
  int x,y;

  if ( data->first_step == 1 )
    {
      crap_image_fill(dest, 0);
      crap_image_blit ( dest, 30, dest->height - (subimage_codegfxmusic.height*3/2),
			&subimage_codegfxmusic );
      data->first_step = 0;
    }

  /* swing to the beat */
  mod_row = crap_mod_get_patpos() + 4;
  fader = mod_row & 15;
  major = mod_row >> 4;
  if (major<3)
    {
      if (majorcol<63) majorcol+=4;
    }
  if (major>3)
    {
      if (majorcol>0) majorcol-=4;
    }
  
  if (fader<8)
  {
     if (col<63) col+=3;
  }
  if (fader>=8)
  {
     if (col>0) col-=3;
  }

  x = 220;
  y = dest->height-27;
  
  crap_image_rect_fill ( dest, 0,
			 x - max_width/2, y - max_height/2,
			 max_width, max_height );
  switch ( major )
    {
    case MAJOR_AVOOZL:
      crap_image_blit ( dest,
			x - subimage_avoozl.width/2,
			y - subimage_avoozl.height/2,
			&subimage_avoozl );
      break;
    case MAJOR_SMOKE:
      crap_image_blit ( dest,
			x - subimage_avoozl.width/2,
			y - subimage_avoozl.height/2,
			&subimage_smoke );
      break;
    case MAJOR_FLOPPI:
      crap_image_blit ( dest,
			x - subimage_avoozl.width/2,
			y - subimage_avoozl.height/2,
			&subimage_floppi );
      break;
    }

  for ( i = 224; i < 229; i++ )
    {
      crap_video_setcolor( i,
			   ( col * credits_palette.color[i].r ) >> 6,
			   ( col * credits_palette.color[i].g ) >> 6,
			   ( col * credits_palette.color[i].b ) >> 6 );
    }

  /* code */
  if ((major==MAJOR_AVOOZL) || (major==MAJOR_SMOKE)) c = col; else c = 0;
  crap_video_setcolor( 232, (majorcol * (c>>1))>>6,
		       (majorcol * (10+(c>>1)))>>6,
		       (majorcol * (20+(c>>1)))>>6 );

  /* music */
  if (major==MAJOR_FLOPPI) c = col; else c = 0;  
  crap_video_setcolor( 234, (majorcol * (c>>1))>>6,
		       (majorcol * (10+(c>>1)))>>6,
		       (majorcol * (20+(c>>1)))>>6 );


  /* graphics */
  if (major==MAJOR_SMOKE) c = col; else c = 0;
  crap_video_setcolor( 236, (majorcol * (c>>1))>>6,
		       (majorcol * (10+(c>>1)))>>6,
		       (majorcol * (20+(c>>1)))>>6 );



}
