#include <math.h>
#include <malloc.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <wgt5.h>
#include <pr.h>

#ifdef __3DFX__
#include <glide.h>
#endif

#include "demo.h"


/* Modified from Phred's Bump */

#define XLIGHT 256
#define YLIGHT 256
#define XMLIGHT 255
#define YMLIGHT 255
#define XHLIGHT 127
#define YHLIGHT 127

void CalcLightSource (unsigned char *light);
void BumpLight (unsigned char *dest, PR_DWORD lx, PR_DWORD ly,
                unsigned char *light);
block part6_dest;
unsigned char *bumpx;
unsigned char *bumpy;

unsigned char *lightsource;
unsigned char *bumpmap;
PR_REAL p6_angle, p6_angle2;
color p6pal[256];



void CalcLightSource (unsigned char *light)
/* calculates the light source map */
{
  int   i,j;
  float dist, tx, ty;

  for (i = 0; i < XLIGHT; i++)
    for (j = 0; j < YLIGHT; j++)
    {
      tx = i - XHLIGHT;
      ty = j - YHLIGHT;
      dist = sqrt(tx*tx + ty*ty);
      if (dist < 96)
        light[i*XLIGHT+j] = (63 - (dist*0.66)) + 1;
      else
        light[i*XLIGHT+j] = 1;
      if (light[i*XLIGHT+j] < 1)
        light[i*XLIGHT+j] = 1;
    }
}



void PrecalcBump (unsigned char *bump)
{
int x, y;

int middle;
int top;
int bottom;
int left;
int right;
int dx, dy;

  memset (bumpx, 0, 320*200);
  memset (bumpy, 0, 320*200);

  for (x = 1; x < 319; x++)
   for (y = 1; y < 198; y++)
     {

      middle = bump[y*320 + x];
      left   = ((int)bump[y*320 + x - 1] - middle);
      right  = ((int)bump[y*320 + x + 1] - middle);
      top    = ((int)bump[y*320 + x - 320] - middle);
      bottom = ((int)bump[y*320 + x + 320] - middle);
      dx  = (left - right) >> 1;
      dy  = (top - bottom) >> 1;

      bumpx[y*320 + x] = dx;
      bumpy[y*320 + x] = dy;
     }
}



void BumpLight (unsigned char *dest, PR_DWORD lx, PR_DWORD ly,
                unsigned char *light)
{
unsigned char *blutx, *bluty;

PR_DWORD lx1, ly1, lx2, ly2;
PR_DWORD dx, dy;
PR_DWORD dx1, dx2, dy1, dy2;
PR_DWORD sofs;
PR_DWORD tx;
PR_DWORD slx, sly, x, y;
PR_DWORD tlx, tly;

  lx1 = lx - 127;
  ly1 = ly - 127;
  lx2 = lx + 127;
  ly2 = ly + 127;
  slx = lx1;
  sly = ly1;
  if (lx1 < 1)   { slx = lx1; lx1 = 1; }
  if (lx1 > 318) return;
  if (ly1 < 1)   { sly = ly1; ly1 = 1; }
  if (ly1 > 198) return;

  if (lx2 > 318) lx2 = 318;
  if (lx2 < 1)   return;
  if (ly2 > 198) ly2 = 198;
  if (ly2 < 1)   return;

  y = ly1;
  sofs = ly1 * 320;

  while (y < ly2)
  {
    x = lx1;
    sofs += lx1;
    tlx = x - slx;
    tly = y - sly;

    blutx = &bumpx[sofs];
    bluty = &bumpy[sofs];

    while (x++ < lx2)
    {
      dx = *(blutx++);
      dy = *(bluty++);

      *(dest + sofs++) =
         light[(((tly+dy) & YMLIGHT) << 8)+(((tlx++)+dx) & XMLIGHT)];
    }
    tly++;
    sofs += (320-lx2);
    y++;
  }
}





void Part6 (void)
{
PR_OBJECT *platform_shape;
PR_OBJECT *light_shape;
PR_ENTITY *platform_entity;
PR_ENTITY *light_entity;

PR_REAL platx = -90, platy = 0, platz = 0;
PR_DWORD past_ticks;

PR_REAL spin = -1.8;            /* Camera sine wave parameter */
PR_REAL spin2 = -2.2;           /* Second camera sine wave parameter */
PR_REAL spincos, spinsin;       /* Sine wave movement pattern vars */
PR_REAL bounce;
PR_REAL lightx, lightz;

PR_DWORD x, y;
PR_DWORD bumptex;
PR_DWORD i;
PR_REAL spinz = 0;

  wnormscreen ();
  wcls (0);
  fading = 0;
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  /* -------------- Load objects ----------------- */

  light_shape = LoadFile ("bmplight.pro");
  platform_shape = LoadFile ("platform.pro");

  /* -------------- Initialize Entities ----------- */

  platform_entity = PR_CreateEntity (platform_shape, "Blue Platform");
  PR_ScaleEntity (platform_entity, 1, 1, 1);
  PR_PositionEntity (platform_entity, 0, 0, 0);

  light_entity = PR_CreateEntity (light_shape, "Bump light");
  PR_ScaleEntity (light_entity, 0.1, 0.1, 0.1);
  PR_PositionEntity (light_entity, 0, 0, 0);

  /* -------------- Misc Setup ----------- */


  ticks = 0;
  userlights.NumLights = 1;     /* This sets how many lights are actually used */
  PR_SetLightType (&userlights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&userlights, 0, 1.0);
  PR_AmbientLight = 256;
  PR_SetLightPosition (&userlights, 0,
                       -200, 15000, -500);

  bumptex = PR_FindTexture ("bumpdum.pcx");

  lightsource = malloc (XLIGHT*YLIGHT);
  bumpmap = wloadpcx ("bumpkos.pcx", p6pal);
  bumpx = malloc (320 * 200);
  bumpy = malloc (320 * 200);

  CalcLightSource (lightsource);
  p6_angle = 0;
  PrecalcBump (bumpmap + 4);

  for (i = 0; i < 30; i++)
    {
     lightx = (sin(p6_angle + p6_angle2)*100);
     lightz = (cos(2*p6_angle + sin(p6_angle2))*80);

     x = 159 + lightx;
     y = 99 + lightz;

     BumpLight (PR_WorldTextures[bumptex].image + 4, x, y, lightsource);

     p6_angle += 3.141592 / 256.0 * 6;
     p6_angle2 += 0.02;
    }


  /* -------------- Loop ----------- */

  while (CheckSongPosition (0x2E, 60))
    {
     PR_OpenScreen (PR_BACKBUFFER);
     past_ticks = ticks;
     ticks = 0;

     /* -------------- Animation Parameters ----------- */

     spinz += past_ticks * 0.5;                /* Light spin */
     spin += past_ticks * 0.0047;              /* Camera var 1 */
     spin2 += past_ticks * 0.015;              /* Camera var 2 */
     spinsin = sin (spin + spin2) * 2800;
     spincos = cos (spin + sin(spin2)) * 2800;
     bounce = sin (spin2) * 800;

     lightx = (sin(p6_angle + p6_angle2)*100);
     lightz = (cos(2*p6_angle + sin(p6_angle2))*80);

     x = 159 + lightx;
     y = 99 + lightz;

     lightx = (lightx * -11);
     lightz *= 14;

     /* -------------- 3D Parameters ----------- */
     PR_SetCameraSource (newcam, spinsin + 100, 400 + bounce, spincos);
     PR_SetCameraTarget (newcam, 0, -500, 0);
     PR_SetActiveCamera (newcam);


     PR_PositionEntity (light_entity, lightx, -500, lightz);

     /* -------------- Bump Map ----------- */

     BumpLight (PR_WorldTextures[bumptex].image + 4, x, y, lightsource);

     p6_angle += 3.141592 / 256.0 * 3;
     p6_angle2 += 0.01;

     /* -------------- Render Normal Frame ----------- */

     PR_NewFrame ();
     wsetcolor (0);
     PRGFX_ClearScreen ();
     PR_AddLightsToScene (&userlights);


     PR_RotateEntity (platform_entity, platx, platy, platz);
     PR_TransformEntity (platform_entity);
     PR_RenderEntity (platform_entity);

     PR_RotateEntity (light_entity, spinz, 0, 0);
     PR_TransformEntity (light_entity);
     PR_RenderEntity (light_entity);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_Flip ();
    }


  PR_FreeObject (platform_shape);
  PR_FreeEntity (platform_entity);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();

  free (lightsource);
  free (bumpmap);
  free (bumpx);
  free (bumpy);

  PR_AmbientLight = 0;
}



