;------------------------------------------------------------------------------
;                    Suprise Coding Entry from Synopsis
;------------------------------------------------------------------------------


;Uncomment this if the Floating Point doesn't work correctly
nop5	     equ     1

;255 for 256 Color version
;200 for a much nicer version
        Iteration =     200


MODEL TINY

DATASEG

MS		STRUC
	Scale	DD	?
	MandelX DD	?
	Mandely DD	?
	Two	DD	?
	X	DD	?
	Y	DD	?
	temp	DD	?
	State	DW	?
MS		ENDS

	Data	DD    0.01
		DD    2.0	     ;left y point of mandel
		DD    1.0	     ;left x point of mandel
		DB    2

	Mandel	MS	<?>


CODESEG

		org	100h

;Uncomment the next for 8086/80286 version (filesize will be larger!)
.386

Main:
		mov	al,13h
		int	10h

		mov	bp,offset Data

		xor	di,di

LoopX:		mov	ax,di
		xor	dx,dx
		mov	cx,320
		div	cx
		xchg	ax,bx		;BX=Y, DX=X

		push	ds
		pop	es

		push	di
		mov	di,offset Data+MS.Two+1
		xor	ax,ax		;CX=320
		rep	stosb
		pop	di

		push	0a000h
		pop	es

		mov	cl,Iteration
LoopIt:
ifdef nop5
		db	0dbh,0e3h		;finit without wait ;)
endif
		fld	dword ptr [bp+MS.X]	;st = Old X

		call	SqrXY
		fsubr	st,st(1)		;st = st-st(1), st =oldx^2-oldy^2

		mov	word ptr [bp+MS.temp],dx ;+X
		xor	si,si
		call	CalcXY
		lodsw				;SI=SI+4
		lodsw

		fld	dword ptr [bp+MS.Y]	;st = y
		fmul	st,st(3)		;st = st*st(3)=Old X
		fimul	dword ptr [bp+MS.Two]	;st = oldx * oldy *2

		mov	word ptr [bp+MS.temp],bx ;+Y
		call	CalcXY
		call	SqrXY

		fadd	st,st(1)

		fsqrt				;st = st^1/2
		ficom	dword ptr [bp+MS.Two]	;st = st-2
		fstsw	word ptr [bp+MS.State]

		mov	ah,byte ptr [bp+MS.State+1]
		sahf
		ja	EndIt
		loop	LoopIt
EndIt:		xor	ax,ax
		sub	ax,cx
		stosb

		cmp	di,64000
		jb	LoopX

		cbw			;Wait for Key
		int	16h
		mov	ax,3		;Textmode
		int	10h
		ret			;Exit



CalcXY: 	fild	[bp+MS.temp]		;st=x or y on screen
		fmul	[bp+MS.Scale]		;st=st*Scale
		fadd	st,st(1)		;st=st+st(1)
		fsub	dword ptr [bp+si+MS.MandelX]	;sub MandelX
		fstp	dword ptr [bp+si+MS.X]	;Save to X or Y
		ret



SqrXY:		fld	dword ptr [bp+MS.x]	;st = x, st(1)=st
		fmul	dword ptr [bp+MS.x]	;st = st* x
		fld	dword ptr [bp+MS.Y]	;st = y ,st(1)= x^2
		fmul	dword ptr [bp+MS.Y]	;st = st * y = y^2
		ret

END		Main

