/****************************************************************************
** JiNX 2D Graphics System V1.0  (C) 1996-98 MJ Hodson AKA DeepThroat/JiNX **
****************************************************************************/

// VBE Function 4F00h structure (J2D_ControllerInfo)

typedef _Packed struct {
        char            VbeSignature[4];
        unsigned char   VbeVersionMinor;
        unsigned char   VbeVersionMajor;
        char *          OemStringPtr;
        unsigned int    Capabilities;
        short *         VideoModePtr;
        unsigned short  TotalMemory;

        unsigned char   OemSoftwareRevMinor;
        unsigned char   OemSoftwareRevMajor;
        char *          OemVendorNamePtr;
        char *          OemProductNamePtr;
        char *          OemProductRevPtr;

        char            Reserved[222];

        char            OemData[256];
} J2D_ControllerInfo;

// VBE Function 4F01h structure (J2D_ModeInfo)

typedef _Packed struct {
        unsigned short  ModeAttributes;
        unsigned char   WinAAttributes;
        unsigned char   WinBAttributes;
        unsigned short  WinGranularity;
        unsigned short  WinSize;
        unsigned short  WinASegment;
        unsigned short  WinBSegment;
        void *          WinFuncPtr;
        unsigned short  BytesPerScanLine;

        unsigned short  XResolution;
        unsigned short  YResolution;
        unsigned char   XCharSize;
        unsigned char   YCharSize;
        unsigned char   NumberOfPlanes;
        unsigned char   BitsPerPixel;
        unsigned char   NumberOfBanks;
        unsigned char   MemoryModel;
        unsigned char   BankSize;
        unsigned char   NumberOfImagePages;
        char            Padding;

        unsigned char   RedMaskSize;
        unsigned char   RedFieldPosition;
        unsigned char   GreenMaskSize;
        unsigned char   GreenFieldPosition;
        unsigned char   BlueMaskSize;
        unsigned char   BlueFieldPosition;
        unsigned char   RsvdMaskSize;
        unsigned char   RsvdFieldPosition;
        unsigned char   DirectColorModeInfo;

        unsigned int    PhysBasePtr;
        unsigned int    OffScreenMemOffset;
        unsigned short  OffScreenMemSize;

        char            Reserved[206];
} J2D_ModeInfo;


// Actual Routine Prototypes ////////////////////////////////////////////////

// All interface routines return the following (signed char) :
//      0  => Function succeeded

//      1  => Function call failed                      (standard VESA error)
//      2  => Function not supported in current config  (         "         )
//      3  => Function invalid in current video mode    (         "         )

//      16 => VESA not supported (GetControllerInfo)     (user defined error)
//      17 => Mode not supported (GetGraphicsMode)       (        "         )
//      18 => Out of memory (Compatibility attempt)      (        "         )

//      24 => Function failure due to DPMI service error

extern char *J2D_ErrorString[];

// Initialisation routines
char J2D_MakeWorkspace(void);
char J2D_KillWorkspace(void);

// Information Routines
char J2D_GetControllerInfo(J2D_ControllerInfo *info);
char J2D_GetGraphicsMode(J2D_ModeInfo *info, int x_size, int y_size, int type);
#define J2D_8BIT        0
#define J2D_24BIT       1

char J2D_Compatibility(void);

// Set Mode Routines
void J2D_DisableLFB(void);
void J2D_SetMode(void);

// Hardware Screen Size and Display Start Routines
char J2D_SetScanlineWidth(short pixels_per_scanline);
char J2D_SetDisplayWindow(short x_coord, short y_coord);

// Palette Routines (palette in 1K RGB/ format)
char J2D_SetPalette6bit(char *palette);

// Virtual Screen Clearing/Updating Routines ////////////////////////////////
void J2D_SetVirtualScreenSize(int vsc_x_size, int vsc_y_size);

// All 256c modes
void J2D_Clear256c(char *vsc, char colour);
void J2D_Copy256c(char *vsc_destination, char *vsc_source);
void J2D_Update256c(char *vsc, int offset_x, int offset_y);

// All 16Mc modes
void J2D_Clear16Mc(char *vsc, char red, char green, char blue);
void J2D_Copy16Mc(char *vsc_destination, char *vsc_source);
void J2D_Update16Mc(char *vsc, int offset_x, int offset_y);

// Virtual Screen Format Conversion Routines ////////////////////////////////

void J2D_ConvertDepth24to8(char *vsc24bit, char *vsc8bit, int number_of_pixels);
void J2D_ScaleSize256c(char *source, int source_x, int source_y,
                       char *dest, int dest_x, int dest_y);

// Some common routines from the old JiNX EI package ////////////////////////

void J2D_TextMode(void);
void J2D_WaitRetrace(void);


