/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

#include "demo.h"

/*
	particle.c
*/

vect3_t vectZero = {0.0f, 0.0f, 0.0f};

void updatePsys(int psysNum, GLfloat dTime)
{
	double timefrac;
	int i;
	psystem_tp psys = &(psystems[psysNum]);

	psystemAnimate(psysNum, dTime);

	if(psys->newtime==psys->oldtime)
		return;
	if(psys->newtime<=script.curtime)
	{
		for(i=0;i<3;i++)
		{
			psys->pos[i] = psys->new_pos[i];
			psys->old_pos[i] = psys->pos[i];
		}
		return;
	}

	timefrac = (script.curtime - psys->oldtime) / (psys->newtime - psys->oldtime);

	for(i=0;i<3;i++)
		psys->pos[i] = (psys->new_pos[i] - psys->old_pos[i]) * timefrac + psys->old_pos[i];
}

void particleRender(int psysNum, int pNum)
{
	GLfloat box[4];
	GLfloat poly[4];
	particle_tp particle;
	psystem_tp psys;

	psys = &(psystems[psysNum]);
	particle = &(psys->parts[pNum]);

	box[0] = ((unsigned int)(particle->pType % 4)) * 0.25f;
	box[1] = ((unsigned int)(particle->pType / 4)) / 4.0f;
	box[2] = box[0] + 0.25f;
	box[3] = box[1] + 0.25f;

	poly[0] = -1.0f * particle->scale;
	poly[1] = -1.0f * particle->scale;
	poly[2] =  1.0f * particle->scale;
	poly[3] =  1.0f * particle->scale;

	glPushMatrix();
		glTranslatef(particle->pos[0]+psys->pos[0],
					 particle->pos[1]+psys->pos[1],
					 particle->pos[2]+psys->pos[2]);
		glRotatef(viewport.rot[1]/DEGTORAD, 0.0f, 1.0f, 0.0f);
		glRotatef(viewport.rot[0]/DEGTORAD, 1.0f, 0.0f, 0.0f);
		glColor4f(1-(particle->timer / psys->life),1-(particle->timer / psys->life),
				  1-(particle->timer / psys->life),1-(particle->timer / psys->life));
		glBegin(GL_QUADS);
			glTexCoord2f(box[0], box[1]);
			glVertex2f(poly[0], poly[3]);
			glTexCoord2f(box[0], box[3]);
			glVertex2f(poly[0], poly[1]);
			glTexCoord2f(box[2], box[3]);
			glVertex2f(poly[2], poly[1]);
			glTexCoord2f(box[2], box[1]);
			glVertex2f(poly[2], poly[3]);
		glEnd();
	glPopMatrix();
}
/*
void psystemAdd(int teType, vect3_t ipos, vect3_t fpos, vect3_t param2, int spawn, GLfloat randomness, GLfloat life)
{
	int i;
	psystem_tp psys;

	for(i=0;i<10;i++)
	{
		if(!psystems[i].inuse)
		{
			psys = &psystems[i];
			break;
		}
	}

	if(i==10)
		return;

	cpVect(psys->ipos, ipos);
	cpVect(psys->fpos, fpos);

	psys->inuse = 1;
	psys->active = 0;
	for(i=0;i<MAX_PARTICLES;i++)
		psys->parts[i].inuse = 0;
		
	switch(teType)
	{
	case PE_FIREBALL:
		cpVect(psys->ivel, param2);
		vectSet(psys->acc, 0.0f, 0.0f, 0.0f);
		psys->diminish = 1;
		psys->iscale = 3.0f;
		break;
	case PE_SPRAY:
		cpVect(psys->ivel, param2);
		vectSet(psys->acc, 0.0f, -3.0f, 0.0f);
		psys->diminish = 1;
		psys->iscale = 3.0f;
		break;
	case PE_CYCLONE:
		cpVect(psys->ivel, param2);
		vectSet(psys->acc, 0.0f, 0.0f, 0.0f);
		psys->diminish = 1;
		psys->iscale = 3.0f;
		break;
	}
	psys->spawn = spawn;
	psys->num = 0;
	psys->front = 0;
	psys->ftime = 60000;
	psys->timer = 0;
	psys->time = 0;
	psys->life = life;

	psys->randomness = randomness;

	psys->peType = teType;

}
*/
void psystemRemove(int psysnum)
{
	psystems[psysnum].inuse = 0;
}

void psystemAnimate(int psysnum, GLfloat deltaTime)
{
	int i;
	GLfloat timefrac;
	psystem_tp psys = &psystems[psysnum];

	if(psys->num!=0)
	{
		for(i=0;i<MAX_PARTICLES;i++)
		{
			if(psys->parts[i].inuse)
				particleAnimate(i, psysnum, deltaTime);
		}
	}
	else if(psys->spawn==0)
	{
		psystems[psysnum].active = 0;
		psystems[psysnum].inuse = 0;
		num_psys--;
		return;
	}
	
	if(psys->peType < PE_EXP1)
	{
		psys->timer += deltaTime;
		psys->time  += deltaTime;

		if(psys->spawn != 0)
			while(psys->timer > (1000 / psys->spawn))
			{
				particleAdd(psys);
				psys->timer -= 1000 / psys->spawn;
			}
	}
	else
	{
		for(i=0;i<psys->spawn;i++)
			particleAdd(psys);
		psys->spawn = 0;
	}

	if(psys->newtime==psys->oldtime)
	{
		return;
	}
	if(psys->newtime<=script.curtime)
	{
		for(i=0;i<3;i++)
		{
			psys->pos[i] = psys->new_pos[i];
			psys->old_pos[i] = psys->pos[i];
		}
		psys->oldtime=psys->oldtime;
		return;
	}

	timefrac = (script.curtime - psys->oldtime) / (psys->newtime - psys->oldtime);

	for(i=0;i<3;i++)
		psys->pos[i] = (psys->new_pos[i] - psys->old_pos[i]) * timefrac + psys->old_pos[i];
}

void particleAnimate(int pnum, int psysnum, GLfloat deltaTime)
{
	int i;
	GLfloat d, store;
	vect3_t temp;
	particle_tp p;
	psystem_tp psys;

	psys = &psystems[psysnum];
	p = &psys->parts[pnum];

	p->timer += deltaTime;
	if(p->timer > psys->life)
	{
		particleRemove(p, psys);
		return;
	}

	switch(psys->peType)
	{
	case PE_CYCLONE:
	case PE_FSPARKS:
		store = p->pos[1];
		p->pos[1] = 0.0f;
		d = vectDist(vectZero, p->pos);
		d += p->vel[0] * deltaTime/200.0f;
		p->extra += p->vel[2];
		p->vel[2] *= 0.99f;
		while(p->extra>(2*PI))
			p->extra -= (2*PI);
		while(p->extra<(-2*PI))
			p->extra += (2*PI);
		vectSet(temp, cos(p->extra), 0.0f, sin(p->extra));
		vectScale(temp, d);
		cpVect(p->pos, temp);
		p->pos[1] = store + p->vel[1] * deltaTime/200.0f;
		break;
	case PE_EXP1:
		for(i=0;i<3;i++)
		{
			p->vel[i]+=psys->acc[i]*deltaTime/200.0f;
			p->pos[i]+=p->vel[i]*deltaTime/200.0f;
		}
		break;
	default:
		for(i=0;i<3;i++)
		{
			p->vel[i]+=psys->acc[i]*deltaTime/200.0f;
			p->pos[i]+=p->vel[i]*deltaTime/200.0f;
		}
		break;
	}

}

void particleAdd(psystem_tp psys)
{
	int newParticle, i;
	GLfloat magnitude;
	vect3_t v;
	if(psys->num == MAX_PARTICLES)
		return;
	
	vectSet(v, 0.0f, 0.0f, 0.0f);

	newParticle = 0;
	while(( psys->parts[newParticle].inuse) && (newParticle < MAX_PARTICLES) )
		newParticle++;

	if( (psys->parts[newParticle].inuse) || (newParticle==MAX_PARTICLES) )
		return;

	psys->parts[newParticle].inuse = 1;
	psys->parts[newParticle].timer = 0.0;
	psys->parts[newParticle].scale = psys->scale;

	magnitude = vectDist(v, psys->ivel);

	switch(psys->peType)
	{
	case PE_FIREBALL:
		psys->parts[newParticle].pType = P_FIRE_BRIGHT;
		for(i=0;i<3;i++)
		{
			psys->parts[newParticle].pos[i] = (((GLfloat)rand() / RAND_MAX) - 0.5f) * psys->parts[newParticle].scale;
			psys->parts[newParticle].vel[i] = psys->ivel[i] + (((GLfloat)rand() / RAND_MAX) - 0.5f)*2.0f * psys->randomness * magnitude;
		}
		break;
	case PE_SPRAY:
		psys->parts[newParticle].pType = (int) ((GLfloat) rand() * 11.0f / RAND_MAX);
		for(i=0;i<3;i++)
		{
			psys->parts[newParticle].pos[i] = 0.0f;
			psys->parts[newParticle].vel[i] = psys->ivel[i] + (((GLfloat)rand() / RAND_MAX) - 0.5f)*
						2.0f * psys->randomness * magnitude;
		}
		break;
	case PE_SPARKS:
		psys->parts[newParticle].pType = P_ORANGE;
		for(i=0;i<3;i++)
		{
			psys->parts[newParticle].pos[i] = 0.0f;
			psys->parts[newParticle].vel[i] = psys->ivel[i] + (((GLfloat)rand() / RAND_MAX) - 0.5f)*
						2.0f * psys->randomness * magnitude;
		}
		break;
	case PE_CYCLONE:
		psys->parts[newParticle].pType = (int) ((GLfloat) rand() * 11.0f / RAND_MAX);
		cpVect(psys->parts[newParticle].pos, vectZero);
		psys->parts[newParticle].vel[0] = psys->randomness * (GLfloat)rand() / 
						RAND_MAX * psys->ivel[0] / 2 + psys->ivel[0];
		psys->parts[newParticle].vel[1] = psys->randomness * (GLfloat)rand() / 
						RAND_MAX * psys->ivel[1] / 2 + psys->ivel[1];
		psys->parts[newParticle].vel[2] = psys->randomness * (GLfloat)rand() /
						RAND_MAX * psys->ivel[2] * 2 + psys->ivel[2];
		psys->parts[newParticle].extra = (GLfloat)(rand()) / (GLfloat)(RAND_MAX) * 2.0f*PI;
		break;
	case PE_FSPARKS:
		psys->parts[newParticle].pType = P_FIRE_BRIGHT;
		for(i=0;i<3;i++)
		{
			psys->parts[newParticle].pos[i] = 0.0f;
			psys->parts[newParticle].vel[i] = psys->ivel[i] + (((GLfloat)rand() / RAND_MAX) - 0.5f)*
						2.0f * psys->randomness * magnitude;
		}
		break;
	case PE_EXP1:
		psys->parts[newParticle].pType = P_FIRE_BRIGHT;
		for(i=0;i<3;i++)
		{
			psys->parts[newParticle].pos[i] = 0.0f;
			psys->parts[newParticle].vel[i] = psys->ivel[i] + (((GLfloat)rand() / RAND_MAX) - 0.5f)*
						2.0f * psys->randomness * magnitude;
		}
		break;
	}

//	if(psys->num < MAX_PARTICLES)
		psys->num++;
}

void particleRemove(particle_tp p, psystem_tp psys)
{
	p->inuse = 0;
	psys->num--;
}
