/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

#include "demo.h"

void treeAdd(int psysNum, int pNum)
{
	node_tp newNode;
	node_tp nextNode, lastNode;
	GLfloat sinPitch, cosYaw, cosPitch, sinYaw;
	vect3_t newPos;
	psystem_tp psys;
	particle_tp p;
	int i;

	psys = &(psystems[psysNum]);
	p = &(psys->parts[pNum]);

	sinPitch = sin(-viewport.rot[0]);
	cosPitch = cos(-viewport.rot[0]);
	sinYaw = sin(-viewport.rot[1]);
	cosYaw = cos(-viewport.rot[1]);

	for(i=0;i<3;i++)
		newPos[i] = viewport.pos[i] - (psys->pos[i] + p->pos[i]);

	newPos[2] = newPos[0] * (-sinYaw) + newPos[2] * cosYaw;
	newPos[2] = newPos[1] * sinPitch + newPos[2] * cosPitch;

	newNode = malloc(sizeof(node_t));
	newNode->psysNum = psysNum;
	newNode->pNum = pNum;
	newNode->zval = newPos[2];
	newNode->left = NULL;
	newNode->right = NULL;

	if(treeRoot==NULL)
	{
		treeRoot = newNode;
		return;
	}

	lastNode = NULL;
	nextNode = treeRoot;
	while(nextNode)
	{
		lastNode = nextNode;
		if(newNode->zval < nextNode->zval)
			nextNode = nextNode->left;
		else
			nextNode = nextNode->right;
	}

	if(newNode->zval < lastNode->zval)
		lastNode->left = newNode;
	else
		lastNode->right = newNode;

}

void treeRender(node_tp node)
{
	if(node==NULL)
		return;
	if(node->right!=NULL)
		treeRender(node->right);

	particleRender(node->psysNum, node->pNum);

	if(node->left!=NULL)
		treeRender(node->left);

	free(node);
	if(node == treeRoot)
		treeRoot = NULL;
	return;
}
