/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

#include "demo.h"

void loadHM(char filename[], model_t *model)
{
	FILE *file;
	vect3_t v_scale;
	float newval;
	data_t data;
	int i, j;

	file = fopen(filename, "rb");
	if(!file)
	{
		return;
	}

	fread(&(model->version), sizeof(unsigned char), 1, file);
	fread(&(model->flags), sizeof(unsigned char), 1, file);
	fread(model->v_max, sizeof(vect3_t), 1, file);
	fread(model->v_min, sizeof(vect3_t), 1, file);
	fread(&(model->num_vert), sizeof(unsigned short int), 1, file);
	fread(&(model->num_tri), sizeof(unsigned short int), 1, file);
	fread(&(model->num_norm), sizeof(unsigned short int), 1, file);
	fread(&(model->num_tex), sizeof(unsigned short int), 1, file);

		/* TRIANGLE DATA */
	if(model->num_tri > 0)
	{
		model->tris = malloc(sizeof(tri_t) * model->num_tri);
		fread(model->tris, sizeof(tri_t), model->num_tri, file);
	}

		/* TEXTURE DATA */
	if(model->num_tex > 0)
		{
		data.new_tex = malloc(sizeof(int2_t) * model->num_tex);
		model->tex = malloc(sizeof(vect2_t) * model->num_tex);
		fread(data.new_tex, sizeof(int2_t), model->num_tex, file);
	}

		/* NORMAL DATA */
	if(model->num_norm > 0)
	{
		data.new_norm = malloc(sizeof(int3_t) * model->num_norm);
		model->norms = malloc(sizeof(vect3_t) * model->num_norm);
		fread(data.new_norm, sizeof(int3_t), model->num_norm, file);
	}

		/* VERTEX DATA */
	if(model->num_vert > 0)
	{
		data.new_vert = malloc(sizeof(int3_t) * model->num_vert);
		model->verts = malloc(sizeof(vect3_t) * model->num_vert);
		fread(data.new_vert, sizeof(int3_t), model->num_vert, file);
		model->light = malloc(sizeof(vect3_t) * model->num_vert);
	}

	for(i=0;i<3;i++)
	{
		if(model->v_max[i] == model->v_min[i])
		{
			v_scale[i] = 0;
			continue;
		}
		v_scale[i] = 65500.0f / (model->v_max[i] - model->v_min[i]);
	}

	for(i=0;i<model->num_vert;i++)
	{
		for(j=0;j<3;j++)
		{
			newval = data.new_vert[i][j] / v_scale[j] + model->v_min[j];
			model->verts[i][j] = newval;
		}
	}
	for(i=0;i<model->num_norm;i++)
	{
		for(j=0;j<3;j++)
		{
			newval = data.new_norm[i][j] / 32700.0f - 1.0f;
			model->norms[i][j] = newval;
		}
	}
	for(i=0;i<model->num_tex;i++)
	{
		for(j=0;j<2;j++)
		{
			newval = data.new_tex[i][j] / 32700.0f - 1.0f;
			model->tex[i][j] = newval;
		}
	}

	for(i=0;i<3;i++)
	{
		model->pos[i]     = 0.0f;	model->rot[i]     = 0.0f;
		model->old_pos[i] = 0.0f;	model->old_rot[i] = 0.0f;
		model->new_pos[i] = 0.0f;	model->new_rot[i] = 0.0f;
	}
}

void drawHM(model_t *model)
{
	int i,j;
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, model->tex_id);

	glPushMatrix();
		glTranslatef(model->pos[0],
					model->pos[1],
					model->pos[2]);
		glRotatef(model->rot[0],1,0,0);
		glRotatef(model->rot[1],0,1,0);
		glRotatef(model->rot[2],0,0,1);
		glColor4f(0.5f,0.5f,0.5f,1.0f);
		glBegin(GL_TRIANGLES);
			for(i=0;i<model->num_tri;i++)
				for(j=0;j<3;j++)
				{
					if(model->tex_id)
						glTexCoord2f(model->tex[model->tris[i].tex[j]][0]*model->tex_tile, 
										 model->tex[model->tris[i].tex[j]][1]*model->tex_tile);
					if(model->lit)
						glColor4f(model->light[model->tris[i].norm[j]][0],
							model->light[model->tris[i].norm[j]][1],
							model->light[model->tris[i].norm[j]][2],1.0f);
					else
						glColor4f(1.0,1.0,1.0,1.0);
					glVertex3fv(model->verts[model->tris[i].coord[j]]);
				}
		glEnd();
	glPopMatrix();
}
	/* Update position and rotation based on old & new values 
		and the timeframe specified in the script */
void updateHM(model_t *model)
{
	double timefrac;
	int i;

	if((model->lit==2) || (dLight))
	{
		lightHM(model);
		dModelL = 1;
	}

	if(model->newtime==model->oldtime)
	{
		if(model->lit)
			model->lit = 1;
		return;
	}
	if(model->newtime<=script.curtime)
	{
		for(i=0;i<3;i++)
		{
			model->pos[i] = model->new_pos[i];
			model->rot[i] = model->new_rot[i];	
			model->old_pos[i] = model->pos[i];
			model->old_rot[i] = model->rot[i];
		}
		model->oldtime=model->oldtime;
		if(model->lit)
			model->lit = 1;
		return;
	}

	timefrac = (script.curtime - model->oldtime) / (model->newtime - model->oldtime);

	for(i=0;i<3;i++)
	{
		model->pos[i] = (model->new_pos[i] - model->old_pos[i]) * timefrac + model->old_pos[i];
		model->rot[i] = (model->new_rot[i] - model->old_rot[i]) * timefrac + model->old_rot[i];
	}
}

void lightHM(model_t *model)
{
	int i,j,k;
	vect3_t light, lightrot, lightcol;
	vect3_t newcol, newpos, temppos;
	vect3_t norm, newnorm;
	GLfloat d, mag;

	for(j=0;j<num_light;j++)
	{
		cpVect(lightcol, lights[j].col);

		if((lightcol[0]<=0.1) && (lightcol[1]<=0.1) && (lightcol[2]<=0.1))
			continue;
		if ( lights[j].type == LITE_PARALLEL)  /* PARALLEL LIGHTING */
		{
			cpVect(light, lights[j].pos);

				/* rotate light to model */
			/*x*/
			if(model->rot[0] != 0)
			{
				lightrot[0] = light[0];
				lightrot[1] = light[1] *  cos(-model->rot[0]*DEGTORAD) - light[2] * sin(-model->rot[0]*DEGTORAD);
				lightrot[2] = light[1] *  sin(-model->rot[0]*DEGTORAD) + light[2] * cos(-model->rot[0]*DEGTORAD);
			}
			else cpVect(lightrot,light);
		
			/*y*/
			if(model->rot[1] != 0)
			{
				light[0] = lightrot[0] *  cos(-model->rot[1]*DEGTORAD) + lightrot[2] * sin(-model->rot[1]*DEGTORAD);
				light[1] = lightrot[1];
				light[2] = lightrot[0] * -sin(-model->rot[1]*DEGTORAD) + lightrot[2] * cos(-model->rot[1]*DEGTORAD);
			}
			else cpVect(light,lightrot);
		
			/*z*/
			if(model->rot[2] != 0)
			{
				lightrot[0] = light[0] *  cos(-model->rot[2]*DEGTORAD) - light[1] * sin(-model->rot[2]*DEGTORAD);
				lightrot[1] = light[0] *  sin(-model->rot[2]*DEGTORAD) + light[1] * cos(-model->rot[2]*DEGTORAD);
				lightrot[2] = light[2];
				cpVect(light,lightrot);
			}

				/* Normalize light vector */
			d = sqrt(light[0]*light[0]+light[1]*light[1]+light[2]*light[2]);
			light[0] /= d; light[1] /= d; light[2] /= d;

			for(i=0;i<model->num_vert;i++)
			{
				newcol[0] = dotprod(model->norms[i], light);
				if(newcol[0] < 0.0)
					newcol[0] = 0.0;
				if(newcol[0] > 1)
					newcol[0] = 1;
				newcol[1] = newcol[0] * lightcol[1];
				newcol[2] = newcol[0] * lightcol[2];
				newcol[0] *= lightcol[0];
				if(j==0)
					cpVect(model->light[i],newcol);
				else
				{
					model->light[i][0] += newcol[0];
					model->light[i][1] += newcol[1];
					model->light[i][2] += newcol[2];
				}
			}

		}
		else		/* OMNI LIGHTING */
		{
			for(i=0;i<model->num_vert;i++)
			{
				cpVect(newpos, model->verts[i]);
				cpVect(norm, model->norms[i]);
					/* rotate vertex and normal w/ model */
				/*x*/
				if(model->rot[0] != 0)
				{
					temppos[0] = newpos[0];
					temppos[1] = newpos[1] *  cos(model->rot[0]*DEGTORAD) - newpos[2] * sin(model->rot[0]*DEGTORAD);
					temppos[2] = newpos[1] *  sin(model->rot[0]*DEGTORAD) + newpos[2] * cos(model->rot[0]*DEGTORAD);
					newnorm[0] = norm[0];
					newnorm[1] = norm[1] *  cos(model->rot[0]*DEGTORAD) - norm[2] * sin(model->rot[0]*DEGTORAD);
					newnorm[2] = norm[1] *  sin(model->rot[0]*DEGTORAD) + norm[2] * cos(model->rot[0]*DEGTORAD);
				}
				else { cpVect(temppos,newpos); cpVect(newnorm,norm); }
			
				/*y*/
				if(model->rot[1] != 0)
				{
					newpos[0] = temppos[0] *  cos(model->rot[1]*DEGTORAD) + temppos[2] * sin(model->rot[1]*DEGTORAD);
					newpos[1] = temppos[1];
					newpos[2] = temppos[0] * -sin(model->rot[1]*DEGTORAD) + temppos[2] * cos(model->rot[1]*DEGTORAD);
					norm[0] = newnorm[0] *  cos(model->rot[1]*DEGTORAD) + newnorm[2] * sin(model->rot[1]*DEGTORAD);
					norm[1] = newnorm[1];
					norm[2] = newnorm[0] * -sin(model->rot[1]*DEGTORAD) + newnorm[2] * cos(model->rot[1]*DEGTORAD);
				}
				else { cpVect(newpos,temppos); cpVect(norm, newnorm); }

				/*z*/
				if(model->rot[2] != 0)
				{
					temppos[0] = newpos[0] *  cos(model->rot[2]*DEGTORAD) - newpos[1] * sin(model->rot[2]*DEGTORAD);
					temppos[1] = newpos[0] *  sin(model->rot[2]*DEGTORAD) + newpos[1] * cos(model->rot[2]*DEGTORAD);
					temppos[2] = newpos[2];
					cpVect(newpos,temppos);
					newnorm[0] = norm[0] *  cos(model->rot[2]*DEGTORAD) - norm[1] * sin(model->rot[2]*DEGTORAD);
					newnorm[1] = norm[0] *  sin(model->rot[2]*DEGTORAD) + norm[1] * cos(model->rot[2]*DEGTORAD);
					newnorm[2] = norm[2];
					cpVect(norm,newnorm);
				}

					/* Find light -> vertex vector */
				for(k=0;k<3;k++)
					light[k] = lights[j].pos[k] - (newpos[k] + model->pos[k]);

					/* Normalize Normal */
				d = sqrt(norm[0]*norm[0]+norm[1]*norm[1]+norm[2]*norm[2]);
				if(d!=0)
					norm[0] /= d; norm[1] /= d; norm[2] /= d;
					/* Normalize light vector */
				d = sqrt(light[0]*light[0]+light[1]*light[1]+light[2]*light[2]);
				if(d!=0)
					light[0] /= d; light[1] /= d; light[2] /= d;
					/* d remains the magnitude */

					/* calculate light */
				mag = (d*d)/lights[j].falloff;
				newcol[0] = dotprod(norm, light);
				newcol[1] = newcol[0] * lightcol[1] / mag;
				newcol[2] = newcol[0] * lightcol[2] / mag;
				newcol[0] *= lightcol[0] / mag;
				for(k=0;k<3;k++)
				{
//					if((lightcol[k]>=1.0))
//						newcol[k] = lightcol[k] / d;
					if(newcol[k]>1.0)
						newcol[k]=1.0;
					if(newcol[k]<0.0)
						newcol[k]=0.0;
				}
				if(j==0)
					cpVect(model->light[i],newcol);
				else
				{
					model->light[i][0] += newcol[0];
					model->light[i][1] += newcol[1];
					model->light[i][2] += newcol[2];
				}
			}
		}
	}	
}

void updateLight(int num)
{
	double timefrac;
	int i;

	if(lights[num].newtime<=script.curtime)
	{
		for(i=0;i<3;i++)
		{
			lights[num].pos[i] = lights[num].new_pos[i];
			lights[num].col[i] = lights[num].new_col[i];	
			lights[num].old_pos[i] = lights[num].pos[i];
			lights[num].old_col[i] = lights[num].col[i];
		}
		lights[num].oldtime=lights[num].newtime;
		return;
	}

	timefrac = (script.curtime - lights[num].oldtime) / (lights[num].newtime - lights[num].oldtime);

	for(i=0;i<3;i++)
	{
		lights[num].pos[i] =
				(lights[num].new_pos[i] - lights[num].old_pos[i]) * timefrac +
				lights[num].old_pos[i];
		lights[num].col[i] =
				(lights[num].new_col[i] - lights[num].old_col[i]) * timefrac +
				lights[num].old_col[i];
	}
}

/* move this later */
void drawSky(void)
{
	glColor4f(0.3f,0.3f,0.3f,1.0f);
//	glDisable(GL_CULL_FACE);
			/* front */
	glBindTexture(GL_TEXTURE_2D, viewport.sky);
	glBegin(GL_QUADS);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f( 10.0f, 10.0f, 10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f( 10.0f,-10.0f, 10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f(-10.0f,-10.0f, 10.0f);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f(-10.0f, 10.0f, 10.0f);
	glEnd();
			/* back */
	glBindTexture(GL_TEXTURE_2D, viewport.sky+1);
	glBegin(GL_QUADS);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f(-10.0f, 10.0f,-10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f(-10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f( 10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f( 10.0f, 10.0f,-10.0f);
	glEnd();
			/* left */
	glBindTexture(GL_TEXTURE_2D, viewport.sky+2);
	glBegin(GL_QUADS);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f(10.0f, 10.0f,-10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f(10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f(10.0f,-10.0f, 10.0f);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f(10.0f, 10.0f, 10.0f);
	glEnd();
			/* right */
	glBindTexture(GL_TEXTURE_2D, viewport.sky+3);
	glBegin(GL_QUADS);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f(-10.0f, 10.0f, 10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f(-10.0f,-10.0f, 10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f(-10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f(-10.0f, 10.0f,-10.0f);
	glEnd();
				/* up */
	glBindTexture(GL_TEXTURE_2D, viewport.sky+4);
	glBegin(GL_QUADS);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f(-10.0f, 10.0f, 10.0f);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f(-10.0f, 10.0f,-10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f( 10.0f, 10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f( 10.0f, 10.0f, 10.0f);
	glEnd();
			/* down */
	glBindTexture(GL_TEXTURE_2D, viewport.sky+5);
	glBegin(GL_QUADS);
		glTexCoord2f(0.01f, 0.01f);
		glVertex3f( 10.0f,-10.0f, 10.0f);
		glTexCoord2f(0.01f, 0.99f);
		glVertex3f( 10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f(-10.0f,-10.0f,-10.0f);
		glTexCoord2f(0.99f, 0.01f);
		glVertex3f(-10.0f,-10.0f, 10.0f);
	glEnd();
//	glEnable(GL_CULL_FACE);
}
