/* Copyright 1998 by Scott Franke [druid-]
    sfranke@scf.usc.edu
    http://www-scf.usc.edu/~sfranke/glj

	This is a source file for "druid-'s Stonehenge" release version 1.00
	Written for Operation 3DFX's Second programming contest.
*/	

#include "demo.h"

#define CMD_PVP 0				// x/y/z/0/0/0/-
#define CMD_MVP 1				// x/y/z/time/0/0/-
#define CMD_OVP 2				// x/y/z/time/0/0/-
#define CMD_LTX 3				// 0/0/0/height/width/0/-
#define CMD_CTX 4				// 0/0/0/0/0/0/-

#define CMD_LHM 5				// 0/0/0/tex_id/hm_id/lit/filename
#define CMD_RHM 6				// 0/0/0/hm_id/0/0/-
#define CMD_PHM 7				// x/y/z/hm_id/0/0/-
#define CMD_MHM 8				// x/y/z/hm_id/time/0/-
#define CMD_OHM 9				// x/y/z/hm_id/time/0/-

#define CMD_APS 10			// p1/p2/p3/psys_id/type/spawn
#define CMD_SPS 11			// life/rand/scale/psys_id/0/0/-
#define CMD_PPS 12			// x/y/z/psys_id/0/0/-
#define CMD_RPS 13			// 0/0/0/psys_id/0/0/-
#define CMD_NPS 14			// 0/0/0/psys_id/0/0/-
#define CMD_MPS 15			// not in yet

#define CMD_APL 16			// x/y/z/0/0/0/-
#define CMD_AOL 17			// x/y/z/falloff/0/0/-
#define CMD_SLC 18			// r/g/b/light_num/time/0/-
#define CMD_ML  19			// x/y/z/light_num/time/0/-

#define CMD_SKY 20			// 0/0/0/base_tex/0/0/-
#define CMD_BVP 21			// r/g/b/percent/time/0/-

#define CMD_RL  22			// 0/0/0/0/0/0/-

#define CMD_SGV 23			// g/0/0/0/0/0/-

void loadScript (char *file)
{
	FILE *fp;
	int i;
	char buffer[20];

	if ((fp=fopen(file,"r"))==NULL)
	{
		consoleOut("== Unable to open script file.");
		return;
	}

	fscanf(fp,"%i\n", &script.total);
	for(i=0;i<script.total;i++)
	{
		fscanf(fp,"%i",&script.events[i].cmd);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%f",&script.events[i].time);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%f",&script.events[i].fparam[0]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%f",&script.events[i].fparam[1]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%f",&script.events[i].fparam[2]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%i",&script.events[i].iparam[0]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%i",&script.events[i].iparam[1]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%i",&script.events[i].iparam[2]);
			fscanf(fp,"%c",buffer);
		fscanf(fp,"%s",script.events[i].cparam);
	}

	sprintf(buffer, "== %d events loaded\n", script.total);
	consoleOut(buffer);

	script.current = 0;
	script.nextthink = script.events[i].time;
	script.paused = 1;
	num_tex = 3;
	num_mdl = 0;
	num_light = 0;
	script.num_tri = 0;
}

void processScript (double dTime)
{
	if(script.current == 0)
	{
		script.timebegin = timeGetTime();
		script.curtime = 0;
	}

	while(script.nextthink <= script.curtime)
	{
		if(script.current>=script.total)
		{
//			consoleAlert("== Script finished");
			script.scrnum++;
			if(script.scrnum>1)
			{
				done = TRUE;
				PostQuitMessage(0);
			}
			else
			{
				loadScript("demo.hs");
				script.paused=0;
				console.active=0;
			}
//			viewport.fps = 0;
			return;
		}
		
		switch(script.events[script.current].cmd)
		{
			/* Viewport */
		case CMD_PVP:
			cmd_pvp (script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_MVP:
			cmd_mvp (script.events[script.current].iparam[0],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_OVP:
			cmd_ovp (script.events[script.current].iparam[0],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_BVP:
			cmd_bvp (script.events[script.current].iparam[0],
						script.events[script.current].iparam[1],
						script.events[script.current].fparam[0],
						script.events[script.current].fparam[1],
						script.events[script.current].fparam[2]);
			break;

			/* Textures */
		case CMD_LTX:
			cmd_ltx (script.events[script.current].cparam,
					 script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1]);
			break;
		case CMD_CTX:
			cmd_ctx ();
			break;

			/* Models */
		case CMD_LHM:
			cmd_lhm (script.events[script.current].cparam,
					 script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].iparam[2],
					 script.events[script.current].fparam[0]);
			break;
		case CMD_RHM:
			cmd_rhm (script.events[script.current].iparam[0]);
			break;
		case CMD_PHM:
			cmd_phm (script.events[script.current].iparam[0],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_MHM:
			cmd_mhm (script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_OHM:
			cmd_ohm (script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;

			/* Particle Systems */
		case CMD_APS:
			cmd_aps (script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].iparam[2],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_SPS:
			cmd_sps (script.events[script.current].iparam[0],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_PPS:
			cmd_pps (script.events[script.current].iparam[0],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_RPS:
			cmd_rps (script.events[script.current].iparam[0]);
			break;
		case CMD_NPS:
			cmd_nps (script.events[script.current].iparam[0]);
			break;
		case CMD_MPS:
			cmd_mps (script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;

			/* Lights */
		case CMD_APL:
			cmd_apl( script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_AOL:
			cmd_aol( script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2],
					 script.events[script.current].iparam[0]);
			break;
		case CMD_SLC:
			cmd_slc( script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_ML:
			cmd_ml ( script.events[script.current].iparam[0],
					 script.events[script.current].iparam[1],
					 script.events[script.current].fparam[0],
					 script.events[script.current].fparam[1],
					 script.events[script.current].fparam[2]);
			break;
		case CMD_RL:
			cmd_rl ();
			break;

			// SKY
		case CMD_SKY:
			cmd_sky ( script.events[script.current].iparam[0]);
			break;

			// GRAVITY
		case CMD_SGV:
			cmd_sgv ( script.events[script.current].fparam[0]);
			break;
		default:
			break;
		}
		script.current++;
		script.nextthink = script.events[script.current].time;
	}


	return;	
}

/* Place Viewport */
void cmd_pvp(GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	viewport.pos[0] = x; viewport.old_pos[0] = x; viewport.new_pos[0] = x;
	viewport.pos[1] = y; viewport.old_pos[1] = y; viewport.new_pos[1] = y;
	viewport.pos[2] = z; viewport.old_pos[2] = z; viewport.new_pos[2] = z;

	viewport.rot[0] = x; viewport.old_rot[0] = x; viewport.new_rot[0] = x;
	viewport.rot[1] = y; viewport.old_rot[1] = y; viewport.new_rot[1] = y;
	viewport.rot[2] = z; viewport.old_rot[2] = z; viewport.new_rot[2] = z;

	for(i=0;i<3;i++)
		viewport.col[i] = 0.0;
	viewport.flash = 100;

	viewport.oldtime = script.curtime;
	viewport.newtime = script.curtime;
	consoleOut("== Viewport placed");
}
/* Move Viewport */
void cmd_mvp(int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	for(i=0;i<3;i++)
	{
		viewport.pos[i] = viewport.new_pos[i];
		viewport.old_pos[i] = viewport.pos[i];
	}

	viewport.oldtime = script.curtime;
	viewport.newtime = script.curtime + time;
	viewport.new_pos[0] = x;
	viewport.new_pos[1] = y;
	viewport.new_pos[2] = z;

	consoleOut("== Viewport set to move");
}
/* Orient Viewport */
void cmd_ovp(int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	for(i=0;i<3;i++)
	{
		viewport.rot[i] = viewport.new_rot[i];
		viewport.old_rot[i] = viewport.rot[i];
	}

	viewport.oldtime = script.curtime;
	viewport.newtime = script.curtime + time;
	viewport.new_rot[0] = x*DEGTORAD;
	viewport.new_rot[1] = y*DEGTORAD;
	viewport.new_rot[2] = z*DEGTORAD;

	for(i=0;i<3;i++)
		viewport.old_rot[i] = viewport.rot[i];

	consoleOut("== Viewport set to rotate");
}

	/*============= TEXTURES =============*/
/* Add Texture */
void cmd_ltx(char *file, int x, int y)
{
	if(num_tex>20)
	{
		consoleOut("Overflow on texture stack");
		return;
	}

//	glGenTextures(1, &num_tex);
	glBindTexture(GL_TEXTURE_2D, num_tex);
	loadpic(file, x, y, TEXMODE_SOLID);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 4, x, y, GL_RGBA,
		     GL_UNSIGNED_BYTE, &pic[0][0][0]);

	num_tex++;

	consoleOut("== Texture loaded");
}
/* Clear Textures */
void cmd_ctx(void)
{
//	GLuint texs[] = {3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};

//	glDeleteTextures(num_tex-3,texs);

	num_tex = 3;
	consoleOut("== Textures cleared");
}

	/*============= MODELS =============*/
/* Load Model */
void cmd_lhm(char *file, int tex_id, int hm_id, int lit, GLfloat tex_tile)
{
	int i;
	if(num_mdl > 19)
	{
		consoleAlert("Overflow on model stack");
		return;
	}

	i=0;
	while(models[i].inuse)
			i++;
	if(i>19)
	{
		consoleAlert("Could not add mdl");
		return;
	}

	loadHM(file, &models[i]);
	
	models[i].tex_id = tex_id;
	models[i].hm_id  = hm_id;
	models[i].lit = lit;
	models[i].inuse = 1;
	models[i].active = 0;

	if(tex_tile==0)
		models[i].tex_tile = 1.0;
	else
		models[i].tex_tile = tex_tile;

	num_mdl++;

	script.num_tri += models[i].num_tri;

	consoleOut("== Model Loaded");
}
/* Remove Model */
void cmd_rhm(int hm_id)
{
	int i;

	i=0;
	while((models[i].hm_id != hm_id) && (i<20))
			i++;

	if(i>=20)
	{
		consoleAlert("Cannot find hm_id for rhm");
		return;
	}
	if(!models[i].inuse)
	{
		consoleAlert("Error: removing invalid mdl");
		return;
	}

	models[i].inuse = 0;
	models[i].active = 0;

	if(models[i].tris)
		free(models[i].tris);
	if(models[i].tex)
		free(models[i].tex);
	if(models[i].norms)
		free(models[i].norms);
	if(models[i].verts)
		free(models[i].verts);

	num_mdl--;

	consoleOut("== Model removed");
}
/* Place Model */
void cmd_phm(int hm_id, GLfloat x, GLfloat y, GLfloat z)
{
	int i,j;
	i=0;
	while((models[i].hm_id !=hm_id) && (i<20))
		i++;

	if(i>=20)
	{
		consoleAlert("Cannot find hm_id for phm");
		return;
	}
	
	models[i].pos[0] = x; models[i].old_pos[0] = x; models[i].new_pos[0] = x;
	models[i].pos[1] = y; models[i].old_pos[1] = y; models[i].new_pos[1] = y;
	models[i].pos[2] = z; models[i].old_pos[2] = z; models[i].new_pos[2] = z;

	for(j=0;j<3;j++)
	{
		models[i].rot[j] = 0;
		models[i].new_rot[j] = 0;
	}

	models[i].oldtime = script.curtime;
	models[i].newtime = script.curtime;
	models[i].active = 1;

	if(models[i].lit)
		lightHM(&models[i]);

	consoleOut("== Model placed");
}
/* Move Model */
void cmd_mhm(int hm_id, int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i,j;
	i=0;
	while((models[i].hm_id !=hm_id) && (i<20))
		i++;

	if(i>=20)
	{
		consoleAlert("Cannot find hm_id for mhm");
		return;
	}
	
	models[i].oldtime = script.curtime;
	models[i].newtime = script.curtime + time;
	models[i].new_pos[0] = x;
	models[i].new_pos[1] = y;
	models[i].new_pos[2] = z;

	for(j=0;j<3;j++)
		models[i].old_pos[j] = models[i].pos[j];

	if(models[i].lit)
		models[i].lit=2;

	consoleOut("== Model set to move");
}
/* Orient Model */
void cmd_ohm(int hm_id, int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i,j;
	i=0;
	while((models[i].hm_id !=hm_id) && (i<20))
		i++;

	if(i>=20)
	{
		consoleAlert("Cannot find hm_id for ohm");
		return;
	}
	
	models[i].oldtime = script.curtime;
	models[i].newtime = script.curtime + time;
	models[i].new_rot[0] = x;
	models[i].new_rot[1] = y;
	models[i].new_rot[2] = z;

	for(j=0;j<3;j++)
		models[i].old_rot[j] = models[i].rot[j];

	if(models[i].lit)
		models[i].lit = 2;

	consoleOut("== Model set to rotate");
}

		/*  ==== PARTICLE SYSTEMS ==== */
/* Add particle system */
void cmd_aps(int psys_id, int type, int spawn, GLfloat p1, GLfloat p2, GLfloat p3)
{
	if(num_psys>20)
	{
		consoleAlert("Overflow on psys stack");
		return;
	}

	psystems[num_psys].psys_id = psys_id;

	psystems[num_psys].inuse = 1;
	psystems[num_psys].active = 0;

	psystems[num_psys].peType = type;
	psystems[num_psys].spawn = spawn;
	psystems[num_psys].num = 0;
	psystems[num_psys].front = 0;

	psystems[num_psys].ivel[0] = p1;
	psystems[num_psys].ivel[1] = p2;
	psystems[num_psys].ivel[2] = p3;

	psystems[num_psys].time = 0;
	psystems[num_psys].timer = 0;

	switch(type)
	{
	case PE_FIREBALL:
		vectSet(psystems[num_psys].acc, 0.0f, 0.0, 0.0f);
		break;
	case PE_SPRAY:
		vectSet(psystems[num_psys].acc, 0.0f, viewport.grav, 0.0f);
		break;
	case PE_SPARKS:
	case PE_FSPARKS:
		vectSet(psystems[num_psys].acc, 0.0f, viewport.grav, 0.0f);
		break;
	case PE_CYCLONE:
		vectSet(psystems[num_psys].acc, 0.0f, 0.0f, 0.0f);
		break;
	case PE_EXP1:
		vectSet(psystems[num_psys].acc, 0.0f, viewport.grav, 0.0f);
		break;
	}


	num_psys++;
	
	consoleOut("== Psys added");
}
/* Set up particle system */
void cmd_sps(int psys_id, GLfloat life, GLfloat rand, GLfloat scale)
{
	int i;

	i=0;
	while((psystems[i].psys_id != psys_id) && (i<20))
		i++;

	if(i>20)
	{
		consoleAlert("Attempt to set up invalid psys");
		return;
	}

	psystems[i].life = life;
	psystems[i].randomness = rand;
	psystems[i].scale = scale;

	consoleOut("== Psys setup");
}
/* Place particle system */
void cmd_pps(int psys_id, GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	i=0;
	while((psystems[i].psys_id != psys_id) && (i<20))
		i++;

	if(i>20)
	{
		consoleAlert("Attempt to place invalid psys");
		return;
	}

	psystems[i].pos[0] = x; psystems[i].old_pos[0] = x; psystems[i].new_pos[0] = x;
	psystems[i].pos[1] = y; psystems[i].old_pos[1] = y; psystems[i].new_pos[1] = y;
	psystems[i].pos[2] = z; psystems[i].old_pos[2] = z; psystems[i].new_pos[2] = z;

	psystems[i].oldtime = script.curtime;
	psystems[i].newtime = script.curtime;

	psystems[i].time = 0;
	psystems[i].timer = 0;

	psystems[i].active = 1;

	consoleOut("== Psys placed");
}
/* Move Particle system */
void cmd_mps(int psys_id, int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i,j;
	i=0;

	while((psystems[i].psys_id != psys_id) && (i<20))
		i++;

	if(i>=20)
	{
		consoleAlert("Cannot find psys_id for mps");
		return;
	}
	
	psystems[i].oldtime = script.curtime;
	psystems[i].newtime = script.curtime + time;
	psystems[i].new_pos[0] = x;
	psystems[i].new_pos[1] = y;
	psystems[i].new_pos[2] = z;

	for(j=0;j<3;j++)
		psystems[i].old_pos[j] = psystems[i].pos[j];

	consoleOut("== Psys set to move");
}
/* Remove particle system */
void cmd_rps(int psys_id)
{
	int i;

	i=0;
	while((psystems[i].psys_id != psys_id) && (i<20))
		i++;

	if(i>20)
	{
		consoleAlert("Attempt to remove invalid psys");
		return;
	}

	if(!psystems[i].inuse)
		return;

	psystems[i].active = 0;
	psystems[i].inuse = 0;

	num_psys--;

	consoleOut("== Psys removed");
}
/* Neuter particle system */
void cmd_nps(int psys_id)
{
	int i;

	i=0;
	while((psystems[i].psys_id != psys_id) && (i<20))
		i++;

	if(i>20)
	{
		consoleAlert("Attempt to neuter invalid psys");
		return;
	}

	psystems[i].spawn = 0;
}

/* Add parallel light */
void cmd_apl(GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	if(num_light>4)
	{
		consoleAlert("Overflow on light stack");
		return;
	}

	lights[num_light].type = LITE_PARALLEL;

	lights[num_light].pos[0] = x; lights[num_light].old_pos[0] = x; lights[num_light].new_pos[0] = x;
	lights[num_light].pos[1] = y; lights[num_light].old_pos[1] = y; lights[num_light].new_pos[1] = y;
	lights[num_light].pos[2] = z; lights[num_light].old_pos[2] = z; lights[num_light].new_pos[2] = z;

	lights[num_light].oldtime = script.curtime;
	lights[num_light].newtime = script.curtime;

	for(i=0;i<3;i++)
	{
		lights[num_light].col[i] = 0.5f;
		lights[num_light].old_col[i] = 0.5f;
		lights[num_light].new_col[i] = 0.5f;
	}

	num_light++;

	consoleOut("== Parallel light added");
}
/* Add omni light */
void cmd_aol(GLfloat x, GLfloat y, GLfloat z, int falloff)
{
	int i;

	if(num_light>4)
	{
		consoleAlert("Overflow on light stack");
		return;
	}

	lights[num_light].type = LITE_OMNI;
	lights[num_light].falloff = falloff;

	lights[num_light].pos[0] = x; lights[num_light].old_pos[0] = x; lights[num_light].new_pos[0] = x;
	lights[num_light].pos[1] = y; lights[num_light].old_pos[1] = y; lights[num_light].new_pos[1] = y;
	lights[num_light].pos[2] = z; lights[num_light].old_pos[2] = z; lights[num_light].new_pos[2] = z;

	lights[num_light].oldtime = script.curtime;
	lights[num_light].newtime = script.curtime;

	for(i=0;i<3;i++)
	{
		lights[num_light].col[i] = 0.5f;
		lights[num_light].old_col[i] = 0.5f;
		lights[num_light].new_col[i] = 0.5f;
	}

	num_light++;

	consoleOut("== Omni light added");
}
/* Set light Color */
void cmd_slc(int num, int time, GLfloat r, GLfloat g, GLfloat b)
{
	int i;

	if(num >= num_light)
	{
		consoleAlert("Invalid light for slc");
		return;
	}

	for(i=0;i<3;i++)
	{
		lights[num].col[i] = lights[num].new_col[i];
		lights[num].old_col[i] = lights[num].col[i];
	}

	lights[num].new_col[0] = r;
	lights[num].new_col[1] = g;
	lights[num].new_col[2] = b;
	lights[num].oldtime = script.curtime;
	lights[num].newtime = script.curtime + time;

//	updateLight(num);

	consoleOut("== Light color set");
}
/* Move light */
void cmd_ml(int num, int time, GLfloat x, GLfloat y, GLfloat z)
{
	int i;

	if(num >= num_light)
	{
		consoleAlert("Invalid light for ml");
		return;
	}

	for(i=0;i<3;i++)
	{
		lights[num].pos[i] = lights[num].new_pos[i];
		lights[num].old_pos[i] = lights[num].pos[i];
	}

	lights[num].new_pos[0] = x;
	lights[num].new_pos[1] = y;
	lights[num].new_pos[2] = z;
	lights[num].oldtime = script.curtime;
	lights[num].newtime = script.curtime + time;

//	updateLight(num);

	consoleOut("== Light set to move");
}
/* Remove a light */
void cmd_rl(void)
{
	if(num_light<1)
	{
		consoleAlert("No lights to remove");
		return;
	}

	num_light --;
}

/* Setup sky */
void cmd_sky(int num)
{
	viewport.sky = num;

	consoleOut("== Sky set");
}
/* Blend viewport */
void cmd_bvp(int percent, int time, GLfloat r, GLfloat g, GLfloat b)
{
	int i;

	for (i=0;i<3;i++)
	{
		viewport.col[i] = viewport.new_col[i];
		viewport.old_col[i] = viewport.col[i];
	}
	viewport.oldflash = viewport.newflash;
	viewport.oldtime = script.curtime;

	viewport.new_col[0] = r;
	viewport.new_col[1] = g;
	viewport.new_col[2] = b;

	viewport.newflash = percent;

	viewport.newtime = script.curtime + time;

	consoleOut("== Viewport blend set");
}

/* Set Gravity */
void cmd_sgv(GLfloat grav)
{
	viewport.grav = grav;

	consoleOut("== Gravity set");
}
