// OpenGLss.cpp: implementation of the COpenGLss class.
//
//////////////////////////////////////////////////////////////////////

#include "Stdafx.h"
#include "math.h"
#include "OpenGLss.h"
#include <afxmt.h>
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// palette creation stuff

unsigned char threeto8[8] = 
{
	0, 0111>>1, 0222>>1, 0333>>1, 0444>>1, 0555>>1, 0666>>1, 0377
};

unsigned char twoto8[4] = 
{
	0, 0x55, 0xaa, 0xff
};

unsigned char oneto8[2] = 
{
	0, 255
};

static int defaultOverride[13] = 
{
	0, 3, 24, 27, 64, 67, 88, 173, 181, 236, 247, 164, 91
};

static PALETTEENTRY defaultPalEntry[20] = 
{
	{ 0,   0,   0,    0 },
	{ 0x80,0,   0,    0 },
	{ 0,   0x80,0,    0 },
	{ 0x80,0x80,0,    0 },
	{ 0,   0,   0x80, 0 },
	{ 0x80,0,   0x80, 0 },
	{ 0,   0x80,0x80, 0 },
	{ 0xC0,0xC0,0xC0, 0 },

	{ 192, 220, 192,  0 },
	{ 166, 202, 240,  0 },
	{ 255, 251, 240,  0 },
	{ 160, 160, 164,  0 },

	{ 0x80,0x80,0x80, 0 },
	{ 0xFF,0,   0,    0 },
	{ 0,   0xFF,0,    0 },
	{ 0xFF,0xFF,0,    0 },
	{ 0,   0,   0xFF, 0 },
	{ 0xFF,0,   0xFF, 0 },
	{ 0,   0xFF,0xFF, 0 },
	{ 0xFF,0xFF,0xFF, 0 }
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COpenGLss::COpenGLss()
{

	srand(100);
CString m_nPicName = AfxGetApp()->GetProfileString("Config", "Picture", "test.gif");
	m_bBusy=FALSE;
	m_wAngleX=0;
	m_wAngleY=0;
	m_wAngleZ=0;
	m_fRadius=0;

	m_Actions=ssIdle;
	m_pDC = NULL;
	m_pOldPalette = NULL;

	m_bGLRunning=FALSE;
	m_cimage=NULL;
	m_cimage=new CImage(m_nPicName);


	for (int i=0 ; i<MAX_CEL_COLUMN; i++)
		for (int j=0; j<MAX_CEL_ROW;j++)
		{
			m_celarray[i][j]=NULL;
		}

}

COpenGLss::~COpenGLss()
{
	// clean up the mess

	
	DestroyGL();

	if (m_cimage)
		delete m_cimage;

	for (int i=0 ; i<MAX_CEL_COLUMN; i++)
		for (int j=0; j<MAX_CEL_ROW;j++)
		{
			if (m_celarray[i][j])
				delete m_celarray[i][j];
		}

	if (m_pDC)	
		delete m_pDC;


}

void COpenGLss::Init(CWnd* cview)
{
	g_cs.Lock();

    PIXELFORMATDESCRIPTOR pfd;
    int         n;
	HGLRC		hrc;
	GLfloat		fMaxObjSize, fAspect;
	GLfloat		fNearPlane, fFarPlane;
	
	// prevent initializing if already initialized
	if (m_bGLRunning) {
		g_cs.Unlock();
		return;
	}
    
	m_pDC = new CClientDC(cview);

    ASSERT(m_pDC != NULL);

    if (!bSetupPixelFormat())
	{
		g_cs.Unlock();
        return;
	}
    n = ::GetPixelFormat(m_pDC->GetSafeHdc());
    ::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);

    CreateRGBPalette();

    hrc = wglCreateContext(m_pDC->GetSafeHdc());


    if (!wglMakeCurrent(m_pDC->GetSafeHdc(), hrc)) {
		// couldn't init opengl
		g_cs.Unlock();
		return;
	}


    cview->GetClientRect(&m_oldRect);
    
	glClearDepth(1.0f);
	glEnable(GL_BLEND);
    glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	if (m_oldRect.bottom)
		fAspect = (GLfloat)m_oldRect.right/m_oldRect.bottom;
	else	// don't divide by zero, not that we should ever run into that...
		fAspect = 1.0f;
	fNearPlane = 0.01f;
	fFarPlane = MAX_DISTANCE;
	fMaxObjSize = 3.0f;
	m_fRadius = fNearPlane + fMaxObjSize / 2.0f;

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0f, fAspect, fNearPlane, fFarPlane);
    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	int textid=1;
	int i,j;
	if (m_cimage) 
	{

	for (i=0;(i<MAX_CEL_COLUMN&& (i*TEX_WIDTH)<= m_cimage->GetWidth());i++)
		{
			

			for (j=0;(j<MAX_CEL_ROW && (j*TEX_HEIGHT) <= m_cimage->GetHeight());j++)
			{
				m_celarray[i][j]=new CPicCel(m_cimage,i,j,textid);
		
				textid++;
			}
		
		}
	}
	m_particlesx=i;
	
	m_particlesy=j;
	
	m_bGLRunning=TRUE;
	g_cs.Unlock();
}

BOOL COpenGLss::bSetupPixelFormat()
{
    static PIXELFORMATDESCRIPTOR pfd = 
	{
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW |            // support window
          PFD_SUPPORT_OPENGL |          // support OpenGL
          PFD_DOUBLEBUFFER,             // double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        24,                             // 24-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        32,                             // 32-bit z-buffer
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };
    int pixelformat;

    if ( (pixelformat = ChoosePixelFormat(m_pDC->GetSafeHdc(), &pfd)) == 0 )
    {
        //MessageBox("ChoosePixelFormat failed");
        return FALSE;
    }

    if (SetPixelFormat(m_pDC->GetSafeHdc(), pixelformat, &pfd) == FALSE)
    {
        //MessageBox("SetPixelFormat failed");
        return FALSE;
    }

    return TRUE;

}

void COpenGLss::CreateRGBPalette()
{
    PIXELFORMATDESCRIPTOR pfd;
    LOGPALETTE *pPal;
    int n, i;
 
    n = ::GetPixelFormat(m_pDC->GetSafeHdc());
    ::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);

    if (pfd.dwFlags & PFD_NEED_PALETTE)
    {
        n = 1 << pfd.cColorBits;
        pPal = (PLOGPALETTE) new char[sizeof(LOGPALETTE) + n * sizeof(PALETTEENTRY)];

        ASSERT(pPal != NULL);

        pPal->palVersion = 0x300;
        pPal->palNumEntries = n;
        for (i=0; i<n; i++)
        {
            pPal->palPalEntry[i].peRed =
                    ComponentFromIndex(i, pfd.cRedBits, pfd.cRedShift);
            pPal->palPalEntry[i].peGreen =
                    ComponentFromIndex(i, pfd.cGreenBits, pfd.cGreenShift);
            pPal->palPalEntry[i].peBlue =
                    ComponentFromIndex(i, pfd.cBlueBits, pfd.cBlueShift);
            pPal->palPalEntry[i].peFlags = 0;
        }

        /* fix up the palette to include the default GDI palette */
        if ((pfd.cColorBits == 8)                           &&
            (pfd.cRedBits   == 3) && (pfd.cRedShift   == 0) &&
            (pfd.cGreenBits == 3) && (pfd.cGreenShift == 3) &&
            (pfd.cBlueBits  == 2) && (pfd.cBlueShift  == 6)
           )
        {
			for (i = 1 ; i <= 12 ; i++)
                pPal->palPalEntry[defaultOverride[i]] = defaultPalEntry[i];
        }

        m_cPalette.CreatePalette(pPal);
        delete pPal;
		if (m_cimage)
		{
			m_pOldPalette = m_pDC->SelectPalette(m_cimage->GetPalette(), FALSE);//&m_cPalette
	        m_pDC->RealizePalette();
		}
    }

}

unsigned char COpenGLss::ComponentFromIndex(int i, UINT nbits, UINT shift)
{
    unsigned char val;

    val = (unsigned char) (i >> shift);
    switch (nbits) 
	{

    case 1:
        val &= 0x1;
        return oneto8[val];
    case 2:
        val &= 0x3;
        return twoto8[val];
    case 3:
        val &= 0x7;
        return threeto8[val];

    default:
        return 0;
    }

}

void COpenGLss::DestroyGL()
{
	HGLRC	hrc;

	if (m_bGLRunning) {
		m_bGLRunning=FALSE;


		hrc = ::wglGetCurrentContext();

	    ::wglMakeCurrent(NULL,  NULL);

	    if (hrc)
	        ::wglDeleteContext(hrc);

		if (m_pOldPalette)
			m_pDC->SelectPalette(m_pOldPalette, FALSE);

		if (m_pDC)
			delete m_pDC;
			m_pDC=NULL;
	}
}

void COpenGLss::Render()
{

		

	
	if (!m_bGLRunning) 
	{
		//AfxMessageBox("Error: draw while gl not initialized");

		return;
	}
    
	if (m_bBusy) 
		return;
	
	m_bBusy=TRUE;
    
    glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glPushMatrix();

      
    glRotatef(m_wAngleX, 1.0f, 0.0f, 0.0f);
    glRotatef(m_wAngleY, 0.0f, 1.0f, 0.0f);
   	glRotatef(m_wAngleZ, 0.0f, 0.0f, 1.0f);
	glTranslatef(-((float)m_particlesx/2), -((float)m_particlesy/2), -m_fRadius);
		
  
	

		
		for (int i=0;i<MAX_CEL_COLUMN;i++)
		{
			for (int j=0;j<MAX_CEL_ROW;j++)
			{	
				if (m_celarray[i][j])
				{

					m_celarray[i][j]->Render();//offsetx,offsety);
				};
			
			}
			
		}

		

    glPopMatrix();

    glFinish();
//	glFlush();
    SwapBuffers(wglGetCurrentDC());

	m_bBusy=FALSE;
  

}

void COpenGLss::Action()
{
	// this is were the 'dynamic action' takes place
	// there isn't a lot going on at the moment
	// but that may change... don't you think ?

	g_cs.Lock();

	switch (m_Actions)
	{

	case ssIdle:	{
		
		// start new effect 
		// lookup in registry what the users wants us to do
		int effect = AfxGetApp()->GetProfileInt("Config", "Effect", EFFECT_ROTATE);
		if (effect==EFFECT_ROTATE) {
			m_Actions=ssZoomIn;
			m_fRadius=MAX_DISTANCE;	
			m_ActionCounter=0;
		} else 
			if (effect==EFFECT_WAVE) {
			m_Actions =ssColorIn;
			m_fRadius=MIN_DISTANCE;
			m_ActionCounter=0;
			} else if (effect==EFFECT_RANDOM) {
				// choose one of other effects randomly...
			};
		break;
					};
	case ssZoomIn:	{
		m_fRadius-=ZOOM_SPEED;
		if (m_fRadius <= MIN_DISTANCE) {
			m_Actions=ssRotateX;
			m_ActionCounter=0;
		};

		break;
				};
	case ssRotateX:	{

			for (int i=0;i<MAX_CEL_COLUMN;i++)
			{
				for (int j=0;j<MAX_CEL_ROW;j++)
				{	
					if (m_celarray[i][j])
					{

						m_celarray[i][j]->m_angleX+=1.0f;
						m_celarray[i][j]->m_angleY+=1.0f;
						
					};
			
				}
			
			}
			m_ActionCounter++;
			if (m_ActionCounter>= MAX_ROTATE_COUNT)
			{
			
				//reset to zero angle
			for (int i=0;i<MAX_CEL_COLUMN;i++)
			{
				for (int j=0;j<MAX_CEL_ROW;j++)
				{	
					if (m_celarray[i][j])
					{

						m_celarray[i][j]->m_angleX=0.0f;
						m_celarray[i][j]->m_angleY=0.0f;
						
					};
			
				}
			
			}

				m_Actions=ssZoomOut;
			}


			break;
					};
	case ssZoomOut: {
		m_fRadius+=ZOOM_SPEED;
		m_wAngleX+=0.3f;
		m_wAngleY+=0.3f;
		if (m_fRadius >= MAX_DISTANCE)
		{
			m_Actions=ssIdle;
			m_wAngleX=0;
			m_wAngleY=0;

		};
		break;
					};
	case ssColorIn: {
		m_ActionCounter++;

					for (int i=0;i<MAX_CEL_COLUMN;i++)
			{
				for (int j=0;j<MAX_CEL_ROW;j++)
				{	
					if (m_celarray[i][j])
					{

						// This simple sinus creates the wave
						m_celarray[i][j]->m_distance=(float)(-6+3*sin((float)(i*35+j*35+m_ActionCounter)/60));
						
					};
			
				}
			

			}
					if (m_ActionCounter>MAX_COLOR_COUNT) {
				// reset distance attribute for the wave...
	for (int i=0;i<MAX_CEL_COLUMN;i++)
			{
				for (int j=0;j<MAX_CEL_ROW;j++)
				{	
					if (m_celarray[i][j])
					{

						// This simple sinus creates the wave
						m_celarray[i][j]->m_distance=0;
						
					};
			
				}
			

			}

						
						
						
						m_Actions=ssIdle;


					}

					}

		
		
	default:	{
				};
					}

	g_cs.Unlock();
}


//synchronisation events, between window, en worker thread (opengl loop)

CEvent g_eventOpenGLInit;
CEvent g_eventOpenGLStop;
CEvent g_eventOpenGLFinished;	



UINT OpenGLThreadProc(LPVOID pParam)
{
	// Wait for main program until opengl init is wanted
	// NOTE: this wait is blocking

	::WaitForSingleObject(g_eventOpenGLInit,INFINITE);

	
	HDC hDC=::GetDC((HWND)pParam);

	COpenGLss * m_OpenGLss;
		m_OpenGLss = new COpenGLss();
		m_OpenGLss->Init((CWnd*) pParam);

	// Create OpenGL context

	// Run OpenGL drawing loop, until we notice a stop event
	// NOTE: this wait is of course NON-blocking, else 
	// only one frame would be drawn (on exit)

	while (::WaitForSingleObject(g_eventOpenGLStop,0 != WAIT_OBJECT_0))	{

		m_OpenGLss->Action();
		m_OpenGLss->Render();		

	}
	
	if (m_OpenGLss) {
		delete m_OpenGLss;
		m_OpenGLss=NULL;
	}
	
	g_eventOpenGLFinished.SetEvent();	
	
	return 0;
	// thread is finished now
}
